/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.io;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Ascii;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Optional;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Splitter;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.AbstractIterator;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableList;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Lists;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Streams;
import org.rascalmpl.org.rascalmpl.com.google.common.io.ByteSource;
import org.rascalmpl.org.rascalmpl.com.google.common.io.CharSequenceReader;
import org.rascalmpl.org.rascalmpl.com.google.common.io.CharSink;
import org.rascalmpl.org.rascalmpl.com.google.common.io.CharStreams;
import org.rascalmpl.org.rascalmpl.com.google.common.io.Closer;
import org.rascalmpl.org.rascalmpl.com.google.common.io.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.io.LineProcessor;
import org.rascalmpl.org.rascalmpl.com.google.common.io.MultiReader;
import org.rascalmpl.org.rascalmpl.com.google.common.io.ParametricNullness;
import org.rascalmpl.org.rascalmpl.com.google.common.io.ReaderInputStream;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.MustBeClosed;
import org.rascalmpl.org.rascalmpl.java.io.BufferedReader;
import org.rascalmpl.org.rascalmpl.java.io.IOException;
import org.rascalmpl.org.rascalmpl.java.io.InputStream;
import org.rascalmpl.org.rascalmpl.java.io.Reader;
import org.rascalmpl.org.rascalmpl.java.io.StringReader;
import org.rascalmpl.org.rascalmpl.java.io.UncheckedIOException;
import org.rascalmpl.org.rascalmpl.java.io.Writer;
import org.rascalmpl.org.rascalmpl.java.lang.Appendable;
import org.rascalmpl.org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.Readable;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.nio.charset.Charset;
import org.rascalmpl.org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.org.rascalmpl.java.util.Iterator;
import org.rascalmpl.org.rascalmpl.java.util.function.Consumer;
import org.rascalmpl.org.rascalmpl.java.util.stream.Stream;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public abstract class CharSource
extends Object {
    protected CharSource() {
    }

    public ByteSource asByteSource(Charset charset) {
        return new AsByteSource(charset);
    }

    public abstract Reader openStream() throws IOException;

    public BufferedReader openBufferedStream() throws IOException {
        Reader reader = this.openStream();
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    /*
     * Exception decompiling
     */
    @MustBeClosed
    public Stream<String> lines() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.org.rascalmpl.java.lang.invoke.MethodType, got ()V
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Optional<org.rascalmpl.org.rascalmpl.java.lang.Long> lengthIfKnown() {
        return Optional.absent();
    }

    public long length() throws IOException {
        Optional<org.rascalmpl.org.rascalmpl.java.lang.Long> lengthIfKnown = this.lengthIfKnown();
        if (lengthIfKnown.isPresent()) {
            return lengthIfKnown.get().longValue();
        }
        try (Closer closer = Closer.create();){
            Reader reader = closer.register(this.openStream());
            long l = this.countBySkipping(reader);
            return l;
        }
    }

    private long countBySkipping(Reader reader) throws IOException {
        long read;
        long count = 0L;
        while ((read = reader.skip(Long.MAX_VALUE)) != 0L) {
            count += read;
        }
        return count;
    }

    @CanIgnoreReturnValue
    public long copyTo(Appendable appendable) throws IOException {
        Preconditions.checkNotNull(appendable);
        try (Closer closer = Closer.create();){
            Reader reader = closer.register(this.openStream());
            long l = CharStreams.copy((Readable)reader, appendable);
            return l;
        }
    }

    @CanIgnoreReturnValue
    public long copyTo(CharSink sink) throws IOException {
        Preconditions.checkNotNull(sink);
        try (Closer closer = Closer.create();){
            Reader reader = closer.register(this.openStream());
            Writer writer = closer.register(sink.openStream());
            long l = CharStreams.copy((Readable)reader, (Appendable)writer);
            return l;
        }
    }

    public String read() throws IOException {
        try (Closer closer = Closer.create();){
            Reader reader = closer.register(this.openStream());
            String string = CharStreams.toString((Readable)reader);
            return string;
        }
    }

    @CheckForNull
    public String readFirstLine() throws IOException {
        try (Closer closer = Closer.create();){
            BufferedReader reader = closer.register(this.openBufferedStream());
            String string = reader.readLine();
            return string;
        }
    }

    public ImmutableList<String> readLines() throws IOException {
        try (Closer closer = Closer.create();){
            String line;
            BufferedReader reader = closer.register(this.openBufferedStream());
            ArrayList result = Lists.newArrayList();
            while ((line = reader.readLine()) != null) {
                result.add((Object)line);
            }
            ImmutableList<String> immutableList = ImmutableList.copyOf(result);
            return immutableList;
        }
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    public <T extends Object> T readLines(LineProcessor<T> processor) throws IOException {
        Preconditions.checkNotNull(processor);
        try (Closer closer = Closer.create();){
            Reader reader = closer.register(this.openStream());
            T t2 = CharStreams.readLines((Readable)reader, processor);
            return t2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void forEachLine(Consumer<? super String> action) throws IOException {
        try {
            Stream<String> lines = this.lines();
            try {
                lines.forEachOrdered(action);
                if (lines == null) return;
            }
            catch (Throwable throwable) {
                if (lines == null) throw throwable;
                try {
                    lines.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            lines.close();
            return;
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public boolean isEmpty() throws IOException {
        Optional<org.rascalmpl.org.rascalmpl.java.lang.Long> lengthIfKnown = this.lengthIfKnown();
        if (lengthIfKnown.isPresent()) {
            return lengthIfKnown.get().longValue() == 0L;
        }
        try (Closer closer = Closer.create();){
            Reader reader = closer.register(this.openStream());
            boolean bl = reader.read() == -1;
            return bl;
        }
    }

    public static CharSource concat(Iterable<? extends CharSource> sources) {
        return new ConcatenatedCharSource(sources);
    }

    public static CharSource concat(Iterator<? extends CharSource> sources) {
        return CharSource.concat(ImmutableList.copyOf(sources));
    }

    public static CharSource concat(CharSource ... sources) {
        return CharSource.concat((Iterable<? extends CharSource>)ImmutableList.copyOf((Object[])sources));
    }

    public static CharSource wrap(CharSequence charSequence) {
        return charSequence instanceof String ? new StringCharSource((String)charSequence) : new CharSequenceCharSource(charSequence);
    }

    public static CharSource empty() {
        return EmptyCharSource.INSTANCE;
    }

    private static /* synthetic */ void lambda$lines$0(BufferedReader reader) {
        try {
            reader.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static final class ConcatenatedCharSource
    extends CharSource {
        private final Iterable<? extends CharSource> sources;

        ConcatenatedCharSource(Iterable<? extends CharSource> sources) {
            this.sources = Preconditions.checkNotNull(sources);
        }

        @Override
        public Reader openStream() throws IOException {
            return new MultiReader((Iterator<? extends CharSource>)this.sources.iterator());
        }

        @Override
        public boolean isEmpty() throws IOException {
            for (CharSource source : this.sources) {
                if (source.isEmpty()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Optional<org.rascalmpl.org.rascalmpl.java.lang.Long> lengthIfKnown() {
            long result = 0L;
            for (CharSource source : this.sources) {
                Optional<org.rascalmpl.org.rascalmpl.java.lang.Long> lengthIfKnown = source.lengthIfKnown();
                if (!lengthIfKnown.isPresent()) {
                    return Optional.absent();
                }
                result += lengthIfKnown.get().longValue();
            }
            return Optional.of(org.rascalmpl.org.rascalmpl.java.lang.Long.valueOf((long)result));
        }

        @Override
        public long length() throws IOException {
            long result = 0L;
            for (CharSource source : this.sources) {
                result += source.length();
            }
            return result;
        }

        public String toString() {
            return new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.CharSource.concat(").append(this.sources).append((String)"org.rascalmpl.org.rascalmpl.)").toString();
        }
    }

    private static final class EmptyCharSource
    extends StringCharSource {
        private static final EmptyCharSource INSTANCE = new EmptyCharSource();

        private EmptyCharSource() {
            super((String)"org.rascalmpl.org.rascalmpl.");
        }

        @Override
        public String toString() {
            return "org.rascalmpl.org.rascalmpl.CharSource.empty()";
        }
    }

    private static class StringCharSource
    extends CharSequenceCharSource {
        protected StringCharSource(String seq) {
            super((CharSequence)seq);
        }

        @Override
        public Reader openStream() {
            return new StringReader((String)this.seq);
        }

        @Override
        public long copyTo(Appendable appendable) throws IOException {
            appendable.append(this.seq);
            return this.seq.length();
        }

        @Override
        public long copyTo(CharSink sink) throws IOException {
            Preconditions.checkNotNull(sink);
            try (Closer closer = Closer.create();){
                Writer writer = closer.register(sink.openStream());
                writer.write((String)this.seq);
                long l = this.seq.length();
                return l;
            }
        }
    }

    private static class CharSequenceCharSource
    extends CharSource {
        private static final Splitter LINE_SPLITTER = Splitter.onPattern((String)"org.rascalmpl.org.rascalmpl.\r\n|\n|\r");
        protected final CharSequence seq;

        protected CharSequenceCharSource(CharSequence seq) {
            this.seq = Preconditions.checkNotNull(seq);
        }

        @Override
        public Reader openStream() {
            return new CharSequenceReader(this.seq);
        }

        @Override
        public String read() {
            return this.seq.toString();
        }

        @Override
        public boolean isEmpty() {
            return this.seq.length() == 0;
        }

        @Override
        public long length() {
            return this.seq.length();
        }

        @Override
        public Optional<org.rascalmpl.org.rascalmpl.java.lang.Long> lengthIfKnown() {
            return Optional.of(org.rascalmpl.org.rascalmpl.java.lang.Long.valueOf((long)this.seq.length()));
        }

        private Iterator<String> linesIterator() {
            return new AbstractIterator<String>(){
                Iterator<String> lines;
                {
                    this.lines = LINE_SPLITTER.split(seq).iterator();
                }

                @Override
                @CheckForNull
                protected String computeNext() {
                    if (this.lines.hasNext()) {
                        String next = (String)this.lines.next();
                        if (this.lines.hasNext() || !next.isEmpty()) {
                            return next;
                        }
                    }
                    return (String)this.endOfData();
                }
            };
        }

        @Override
        public Stream<String> lines() {
            return Streams.stream(this.linesIterator());
        }

        @Override
        @CheckForNull
        public String readFirstLine() {
            Iterator<String> lines = this.linesIterator();
            return lines.hasNext() ? (String)lines.next() : null;
        }

        @Override
        public ImmutableList<String> readLines() {
            return ImmutableList.copyOf(this.linesIterator());
        }

        @Override
        @ParametricNullness
        public <T extends Object> T readLines(LineProcessor<T> processor) throws IOException {
            Iterator<String> lines = this.linesIterator();
            while (lines.hasNext() && processor.processLine((String)lines.next())) {
            }
            return processor.getResult();
        }

        public String toString() {
            return new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.CharSource.wrap(").append(Ascii.truncate(this.seq, 30, (String)"org.rascalmpl.org.rascalmpl....")).append((String)"org.rascalmpl.org.rascalmpl.)").toString();
        }
    }

    private final class AsByteSource
    extends ByteSource {
        final Charset charset;

        AsByteSource(Charset charset) {
            this.charset = Preconditions.checkNotNull(charset);
        }

        @Override
        public CharSource asCharSource(Charset charset) {
            if (charset.equals((Object)this.charset)) {
                return CharSource.this;
            }
            return super.asCharSource(charset);
        }

        @Override
        public InputStream openStream() throws IOException {
            return new ReaderInputStream(CharSource.this.openStream(), this.charset, 8192);
        }

        public String toString() {
            return new StringBuilder().append(CharSource.this.toString()).append((String)"org.rascalmpl.org.rascalmpl..asByteSource(").append((Object)this.charset).append((String)"org.rascalmpl.org.rascalmpl.)").toString();
        }
    }
}

