/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.io;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.Beta;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.VisibleForTesting;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.io.ByteSource;
import org.rascalmpl.org.rascalmpl.com.google.common.io.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.io.TempFileCreator;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.concurrent.GuardedBy;
import org.rascalmpl.org.rascalmpl.java.io.ByteArrayInputStream;
import org.rascalmpl.org.rascalmpl.java.io.ByteArrayOutputStream;
import org.rascalmpl.org.rascalmpl.java.io.File;
import org.rascalmpl.org.rascalmpl.java.io.FileInputStream;
import org.rascalmpl.org.rascalmpl.java.io.FileOutputStream;
import org.rascalmpl.org.rascalmpl.java.io.IOException;
import org.rascalmpl.org.rascalmpl.java.io.InputStream;
import org.rascalmpl.org.rascalmpl.java.io.OutputStream;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.System;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.util.Objects;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@Beta
@J2ktIncompatible
@GwtIncompatible
public final class FileBackedOutputStream
extends OutputStream {
    private final int fileThreshold;
    private final boolean resetOnFinalize;
    private final ByteSource source;
    @GuardedBy(value="org.rascalmpl.org.rascalmpl.this")
    private OutputStream out;
    @CheckForNull
    @GuardedBy(value="org.rascalmpl.org.rascalmpl.this")
    private MemoryOutput memory;
    @CheckForNull
    @GuardedBy(value="org.rascalmpl.org.rascalmpl.this")
    private File file;

    @CheckForNull
    @VisibleForTesting
    synchronized File getFile() {
        return this.file;
    }

    public FileBackedOutputStream(int fileThreshold) {
        this(fileThreshold, false);
    }

    public FileBackedOutputStream(int fileThreshold, boolean resetOnFinalize) {
        Preconditions.checkArgument(fileThreshold >= 0, (String)"org.rascalmpl.org.rascalmpl.fileThreshold must be non-negative, but was %s", fileThreshold);
        this.fileThreshold = fileThreshold;
        this.resetOnFinalize = resetOnFinalize;
        this.memory = new MemoryOutput();
        this.out = this.memory;
        this.source = resetOnFinalize ? new ByteSource(){

            @Override
            public InputStream openStream() throws IOException {
                return FileBackedOutputStream.this.openInputStream();
            }

            protected void finalize() {
                try {
                    FileBackedOutputStream.this.reset();
                }
                catch (Throwable t2) {
                    t2.printStackTrace(System.err);
                }
            }
        } : new ByteSource(){

            @Override
            public InputStream openStream() throws IOException {
                return FileBackedOutputStream.this.openInputStream();
            }
        };
    }

    public ByteSource asByteSource() {
        return this.source;
    }

    private synchronized InputStream openInputStream() throws IOException {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        Objects.requireNonNull((org.rascalmpl.org.rascalmpl.java.lang.Object)this.memory);
        return new ByteArrayInputStream(this.memory.getBuffer(), 0, this.memory.getCount());
    }

    public synchronized void reset() throws IOException {
        try {
            this.close();
        }
        finally {
            if (this.memory == null) {
                this.memory = new MemoryOutput();
            } else {
                this.memory.reset();
            }
            this.out = this.memory;
            if (this.file != null) {
                File deleteMe = this.file;
                this.file = null;
                if (!deleteMe.delete()) {
                    throw new IOException(new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.Could not delete: ").append((org.rascalmpl.org.rascalmpl.java.lang.Object)deleteMe).toString());
                }
            }
        }
    }

    public synchronized void write(int b) throws IOException {
        this.update(1);
        this.out.write(b);
    }

    public synchronized void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.update(len);
        this.out.write(b, off, len);
    }

    public synchronized void close() throws IOException {
        this.out.close();
    }

    public synchronized void flush() throws IOException {
        this.out.flush();
    }

    @GuardedBy(value="org.rascalmpl.org.rascalmpl.this")
    private void update(int len) throws IOException {
        if (this.memory != null && this.memory.getCount() + len > this.fileThreshold) {
            File temp = TempFileCreator.INSTANCE.createTempFile((String)"org.rascalmpl.org.rascalmpl.FileBackedOutputStream");
            if (this.resetOnFinalize) {
                temp.deleteOnExit();
            }
            try {
                FileOutputStream transfer = new FileOutputStream(temp);
                transfer.write(this.memory.getBuffer(), 0, this.memory.getCount());
                transfer.flush();
                this.out = transfer;
            }
            catch (IOException e) {
                temp.delete();
                throw e;
            }
            this.file = temp;
            this.memory = null;
        }
    }

    private static class MemoryOutput
    extends ByteArrayOutputStream {
        private MemoryOutput() {
        }

        byte[] getBuffer() {
            return this.buf;
        }

        int getCount() {
            return this.count;
        }
    }
}

