/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.math;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.math.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.org.rascalmpl.java.lang.ArithmeticException;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.math.BigInteger;
import org.rascalmpl.org.rascalmpl.java.math.RoundingMode;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class MathPreconditions
extends Object {
    @CanIgnoreReturnValue
    static int checkPositive(String role, int x) {
        if (x <= 0) {
            throw new IllegalArgumentException(new StringBuilder().append(role).append((String)"org.rascalmpl.org.rascalmpl. (").append(x).append((String)"org.rascalmpl.org.rascalmpl.) must be > 0").toString());
        }
        return x;
    }

    @CanIgnoreReturnValue
    static long checkPositive(String role, long x) {
        if (x <= 0L) {
            throw new IllegalArgumentException(new StringBuilder().append(role).append((String)"org.rascalmpl.org.rascalmpl. (").append(x).append((String)"org.rascalmpl.org.rascalmpl.) must be > 0").toString());
        }
        return x;
    }

    @CanIgnoreReturnValue
    static BigInteger checkPositive(String role, BigInteger x) {
        if (x.signum() <= 0) {
            throw new IllegalArgumentException(new StringBuilder().append(role).append((String)"org.rascalmpl.org.rascalmpl. (").append((Object)x).append((String)"org.rascalmpl.org.rascalmpl.) must be > 0").toString());
        }
        return x;
    }

    @CanIgnoreReturnValue
    static int checkNonNegative(String role, int x) {
        if (x < 0) {
            throw new IllegalArgumentException(new StringBuilder().append(role).append((String)"org.rascalmpl.org.rascalmpl. (").append(x).append((String)"org.rascalmpl.org.rascalmpl.) must be >= 0").toString());
        }
        return x;
    }

    @CanIgnoreReturnValue
    static long checkNonNegative(String role, long x) {
        if (x < 0L) {
            throw new IllegalArgumentException(new StringBuilder().append(role).append((String)"org.rascalmpl.org.rascalmpl. (").append(x).append((String)"org.rascalmpl.org.rascalmpl.) must be >= 0").toString());
        }
        return x;
    }

    @CanIgnoreReturnValue
    static BigInteger checkNonNegative(String role, BigInteger x) {
        if (x.signum() < 0) {
            throw new IllegalArgumentException(new StringBuilder().append(role).append((String)"org.rascalmpl.org.rascalmpl. (").append((Object)x).append((String)"org.rascalmpl.org.rascalmpl.) must be >= 0").toString());
        }
        return x;
    }

    @CanIgnoreReturnValue
    static double checkNonNegative(String role, double x) {
        if (!(x >= 0.0)) {
            throw new IllegalArgumentException(new StringBuilder().append(role).append((String)"org.rascalmpl.org.rascalmpl. (").append(x).append((String)"org.rascalmpl.org.rascalmpl.) must be >= 0").toString());
        }
        return x;
    }

    static void checkRoundingUnnecessary(boolean condition) {
        if (!condition) {
            throw new ArithmeticException((String)"org.rascalmpl.org.rascalmpl.mode was UNNECESSARY, but rounding was necessary");
        }
    }

    static void checkInRangeForRoundingInputs(boolean condition, double input, RoundingMode mode) {
        if (!condition) {
            throw new ArithmeticException(new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.rounded value is out of range for input ").append(input).append((String)"org.rascalmpl.org.rascalmpl. and rounding mode ").append((Object)mode).toString());
        }
    }

    static void checkNoOverflow(boolean condition, String methodName, int a, int b) {
        if (!condition) {
            throw new ArithmeticException(new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.overflow: ").append(methodName).append((String)"org.rascalmpl.org.rascalmpl.(").append(a).append((String)"org.rascalmpl.org.rascalmpl., ").append(b).append((String)"org.rascalmpl.org.rascalmpl.)").toString());
        }
    }

    static void checkNoOverflow(boolean condition, String methodName, long a, long b) {
        if (!condition) {
            throw new ArithmeticException(new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.overflow: ").append(methodName).append((String)"org.rascalmpl.org.rascalmpl.(").append(a).append((String)"org.rascalmpl.org.rascalmpl., ").append(b).append((String)"org.rascalmpl.org.rascalmpl.)").toString());
        }
    }

    private MathPreconditions() {
    }
}

