/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.primitives;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Converter;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Strings;
import org.rascalmpl.org.rascalmpl.com.google.common.primitives.DoublesMethodsForWeb;
import org.rascalmpl.org.rascalmpl.com.google.common.primitives.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.java.io.Serializable;
import org.rascalmpl.org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.org.rascalmpl.java.lang.Enum;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.org.rascalmpl.java.lang.Math;
import org.rascalmpl.org.rascalmpl.java.lang.Number;
import org.rascalmpl.org.rascalmpl.java.lang.NumberFormatException;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.System;
import org.rascalmpl.org.rascalmpl.java.util.AbstractList;
import org.rascalmpl.org.rascalmpl.java.util.Arrays;
import org.rascalmpl.org.rascalmpl.java.util.Collection;
import org.rascalmpl.org.rascalmpl.java.util.Collections;
import org.rascalmpl.org.rascalmpl.java.util.Comparator;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.RandomAccess;
import org.rascalmpl.org.rascalmpl.java.util.Spliterator;
import org.rascalmpl.org.rascalmpl.java.util.Spliterators;
import org.rascalmpl.org.rascalmpl.java.util.regex.Pattern;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Doubles
extends DoublesMethodsForWeb {
    public static final int BYTES = 8;
    @GwtIncompatible
    static final Pattern FLOATING_POINT_PATTERN = Doubles.fpPattern();

    private Doubles() {
    }

    public static int hashCode(double value) {
        return org.rascalmpl.org.rascalmpl.java.lang.Double.valueOf((double)value).hashCode();
    }

    public static int compare(double a, double b) {
        return org.rascalmpl.org.rascalmpl.java.lang.Double.compare((double)a, (double)b);
    }

    public static boolean isFinite(double value) {
        return Double.NEGATIVE_INFINITY < value && value < Double.POSITIVE_INFINITY;
    }

    public static boolean contains(double[] array, double target) {
        for (double value : array) {
            if (value != target) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(double[] array, double target) {
        return Doubles.indexOf(array, target, 0, array.length);
    }

    private static int indexOf(double[] array, double target, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(double[] array, double[] target) {
        Preconditions.checkNotNull(array, (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.array");
        Preconditions.checkNotNull(target, (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < array.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(double[] array, double target) {
        return Doubles.lastIndexOf(array, target, 0, array.length);
    }

    private static int lastIndexOf(double[] array, double target, int start, int end) {
        for (int i = end - 1; i >= start; --i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    @GwtIncompatible(value="org.rascalmpl.org.rascalmpl.Available in GWT! Annotation is to avoid conflict with GWT specialization of base class.")
    public static double min(double ... array) {
        Preconditions.checkArgument(array.length > 0);
        double min2 = array[0];
        for (int i = 1; i < array.length; ++i) {
            min2 = Math.min((double)min2, (double)array[i]);
        }
        return min2;
    }

    @GwtIncompatible(value="org.rascalmpl.org.rascalmpl.Available in GWT! Annotation is to avoid conflict with GWT specialization of base class.")
    public static double max(double ... array) {
        Preconditions.checkArgument(array.length > 0);
        double max = array[0];
        for (int i = 1; i < array.length; ++i) {
            max = Math.max((double)max, (double)array[i]);
        }
        return max;
    }

    public static double constrainToRange(double value, double min2, double max) {
        if (min2 <= max) {
            return Math.min((double)Math.max((double)value, (double)min2), (double)max);
        }
        throw new IllegalArgumentException(Strings.lenientFormat((String)"org.rascalmpl.org.rascalmpl.min (%s) must be less than or equal to max (%s)", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{org.rascalmpl.org.rascalmpl.java.lang.Double.valueOf((double)min2), org.rascalmpl.org.rascalmpl.java.lang.Double.valueOf((double)max)}));
    }

    public static double[] concat(double[] ... arrays) {
        int length = 0;
        for (double[] array : arrays) {
            length += array.length;
        }
        double[] result = new double[length];
        int pos = 0;
        for (double[] array : arrays) {
            System.arraycopy((org.rascalmpl.org.rascalmpl.java.lang.Object)array, (int)0, (org.rascalmpl.org.rascalmpl.java.lang.Object)result, (int)pos, (int)array.length);
            pos += array.length;
        }
        return result;
    }

    public static Converter<String, org.rascalmpl.org.rascalmpl.java.lang.Double> stringConverter() {
        return DoubleConverter.INSTANCE;
    }

    public static double[] ensureCapacity(double[] array, int minLength, int padding) {
        Preconditions.checkArgument(minLength >= 0, (String)"org.rascalmpl.org.rascalmpl.Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, (String)"org.rascalmpl.org.rascalmpl.Invalid padding: %s", padding);
        return array.length < minLength ? Arrays.copyOf((double[])array, (int)(minLength + padding)) : array;
    }

    public static String join(String separator, double ... array) {
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "org.rascalmpl.org.rascalmpl.";
        }
        StringBuilder builder = new StringBuilder(array.length * 12);
        builder.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            builder.append(separator).append(array[i]);
        }
        return builder.toString();
    }

    public static Comparator<double[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sortDescending(double[] array) {
        Preconditions.checkNotNull(array);
        Doubles.sortDescending(array, 0, array.length);
    }

    public static void sortDescending(double[] array, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        Arrays.sort((double[])array, (int)fromIndex, (int)toIndex);
        Doubles.reverse(array, fromIndex, toIndex);
    }

    public static void reverse(double[] array) {
        Preconditions.checkNotNull(array);
        Doubles.reverse(array, 0, array.length);
    }

    public static void reverse(double[] array, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        int i = fromIndex;
        for (int j = toIndex - 1; i < j; ++i, --j) {
            double tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
        }
    }

    public static void rotate(double[] array, int distance) {
        Doubles.rotate(array, distance, 0, array.length);
    }

    public static void rotate(double[] array, int distance, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        if (array.length <= 1) {
            return;
        }
        int length = toIndex - fromIndex;
        int m4 = -distance % length;
        m4 = m4 < 0 ? m4 + length : m4;
        int newFirstIndex = m4 + fromIndex;
        if (newFirstIndex == fromIndex) {
            return;
        }
        Doubles.reverse(array, fromIndex, newFirstIndex);
        Doubles.reverse(array, newFirstIndex, toIndex);
        Doubles.reverse(array, fromIndex, toIndex);
    }

    public static double[] toArray(Collection<? extends Number> collection) {
        if (collection instanceof DoubleArrayAsList) {
            return ((DoubleArrayAsList)collection).toDoubleArray();
        }
        org.rascalmpl.org.rascalmpl.java.lang.Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        double[] array = new double[len];
        for (int i = 0; i < len; ++i) {
            array[i] = ((Number)Preconditions.checkNotNull(boxedArray[i])).doubleValue();
        }
        return array;
    }

    public static List<org.rascalmpl.org.rascalmpl.java.lang.Double> asList(double ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new DoubleArrayAsList(backingArray);
    }

    @GwtIncompatible
    private static Pattern fpPattern() {
        java.lang.String decimal = "org.rascalmpl.org.rascalmpl.(?:\\d+#(?:\\.\\d*#)?|\\.\\d+#)";
        String completeDec = new StringBuilder().append((String)decimal).append((String)"org.rascalmpl.org.rascalmpl.(?:[eE][+-]?\\d+#)?[fFdD]?").toString();
        java.lang.String hex = "org.rascalmpl.org.rascalmpl.(?:[0-9a-fA-F]+#(?:\\.[0-9a-fA-F]*#)?|\\.[0-9a-fA-F]+#)";
        String completeHex = new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.0[xX]").append((String)hex).append((String)"org.rascalmpl.org.rascalmpl.[pP][+-]?\\d+#[fFdD]?").toString();
        String fpPattern = new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.[+-]?(?:NaN|Infinity|").append(completeDec).append((String)"org.rascalmpl.org.rascalmpl.|").append(completeHex).append((String)"org.rascalmpl.org.rascalmpl.)").toString();
        fpPattern = fpPattern.replace((CharSequence)"org.rascalmpl.org.rascalmpl.#", (CharSequence)"org.rascalmpl.org.rascalmpl.+");
        return Pattern.compile((String)fpPattern);
    }

    @CheckForNull
    @GwtIncompatible
    public static org.rascalmpl.org.rascalmpl.java.lang.Double tryParse(String string) {
        if (FLOATING_POINT_PATTERN.matcher((CharSequence)string).matches()) {
            try {
                return org.rascalmpl.org.rascalmpl.java.lang.Double.valueOf((double)org.rascalmpl.org.rascalmpl.java.lang.Double.parseDouble((String)string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @GwtCompatible
    private static class DoubleArrayAsList
    extends AbstractList<org.rascalmpl.org.rascalmpl.java.lang.Double>
    implements RandomAccess,
    Serializable {
        final double[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        DoubleArrayAsList(double[] array) {
            this(array, 0, array.length);
        }

        DoubleArrayAsList(double[] array, int start, int end) {
            this.array = array;
            this.start = start;
            this.end = end;
        }

        public int size() {
            return this.end - this.start;
        }

        public boolean isEmpty() {
            return false;
        }

        public org.rascalmpl.org.rascalmpl.java.lang.Double get(int index) {
            Preconditions.checkElementIndex(index, this.size());
            return org.rascalmpl.org.rascalmpl.java.lang.Double.valueOf((double)this.array[this.start + index]);
        }

        public Spliterator.OfDouble spliterator() {
            return Spliterators.spliterator((double[])this.array, (int)this.start, (int)this.end, (int)0);
        }

        public boolean contains(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object target) {
            return target instanceof org.rascalmpl.org.rascalmpl.java.lang.Double && Doubles.indexOf(this.array, ((org.rascalmpl.org.rascalmpl.java.lang.Double)target).doubleValue(), this.start, this.end) != -1;
        }

        public int indexOf(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object target) {
            int i;
            if (target instanceof org.rascalmpl.org.rascalmpl.java.lang.Double && (i = Doubles.indexOf(this.array, ((org.rascalmpl.org.rascalmpl.java.lang.Double)target).doubleValue(), this.start, this.end)) >= 0) {
                return i - this.start;
            }
            return -1;
        }

        public int lastIndexOf(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object target) {
            int i;
            if (target instanceof org.rascalmpl.org.rascalmpl.java.lang.Double && (i = Doubles.lastIndexOf(this.array, ((org.rascalmpl.org.rascalmpl.java.lang.Double)target).doubleValue(), this.start, this.end)) >= 0) {
                return i - this.start;
            }
            return -1;
        }

        public org.rascalmpl.org.rascalmpl.java.lang.Double set(int index, org.rascalmpl.org.rascalmpl.java.lang.Double element) {
            Preconditions.checkElementIndex(index, this.size());
            double oldValue = this.array[this.start + index];
            this.array[this.start + index] = Preconditions.checkNotNull(element).doubleValue();
            return org.rascalmpl.org.rascalmpl.java.lang.Double.valueOf((double)oldValue);
        }

        public List<org.rascalmpl.org.rascalmpl.java.lang.Double> subList(int fromIndex, int toIndex) {
            int size = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, size);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new DoubleArrayAsList(this.array, this.start + fromIndex, this.start + toIndex);
        }

        public boolean equals(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof DoubleArrayAsList) {
                DoubleArrayAsList that = (DoubleArrayAsList)object;
                int size = this.size();
                if (that.size() != size) {
                    return false;
                }
                for (int i = 0; i < size; ++i) {
                    if (this.array[this.start + i] == that.array[that.start + i]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        public int hashCode() {
            int result = 1;
            for (int i = this.start; i < this.end; ++i) {
                result = 31 * result + Doubles.hashCode(this.array[i]);
            }
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.size() * 12);
            builder.append('[').append(this.array[this.start]);
            for (int i = this.start + 1; i < this.end; ++i) {
                builder.append((String)"org.rascalmpl.org.rascalmpl., ").append(this.array[i]);
            }
            return builder.append(']').toString();
        }

        double[] toDoubleArray() {
            return Arrays.copyOfRange((double[])this.array, (int)this.start, (int)this.end);
        }
    }

    private static final class LexicographicalComparator
    extends Enum<LexicographicalComparator>
    implements Comparator<double[]> {
        public static final /* enum */ LexicographicalComparator INSTANCE = new LexicographicalComparator((String)"org.rascalmpl.org.rascalmpl.INSTANCE", 0);
        private static final /* synthetic */ LexicographicalComparator[] $VALUES;

        public static LexicographicalComparator[] values() {
            return (LexicographicalComparator[])$VALUES.clone();
        }

        public static LexicographicalComparator valueOf(String name) {
            return (LexicographicalComparator)Enum.valueOf(LexicographicalComparator.class, (String)name);
        }

        private LexicographicalComparator() {
            super((String)string, n);
        }

        public int compare(double[] left, double[] right) {
            int minLength = Math.min((int)left.length, (int)right.length);
            for (int i = 0; i < minLength; ++i) {
                int result = org.rascalmpl.org.rascalmpl.java.lang.Double.compare((double)left[i], (double)right[i]);
                if (result == 0) continue;
                return result;
            }
            return left.length - right.length;
        }

        public String toString() {
            return "org.rascalmpl.org.rascalmpl.Doubles.lexicographicalComparator()";
        }

        static {
            $VALUES = new LexicographicalComparator[]{INSTANCE};
        }
    }

    private static final class DoubleConverter
    extends Converter<String, org.rascalmpl.org.rascalmpl.java.lang.Double>
    implements Serializable {
        static final Converter<String, org.rascalmpl.org.rascalmpl.java.lang.Double> INSTANCE = new DoubleConverter();
        private static final long serialVersionUID = 1L;

        private DoubleConverter() {
        }

        @Override
        protected org.rascalmpl.org.rascalmpl.java.lang.Double doForward(String value) {
            return org.rascalmpl.org.rascalmpl.java.lang.Double.valueOf((String)value);
        }

        @Override
        protected String doBackward(org.rascalmpl.org.rascalmpl.java.lang.Double value) {
            return value.toString();
        }

        public String toString() {
            return "org.rascalmpl.org.rascalmpl.Doubles.stringConverter()";
        }

        private org.rascalmpl.org.rascalmpl.java.lang.Object readResolve() {
            return INSTANCE;
        }
    }
}

