/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.primitives;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Converter;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Strings;
import org.rascalmpl.org.rascalmpl.com.google.common.primitives.Doubles;
import org.rascalmpl.org.rascalmpl.com.google.common.primitives.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.primitives.FloatsMethodsForWeb;
import org.rascalmpl.org.rascalmpl.java.io.Serializable;
import org.rascalmpl.org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.org.rascalmpl.java.lang.Enum;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.org.rascalmpl.java.lang.Math;
import org.rascalmpl.org.rascalmpl.java.lang.Number;
import org.rascalmpl.org.rascalmpl.java.lang.NumberFormatException;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.System;
import org.rascalmpl.org.rascalmpl.java.util.AbstractList;
import org.rascalmpl.org.rascalmpl.java.util.Arrays;
import org.rascalmpl.org.rascalmpl.java.util.Collection;
import org.rascalmpl.org.rascalmpl.java.util.Collections;
import org.rascalmpl.org.rascalmpl.java.util.Comparator;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.RandomAccess;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Floats
extends FloatsMethodsForWeb {
    public static final int BYTES = 4;

    private Floats() {
    }

    public static int hashCode(float value) {
        return org.rascalmpl.org.rascalmpl.java.lang.Float.valueOf((float)value).hashCode();
    }

    public static int compare(float a, float b) {
        return org.rascalmpl.org.rascalmpl.java.lang.Float.compare((float)a, (float)b);
    }

    public static boolean isFinite(float value) {
        return Float.NEGATIVE_INFINITY < value && value < Float.POSITIVE_INFINITY;
    }

    public static boolean contains(float[] array, float target) {
        for (float value : array) {
            if (value != target) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(float[] array, float target) {
        return Floats.indexOf(array, target, 0, array.length);
    }

    private static int indexOf(float[] array, float target, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(float[] array, float[] target) {
        Preconditions.checkNotNull(array, (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.array");
        Preconditions.checkNotNull(target, (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < array.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(float[] array, float target) {
        return Floats.lastIndexOf(array, target, 0, array.length);
    }

    private static int lastIndexOf(float[] array, float target, int start, int end) {
        for (int i = end - 1; i >= start; --i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    @GwtIncompatible(value="org.rascalmpl.org.rascalmpl.Available in GWT! Annotation is to avoid conflict with GWT specialization of base class.")
    public static float min(float ... array) {
        Preconditions.checkArgument(array.length > 0);
        float min2 = array[0];
        for (int i = 1; i < array.length; ++i) {
            min2 = Math.min((float)min2, (float)array[i]);
        }
        return min2;
    }

    @GwtIncompatible(value="org.rascalmpl.org.rascalmpl.Available in GWT! Annotation is to avoid conflict with GWT specialization of base class.")
    public static float max(float ... array) {
        Preconditions.checkArgument(array.length > 0);
        float max = array[0];
        for (int i = 1; i < array.length; ++i) {
            max = Math.max((float)max, (float)array[i]);
        }
        return max;
    }

    public static float constrainToRange(float value, float min2, float max) {
        if (min2 <= max) {
            return Math.min((float)Math.max((float)value, (float)min2), (float)max);
        }
        throw new IllegalArgumentException(Strings.lenientFormat((String)"org.rascalmpl.org.rascalmpl.min (%s) must be less than or equal to max (%s)", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{org.rascalmpl.org.rascalmpl.java.lang.Float.valueOf((float)min2), org.rascalmpl.org.rascalmpl.java.lang.Float.valueOf((float)max)}));
    }

    public static float[] concat(float[] ... arrays) {
        int length = 0;
        for (float[] array : arrays) {
            length += array.length;
        }
        float[] result = new float[length];
        int pos = 0;
        for (float[] array : arrays) {
            System.arraycopy((org.rascalmpl.org.rascalmpl.java.lang.Object)array, (int)0, (org.rascalmpl.org.rascalmpl.java.lang.Object)result, (int)pos, (int)array.length);
            pos += array.length;
        }
        return result;
    }

    public static Converter<String, org.rascalmpl.org.rascalmpl.java.lang.Float> stringConverter() {
        return FloatConverter.INSTANCE;
    }

    public static float[] ensureCapacity(float[] array, int minLength, int padding) {
        Preconditions.checkArgument(minLength >= 0, (String)"org.rascalmpl.org.rascalmpl.Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, (String)"org.rascalmpl.org.rascalmpl.Invalid padding: %s", padding);
        return array.length < minLength ? Arrays.copyOf((float[])array, (int)(minLength + padding)) : array;
    }

    public static String join(String separator, float ... array) {
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "org.rascalmpl.org.rascalmpl.";
        }
        StringBuilder builder = new StringBuilder(array.length * 12);
        builder.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            builder.append(separator).append(array[i]);
        }
        return builder.toString();
    }

    public static Comparator<float[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sortDescending(float[] array) {
        Preconditions.checkNotNull(array);
        Floats.sortDescending(array, 0, array.length);
    }

    public static void sortDescending(float[] array, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        Arrays.sort((float[])array, (int)fromIndex, (int)toIndex);
        Floats.reverse(array, fromIndex, toIndex);
    }

    public static void reverse(float[] array) {
        Preconditions.checkNotNull(array);
        Floats.reverse(array, 0, array.length);
    }

    public static void reverse(float[] array, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        int i = fromIndex;
        for (int j = toIndex - 1; i < j; ++i, --j) {
            float tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
        }
    }

    public static void rotate(float[] array, int distance) {
        Floats.rotate(array, distance, 0, array.length);
    }

    public static void rotate(float[] array, int distance, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        if (array.length <= 1) {
            return;
        }
        int length = toIndex - fromIndex;
        int m4 = -distance % length;
        m4 = m4 < 0 ? m4 + length : m4;
        int newFirstIndex = m4 + fromIndex;
        if (newFirstIndex == fromIndex) {
            return;
        }
        Floats.reverse(array, fromIndex, newFirstIndex);
        Floats.reverse(array, newFirstIndex, toIndex);
        Floats.reverse(array, fromIndex, toIndex);
    }

    public static float[] toArray(Collection<? extends Number> collection) {
        if (collection instanceof FloatArrayAsList) {
            return ((FloatArrayAsList)collection).toFloatArray();
        }
        org.rascalmpl.org.rascalmpl.java.lang.Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        float[] array = new float[len];
        for (int i = 0; i < len; ++i) {
            array[i] = ((Number)Preconditions.checkNotNull(boxedArray[i])).floatValue();
        }
        return array;
    }

    public static List<org.rascalmpl.org.rascalmpl.java.lang.Float> asList(float ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new FloatArrayAsList(backingArray);
    }

    @CheckForNull
    @GwtIncompatible
    public static org.rascalmpl.org.rascalmpl.java.lang.Float tryParse(String string) {
        if (Doubles.FLOATING_POINT_PATTERN.matcher((CharSequence)string).matches()) {
            try {
                return org.rascalmpl.org.rascalmpl.java.lang.Float.valueOf((float)org.rascalmpl.org.rascalmpl.java.lang.Float.parseFloat((String)string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @GwtCompatible
    private static class FloatArrayAsList
    extends AbstractList<org.rascalmpl.org.rascalmpl.java.lang.Float>
    implements RandomAccess,
    Serializable {
        final float[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        FloatArrayAsList(float[] array) {
            this(array, 0, array.length);
        }

        FloatArrayAsList(float[] array, int start, int end) {
            this.array = array;
            this.start = start;
            this.end = end;
        }

        public int size() {
            return this.end - this.start;
        }

        public boolean isEmpty() {
            return false;
        }

        public org.rascalmpl.org.rascalmpl.java.lang.Float get(int index) {
            Preconditions.checkElementIndex(index, this.size());
            return org.rascalmpl.org.rascalmpl.java.lang.Float.valueOf((float)this.array[this.start + index]);
        }

        public boolean contains(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object target) {
            return target instanceof org.rascalmpl.org.rascalmpl.java.lang.Float && Floats.indexOf(this.array, ((org.rascalmpl.org.rascalmpl.java.lang.Float)target).floatValue(), this.start, this.end) != -1;
        }

        public int indexOf(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object target) {
            int i;
            if (target instanceof org.rascalmpl.org.rascalmpl.java.lang.Float && (i = Floats.indexOf(this.array, ((org.rascalmpl.org.rascalmpl.java.lang.Float)target).floatValue(), this.start, this.end)) >= 0) {
                return i - this.start;
            }
            return -1;
        }

        public int lastIndexOf(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object target) {
            int i;
            if (target instanceof org.rascalmpl.org.rascalmpl.java.lang.Float && (i = Floats.lastIndexOf(this.array, ((org.rascalmpl.org.rascalmpl.java.lang.Float)target).floatValue(), this.start, this.end)) >= 0) {
                return i - this.start;
            }
            return -1;
        }

        public org.rascalmpl.org.rascalmpl.java.lang.Float set(int index, org.rascalmpl.org.rascalmpl.java.lang.Float element) {
            Preconditions.checkElementIndex(index, this.size());
            float oldValue = this.array[this.start + index];
            this.array[this.start + index] = Preconditions.checkNotNull(element).floatValue();
            return org.rascalmpl.org.rascalmpl.java.lang.Float.valueOf((float)oldValue);
        }

        public List<org.rascalmpl.org.rascalmpl.java.lang.Float> subList(int fromIndex, int toIndex) {
            int size = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, size);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new FloatArrayAsList(this.array, this.start + fromIndex, this.start + toIndex);
        }

        public boolean equals(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof FloatArrayAsList) {
                FloatArrayAsList that = (FloatArrayAsList)object;
                int size = this.size();
                if (that.size() != size) {
                    return false;
                }
                for (int i = 0; i < size; ++i) {
                    if (this.array[this.start + i] == that.array[that.start + i]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        public int hashCode() {
            int result = 1;
            for (int i = this.start; i < this.end; ++i) {
                result = 31 * result + Floats.hashCode(this.array[i]);
            }
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.size() * 12);
            builder.append('[').append(this.array[this.start]);
            for (int i = this.start + 1; i < this.end; ++i) {
                builder.append((String)"org.rascalmpl.org.rascalmpl., ").append(this.array[i]);
            }
            return builder.append(']').toString();
        }

        float[] toFloatArray() {
            return Arrays.copyOfRange((float[])this.array, (int)this.start, (int)this.end);
        }
    }

    private static final class LexicographicalComparator
    extends Enum<LexicographicalComparator>
    implements Comparator<float[]> {
        public static final /* enum */ LexicographicalComparator INSTANCE = new LexicographicalComparator((String)"org.rascalmpl.org.rascalmpl.INSTANCE", 0);
        private static final /* synthetic */ LexicographicalComparator[] $VALUES;

        public static LexicographicalComparator[] values() {
            return (LexicographicalComparator[])$VALUES.clone();
        }

        public static LexicographicalComparator valueOf(String name) {
            return (LexicographicalComparator)Enum.valueOf(LexicographicalComparator.class, (String)name);
        }

        private LexicographicalComparator() {
            super((String)string, n);
        }

        public int compare(float[] left, float[] right) {
            int minLength = Math.min((int)left.length, (int)right.length);
            for (int i = 0; i < minLength; ++i) {
                int result = org.rascalmpl.org.rascalmpl.java.lang.Float.compare((float)left[i], (float)right[i]);
                if (result == 0) continue;
                return result;
            }
            return left.length - right.length;
        }

        public String toString() {
            return "org.rascalmpl.org.rascalmpl.Floats.lexicographicalComparator()";
        }

        static {
            $VALUES = new LexicographicalComparator[]{INSTANCE};
        }
    }

    private static final class FloatConverter
    extends Converter<String, org.rascalmpl.org.rascalmpl.java.lang.Float>
    implements Serializable {
        static final Converter<String, org.rascalmpl.org.rascalmpl.java.lang.Float> INSTANCE = new FloatConverter();
        private static final long serialVersionUID = 1L;

        private FloatConverter() {
        }

        @Override
        protected org.rascalmpl.org.rascalmpl.java.lang.Float doForward(String value) {
            return org.rascalmpl.org.rascalmpl.java.lang.Float.valueOf((String)value);
        }

        @Override
        protected String doBackward(org.rascalmpl.org.rascalmpl.java.lang.Float value) {
            return value.toString();
        }

        public String toString() {
            return "org.rascalmpl.org.rascalmpl.Floats.stringConverter()";
        }

        private org.rascalmpl.org.rascalmpl.java.lang.Object readResolve() {
            return INSTANCE;
        }
    }
}

