/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.primitives;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.primitives.Doubles;
import org.rascalmpl.org.rascalmpl.com.google.common.primitives.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.Immutable;
import org.rascalmpl.org.rascalmpl.java.io.Serializable;
import org.rascalmpl.org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.org.rascalmpl.java.lang.Double;
import org.rascalmpl.org.rascalmpl.java.lang.Integer;
import org.rascalmpl.org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.System;
import org.rascalmpl.org.rascalmpl.java.util.AbstractList;
import org.rascalmpl.org.rascalmpl.java.util.Arrays;
import org.rascalmpl.org.rascalmpl.java.util.Collection;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.RandomAccess;
import org.rascalmpl.org.rascalmpl.java.util.Spliterator;
import org.rascalmpl.org.rascalmpl.java.util.Spliterators;
import org.rascalmpl.org.rascalmpl.java.util.function.DoubleConsumer;
import org.rascalmpl.org.rascalmpl.java.util.stream.DoubleStream;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;

@Immutable
@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class ImmutableDoubleArray
extends org.rascalmpl.org.rascalmpl.java.lang.Object
implements Serializable {
    private static final ImmutableDoubleArray EMPTY = new ImmutableDoubleArray(new double[0]);
    private final double[] array;
    private final transient int start;
    private final int end;

    public static ImmutableDoubleArray of() {
        return EMPTY;
    }

    public static ImmutableDoubleArray of(double e0) {
        return new ImmutableDoubleArray(new double[]{e0});
    }

    public static ImmutableDoubleArray of(double e0, double e1) {
        return new ImmutableDoubleArray(new double[]{e0, e1});
    }

    public static ImmutableDoubleArray of(double e0, double e1, double e2) {
        return new ImmutableDoubleArray(new double[]{e0, e1, e2});
    }

    public static ImmutableDoubleArray of(double e0, double e1, double e2, double e3) {
        return new ImmutableDoubleArray(new double[]{e0, e1, e2, e3});
    }

    public static ImmutableDoubleArray of(double e0, double e1, double e2, double e3, double e4) {
        return new ImmutableDoubleArray(new double[]{e0, e1, e2, e3, e4});
    }

    public static ImmutableDoubleArray of(double e0, double e1, double e2, double e3, double e4, double e5) {
        return new ImmutableDoubleArray(new double[]{e0, e1, e2, e3, e4, e5});
    }

    public static ImmutableDoubleArray of(double first, double ... rest) {
        Preconditions.checkArgument(rest.length <= 0x7FFFFFFE, (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.the total number of elements must fit in an int");
        double[] array = new double[rest.length + 1];
        array[0] = first;
        System.arraycopy((org.rascalmpl.org.rascalmpl.java.lang.Object)rest, (int)0, (org.rascalmpl.org.rascalmpl.java.lang.Object)array, (int)1, (int)rest.length);
        return new ImmutableDoubleArray(array);
    }

    public static ImmutableDoubleArray copyOf(double[] values) {
        return values.length == 0 ? EMPTY : new ImmutableDoubleArray(Arrays.copyOf((double[])values, (int)values.length));
    }

    public static ImmutableDoubleArray copyOf(Collection<Double> values) {
        return values.isEmpty() ? EMPTY : new ImmutableDoubleArray(Doubles.toArray(values));
    }

    public static ImmutableDoubleArray copyOf(Iterable<Double> values) {
        if (values instanceof Collection) {
            return ImmutableDoubleArray.copyOf((Collection<Double>)((Collection)values));
        }
        return ImmutableDoubleArray.builder().addAll(values).build();
    }

    public static ImmutableDoubleArray copyOf(DoubleStream stream) {
        double[] array = stream.toArray();
        return array.length == 0 ? EMPTY : new ImmutableDoubleArray(array);
    }

    public static Builder builder(int initialCapacity) {
        Preconditions.checkArgument(initialCapacity >= 0, (String)"org.rascalmpl.org.rascalmpl.Invalid initialCapacity: %s", initialCapacity);
        return new Builder(initialCapacity);
    }

    public static Builder builder() {
        return new Builder(10);
    }

    private ImmutableDoubleArray(double[] array) {
        this(array, 0, array.length);
    }

    private ImmutableDoubleArray(double[] array, int start, int end) {
        this.array = array;
        this.start = start;
        this.end = end;
    }

    public int length() {
        return this.end - this.start;
    }

    public boolean isEmpty() {
        return this.end == this.start;
    }

    public double get(int index) {
        Preconditions.checkElementIndex(index, this.length());
        return this.array[this.start + index];
    }

    public int indexOf(double target) {
        for (int i = this.start; i < this.end; ++i) {
            if (!ImmutableDoubleArray.areEqual(this.array[i], target)) continue;
            return i - this.start;
        }
        return -1;
    }

    public int lastIndexOf(double target) {
        for (int i = this.end - 1; i >= this.start; --i) {
            if (!ImmutableDoubleArray.areEqual(this.array[i], target)) continue;
            return i - this.start;
        }
        return -1;
    }

    public boolean contains(double target) {
        return this.indexOf(target) >= 0;
    }

    public void forEach(DoubleConsumer consumer) {
        Preconditions.checkNotNull(consumer);
        for (int i = this.start; i < this.end; ++i) {
            consumer.accept(this.array[i]);
        }
    }

    public DoubleStream stream() {
        return Arrays.stream((double[])this.array, (int)this.start, (int)this.end);
    }

    public double[] toArray() {
        return Arrays.copyOfRange((double[])this.array, (int)this.start, (int)this.end);
    }

    public ImmutableDoubleArray subArray(int startIndex, int endIndex) {
        Preconditions.checkPositionIndexes(startIndex, endIndex, this.length());
        return startIndex == endIndex ? EMPTY : new ImmutableDoubleArray(this.array, this.start + startIndex, this.start + endIndex);
    }

    private Spliterator.OfDouble spliterator() {
        return Spliterators.spliterator((double[])this.array, (int)this.start, (int)this.end, (int)1040);
    }

    public List<Double> asList() {
        return new AsList(this);
    }

    public boolean equals(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ImmutableDoubleArray)) {
            return false;
        }
        ImmutableDoubleArray that = (ImmutableDoubleArray)object;
        if (this.length() != that.length()) {
            return false;
        }
        for (int i = 0; i < this.length(); ++i) {
            if (ImmutableDoubleArray.areEqual(this.get(i), that.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean areEqual(double a, double b) {
        return Double.doubleToLongBits((double)a) == Double.doubleToLongBits((double)b);
    }

    public int hashCode() {
        int hash = 1;
        for (int i = this.start; i < this.end; ++i) {
            hash *= 31;
            hash += Doubles.hashCode(this.array[i]);
        }
        return hash;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "org.rascalmpl.org.rascalmpl.[]";
        }
        StringBuilder builder = new StringBuilder(this.length() * 5);
        builder.append('[').append(this.array[this.start]);
        for (int i = this.start + 1; i < this.end; ++i) {
            builder.append((String)"org.rascalmpl.org.rascalmpl., ").append(this.array[i]);
        }
        builder.append(']');
        return builder.toString();
    }

    public ImmutableDoubleArray trimmed() {
        return this.isPartialView() ? new ImmutableDoubleArray(this.toArray()) : this;
    }

    private boolean isPartialView() {
        return this.start > 0 || this.end < this.array.length;
    }

    org.rascalmpl.org.rascalmpl.java.lang.Object writeReplace() {
        return this.trimmed();
    }

    org.rascalmpl.org.rascalmpl.java.lang.Object readResolve() {
        return this.isEmpty() ? EMPTY : this;
    }

    static class AsList
    extends AbstractList<Double>
    implements RandomAccess,
    Serializable {
        private final ImmutableDoubleArray parent;

        private AsList(ImmutableDoubleArray parent) {
            this.parent = parent;
        }

        public int size() {
            return this.parent.length();
        }

        public Double get(int index) {
            return Double.valueOf((double)this.parent.get(index));
        }

        public boolean contains(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object target) {
            return this.indexOf(target) >= 0;
        }

        public int indexOf(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object target) {
            return target instanceof Double ? this.parent.indexOf(((Double)target).doubleValue()) : -1;
        }

        public int lastIndexOf(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object target) {
            return target instanceof Double ? this.parent.lastIndexOf(((Double)target).doubleValue()) : -1;
        }

        public List<Double> subList(int fromIndex, int toIndex) {
            return this.parent.subArray(fromIndex, toIndex).asList();
        }

        public Spliterator<Double> spliterator() {
            return this.parent.spliterator();
        }

        public boolean equals(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object object) {
            if (object instanceof AsList) {
                AsList that = (AsList)object;
                return this.parent.equals(that.parent);
            }
            if (!(object instanceof List)) {
                return false;
            }
            List that = (List)object;
            if (this.size() != that.size()) {
                return false;
            }
            int i = this.parent.start;
            for (org.rascalmpl.org.rascalmpl.java.lang.Object element : that) {
                if (element instanceof Double && ImmutableDoubleArray.areEqual(this.parent.array[i++], ((Double)element).doubleValue())) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.parent.hashCode();
        }

        public String toString() {
            return this.parent.toString();
        }
    }

    public static final class Builder
    extends org.rascalmpl.org.rascalmpl.java.lang.Object {
        private double[] array;
        private int count = 0;

        Builder(int initialCapacity) {
            this.array = new double[initialCapacity];
        }

        @CanIgnoreReturnValue
        public Builder add(double value) {
            this.ensureRoomFor(1);
            this.array[this.count] = value;
            ++this.count;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAll(double[] values) {
            this.ensureRoomFor(values.length);
            System.arraycopy((org.rascalmpl.org.rascalmpl.java.lang.Object)values, (int)0, (org.rascalmpl.org.rascalmpl.java.lang.Object)this.array, (int)this.count, (int)values.length);
            this.count += values.length;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAll(Iterable<Double> values) {
            if (values instanceof Collection) {
                return this.addAll((Collection<Double>)((Collection)values));
            }
            for (Double value : values) {
                this.add(value.doubleValue());
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAll(Collection<Double> values) {
            this.ensureRoomFor(values.size());
            for (Double value : values) {
                this.array[this.count++] = value.doubleValue();
            }
            return this;
        }

        /*
         * Exception decompiling
         */
        @CanIgnoreReturnValue
        public Builder addAll(DoubleStream stream) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.org.rascalmpl.java.lang.invoke.MethodType, got (D)V
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
             *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @CanIgnoreReturnValue
        public Builder addAll(ImmutableDoubleArray values) {
            this.ensureRoomFor(values.length());
            System.arraycopy((org.rascalmpl.org.rascalmpl.java.lang.Object)values.array, (int)values.start, (org.rascalmpl.org.rascalmpl.java.lang.Object)this.array, (int)this.count, (int)values.length());
            this.count += values.length();
            return this;
        }

        private void ensureRoomFor(int numberToAdd) {
            int newCount = this.count + numberToAdd;
            if (newCount > this.array.length) {
                this.array = Arrays.copyOf((double[])this.array, (int)Builder.expandedCapacity(this.array.length, newCount));
            }
        }

        private static int expandedCapacity(int oldCapacity, int minCapacity) {
            if (minCapacity < 0) {
                throw new AssertionError((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.cannot store more than MAX_VALUE elements");
            }
            int newCapacity = oldCapacity + (oldCapacity >> 1) + 1;
            if (newCapacity < minCapacity) {
                newCapacity = Integer.highestOneBit((int)(minCapacity - 1)) << 1;
            }
            if (newCapacity < 0) {
                newCapacity = java.lang.Integer.MAX_VALUE;
            }
            return newCapacity;
        }

        public ImmutableDoubleArray build() {
            return this.count == 0 ? EMPTY : new ImmutableDoubleArray(this.array, 0, this.count);
        }
    }
}

