/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.primitives;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Converter;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.primitives.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.primitives.ShortsMethodsForWeb;
import org.rascalmpl.org.rascalmpl.java.io.Serializable;
import org.rascalmpl.org.rascalmpl.java.lang.Enum;
import org.rascalmpl.org.rascalmpl.java.lang.Math;
import org.rascalmpl.org.rascalmpl.java.lang.Number;
import org.rascalmpl.org.rascalmpl.java.lang.Short;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.System;
import org.rascalmpl.org.rascalmpl.java.util.AbstractList;
import org.rascalmpl.org.rascalmpl.java.util.Arrays;
import org.rascalmpl.org.rascalmpl.java.util.Collection;
import org.rascalmpl.org.rascalmpl.java.util.Collections;
import org.rascalmpl.org.rascalmpl.java.util.Comparator;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.RandomAccess;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Shorts
extends ShortsMethodsForWeb {
    public static final int BYTES = 2;
    public static final short MAX_POWER_OF_TWO = 16384;

    private Shorts() {
    }

    public static int hashCode(short value) {
        return value;
    }

    public static short checkedCast(long value) {
        short result = (short)value;
        Preconditions.checkArgument((long)result == value, (String)"org.rascalmpl.org.rascalmpl.Out of range: %s", value);
        return result;
    }

    public static short saturatedCast(long value) {
        if (value > 32767L) {
            return java.lang.Short.MAX_VALUE;
        }
        if (value < -32768L) {
            return java.lang.Short.MIN_VALUE;
        }
        return (short)value;
    }

    public static int compare(short a, short b) {
        return a - b;
    }

    public static boolean contains(short[] array, short target) {
        for (short value : array) {
            if (value != target) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(short[] array, short target) {
        return Shorts.indexOf(array, target, 0, array.length);
    }

    private static int indexOf(short[] array, short target, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(short[] array, short[] target) {
        Preconditions.checkNotNull(array, (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.array");
        Preconditions.checkNotNull(target, (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < array.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(short[] array, short target) {
        return Shorts.lastIndexOf(array, target, 0, array.length);
    }

    private static int lastIndexOf(short[] array, short target, int start, int end) {
        for (int i = end - 1; i >= start; --i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    @GwtIncompatible(value="org.rascalmpl.org.rascalmpl.Available in GWT! Annotation is to avoid conflict with GWT specialization of base class.")
    public static short min(short ... array) {
        Preconditions.checkArgument(array.length > 0);
        short min2 = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= min2) continue;
            min2 = array[i];
        }
        return min2;
    }

    @GwtIncompatible(value="org.rascalmpl.org.rascalmpl.Available in GWT! Annotation is to avoid conflict with GWT specialization of base class.")
    public static short max(short ... array) {
        Preconditions.checkArgument(array.length > 0);
        short max = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] <= max) continue;
            max = array[i];
        }
        return max;
    }

    public static short constrainToRange(short value, short min2, short max) {
        Preconditions.checkArgument(min2 <= max, (String)"org.rascalmpl.org.rascalmpl.min (%s) must be less than or equal to max (%s)", (int)min2, (int)max);
        return value < min2 ? min2 : (value < max ? value : max);
    }

    public static short[] concat(short[] ... arrays) {
        int length = 0;
        for (short[] array : arrays) {
            length += array.length;
        }
        short[] result = new short[length];
        int pos = 0;
        for (short[] array : arrays) {
            System.arraycopy((org.rascalmpl.org.rascalmpl.java.lang.Object)array, (int)0, (org.rascalmpl.org.rascalmpl.java.lang.Object)result, (int)pos, (int)array.length);
            pos += array.length;
        }
        return result;
    }

    @GwtIncompatible
    public static byte[] toByteArray(short value) {
        return new byte[]{(byte)(value >> 8), (byte)value};
    }

    @GwtIncompatible
    public static short fromByteArray(byte[] bytes) {
        Preconditions.checkArgument(bytes.length >= 2, (String)"org.rascalmpl.org.rascalmpl.array too small: %s < %s", bytes.length, 2);
        return Shorts.fromBytes(bytes[0], bytes[1]);
    }

    @GwtIncompatible
    public static short fromBytes(byte b1, byte b2) {
        return (short)(b1 << 8 | b2 & 0xFF);
    }

    public static Converter<String, Short> stringConverter() {
        return ShortConverter.INSTANCE;
    }

    public static short[] ensureCapacity(short[] array, int minLength, int padding) {
        Preconditions.checkArgument(minLength >= 0, (String)"org.rascalmpl.org.rascalmpl.Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, (String)"org.rascalmpl.org.rascalmpl.Invalid padding: %s", padding);
        return array.length < minLength ? Arrays.copyOf((short[])array, (int)(minLength + padding)) : array;
    }

    public static String join(String separator, short ... array) {
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "org.rascalmpl.org.rascalmpl.";
        }
        StringBuilder builder = new StringBuilder(array.length * 6);
        builder.append((int)array[0]);
        for (int i = 1; i < array.length; ++i) {
            builder.append(separator).append((int)array[i]);
        }
        return builder.toString();
    }

    public static Comparator<short[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sortDescending(short[] array) {
        Preconditions.checkNotNull(array);
        Shorts.sortDescending(array, 0, array.length);
    }

    public static void sortDescending(short[] array, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        Arrays.sort((short[])array, (int)fromIndex, (int)toIndex);
        Shorts.reverse(array, fromIndex, toIndex);
    }

    public static void reverse(short[] array) {
        Preconditions.checkNotNull(array);
        Shorts.reverse(array, 0, array.length);
    }

    public static void reverse(short[] array, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        int i = fromIndex;
        for (int j = toIndex - 1; i < j; ++i, --j) {
            short tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
        }
    }

    public static void rotate(short[] array, int distance) {
        Shorts.rotate(array, distance, 0, array.length);
    }

    public static void rotate(short[] array, int distance, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        if (array.length <= 1) {
            return;
        }
        int length = toIndex - fromIndex;
        int m4 = -distance % length;
        m4 = m4 < 0 ? m4 + length : m4;
        int newFirstIndex = m4 + fromIndex;
        if (newFirstIndex == fromIndex) {
            return;
        }
        Shorts.reverse(array, fromIndex, newFirstIndex);
        Shorts.reverse(array, newFirstIndex, toIndex);
        Shorts.reverse(array, fromIndex, toIndex);
    }

    public static short[] toArray(Collection<? extends Number> collection) {
        if (collection instanceof ShortArrayAsList) {
            return ((ShortArrayAsList)collection).toShortArray();
        }
        org.rascalmpl.org.rascalmpl.java.lang.Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        short[] array = new short[len];
        for (int i = 0; i < len; ++i) {
            array[i] = ((Number)Preconditions.checkNotNull(boxedArray[i])).shortValue();
        }
        return array;
    }

    public static List<Short> asList(short ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new ShortArrayAsList(backingArray);
    }

    @GwtCompatible
    private static class ShortArrayAsList
    extends AbstractList<Short>
    implements RandomAccess,
    Serializable {
        final short[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        ShortArrayAsList(short[] array) {
            this(array, 0, array.length);
        }

        ShortArrayAsList(short[] array, int start, int end) {
            this.array = array;
            this.start = start;
            this.end = end;
        }

        public int size() {
            return this.end - this.start;
        }

        public boolean isEmpty() {
            return false;
        }

        public Short get(int index) {
            Preconditions.checkElementIndex(index, this.size());
            return Short.valueOf((short)this.array[this.start + index]);
        }

        public boolean contains(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object target) {
            return target instanceof Short && Shorts.indexOf(this.array, ((Short)target).shortValue(), this.start, this.end) != -1;
        }

        public int indexOf(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object target) {
            int i;
            if (target instanceof Short && (i = Shorts.indexOf(this.array, ((Short)target).shortValue(), this.start, this.end)) >= 0) {
                return i - this.start;
            }
            return -1;
        }

        public int lastIndexOf(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object target) {
            int i;
            if (target instanceof Short && (i = Shorts.lastIndexOf(this.array, ((Short)target).shortValue(), this.start, this.end)) >= 0) {
                return i - this.start;
            }
            return -1;
        }

        public Short set(int index, Short element) {
            Preconditions.checkElementIndex(index, this.size());
            short oldValue = this.array[this.start + index];
            this.array[this.start + index] = Preconditions.checkNotNull(element).shortValue();
            return Short.valueOf((short)oldValue);
        }

        public List<Short> subList(int fromIndex, int toIndex) {
            int size = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, size);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new ShortArrayAsList(this.array, this.start + fromIndex, this.start + toIndex);
        }

        public boolean equals(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ShortArrayAsList) {
                ShortArrayAsList that = (ShortArrayAsList)object;
                int size = this.size();
                if (that.size() != size) {
                    return false;
                }
                for (int i = 0; i < size; ++i) {
                    if (this.array[this.start + i] == that.array[that.start + i]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        public int hashCode() {
            int result = 1;
            for (int i = this.start; i < this.end; ++i) {
                result = 31 * result + Shorts.hashCode(this.array[i]);
            }
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.size() * 6);
            builder.append('[').append((int)this.array[this.start]);
            for (int i = this.start + 1; i < this.end; ++i) {
                builder.append((String)"org.rascalmpl.org.rascalmpl., ").append((int)this.array[i]);
            }
            return builder.append(']').toString();
        }

        short[] toShortArray() {
            return Arrays.copyOfRange((short[])this.array, (int)this.start, (int)this.end);
        }
    }

    private static final class LexicographicalComparator
    extends Enum<LexicographicalComparator>
    implements Comparator<short[]> {
        public static final /* enum */ LexicographicalComparator INSTANCE = new LexicographicalComparator((String)"org.rascalmpl.org.rascalmpl.INSTANCE", 0);
        private static final /* synthetic */ LexicographicalComparator[] $VALUES;

        public static LexicographicalComparator[] values() {
            return (LexicographicalComparator[])$VALUES.clone();
        }

        public static LexicographicalComparator valueOf(String name) {
            return (LexicographicalComparator)Enum.valueOf(LexicographicalComparator.class, (String)name);
        }

        private LexicographicalComparator() {
            super((String)string, n);
        }

        public int compare(short[] left, short[] right) {
            int minLength = Math.min((int)left.length, (int)right.length);
            for (int i = 0; i < minLength; ++i) {
                int result = Shorts.compare(left[i], right[i]);
                if (result == 0) continue;
                return result;
            }
            return left.length - right.length;
        }

        public String toString() {
            return "org.rascalmpl.org.rascalmpl.Shorts.lexicographicalComparator()";
        }

        static {
            $VALUES = new LexicographicalComparator[]{INSTANCE};
        }
    }

    private static final class ShortConverter
    extends Converter<String, Short>
    implements Serializable {
        static final Converter<String, Short> INSTANCE = new ShortConverter();
        private static final long serialVersionUID = 1L;

        private ShortConverter() {
        }

        @Override
        protected Short doForward(String value) {
            return Short.decode((String)value);
        }

        @Override
        protected String doBackward(Short value) {
            return value.toString();
        }

        public String toString() {
            return "org.rascalmpl.org.rascalmpl.Shorts.stringConverter()";
        }

        private org.rascalmpl.org.rascalmpl.java.lang.Object readResolve() {
            return INSTANCE;
        }
    }
}

