/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.reflect;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.VisibleForTesting;
import org.rascalmpl.org.rascalmpl.com.google.common.base.CharMatcher;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Splitter;
import org.rascalmpl.org.rascalmpl.com.google.common.base.StandardSystemProperty;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.FluentIterable;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableList;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableMap;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableSet;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.org.rascalmpl.com.google.common.io.ByteSource;
import org.rascalmpl.org.rascalmpl.com.google.common.io.CharSource;
import org.rascalmpl.org.rascalmpl.com.google.common.io.Resources;
import org.rascalmpl.org.rascalmpl.com.google.common.reflect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.reflect.Reflection;
import org.rascalmpl.org.rascalmpl.java.io.File;
import org.rascalmpl.org.rascalmpl.java.io.IOException;
import org.rascalmpl.org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.org.rascalmpl.java.lang.Class;
import org.rascalmpl.org.rascalmpl.java.lang.ClassLoader;
import org.rascalmpl.org.rascalmpl.java.lang.ClassNotFoundException;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.SecurityException;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.net.MalformedURLException;
import org.rascalmpl.org.rascalmpl.java.net.URISyntaxException;
import org.rascalmpl.org.rascalmpl.java.net.URL;
import org.rascalmpl.org.rascalmpl.java.net.URLClassLoader;
import org.rascalmpl.org.rascalmpl.java.nio.charset.Charset;
import org.rascalmpl.org.rascalmpl.java.util.Enumeration;
import org.rascalmpl.org.rascalmpl.java.util.HashSet;
import org.rascalmpl.org.rascalmpl.java.util.Iterator;
import org.rascalmpl.org.rascalmpl.java.util.LinkedHashMap;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.java.util.NoSuchElementException;
import org.rascalmpl.org.rascalmpl.java.util.Set;
import org.rascalmpl.org.rascalmpl.java.util.jar.Attributes;
import org.rascalmpl.org.rascalmpl.java.util.jar.JarEntry;
import org.rascalmpl.org.rascalmpl.java.util.jar.JarFile;
import org.rascalmpl.org.rascalmpl.java.util.jar.Manifest;
import org.rascalmpl.org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.org.rascalmpl.java.util.logging.Logger;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
public final class ClassPath
extends Object {
    private static final Logger logger = Logger.getLogger((String)ClassPath.class.getName());
    private static final Splitter CLASS_PATH_ATTRIBUTE_SEPARATOR = Splitter.on((String)"org.rascalmpl.org.rascalmpl. ").omitEmptyStrings();
    private static final String CLASS_FILE_NAME_EXTENSION = "org.rascalmpl.org.rascalmpl..class";
    private final ImmutableSet<ResourceInfo> resources;

    private ClassPath(ImmutableSet<ResourceInfo> resources) {
        this.resources = resources;
    }

    public static ClassPath from(ClassLoader classloader) throws IOException {
        ImmutableSet<LocationInfo> locations = ClassPath.locationsFrom(classloader);
        HashSet scanned = new HashSet();
        Iterator iterator = locations.iterator();
        while (iterator.hasNext()) {
            LocationInfo location = (LocationInfo)iterator.next();
            scanned.add((Object)location.file());
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Iterator iterator2 = locations.iterator();
        while (iterator2.hasNext()) {
            LocationInfo location = (LocationInfo)iterator2.next();
            builder.addAll((Iterable)location.scanResources((Set<File>)scanned));
        }
        return new ClassPath((ImmutableSet<ResourceInfo>)builder.build());
    }

    public ImmutableSet<ResourceInfo> getResources() {
        return this.resources;
    }

    public ImmutableSet<ClassInfo> getAllClasses() {
        return FluentIterable.from(this.resources).filter(ClassInfo.class).toSet();
    }

    /*
     * Exception decompiling
     */
    public ImmutableSet<ClassInfo> getTopLevelClasses() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/org/rascalmpl/java/lang/Object;)Z
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ImmutableSet<ClassInfo> getTopLevelClasses(String packageName) {
        Preconditions.checkNotNull(packageName);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Iterator iterator = this.getTopLevelClasses().iterator();
        while (iterator.hasNext()) {
            ClassInfo classInfo = (ClassInfo)iterator.next();
            if (!classInfo.getPackageName().equals((Object)packageName)) continue;
            builder.add(classInfo);
        }
        return builder.build();
    }

    public ImmutableSet<ClassInfo> getTopLevelClassesRecursive(String packageName) {
        Preconditions.checkNotNull(packageName);
        String packagePrefix = new StringBuilder().append(packageName).append('.').toString();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Iterator iterator = this.getTopLevelClasses().iterator();
        while (iterator.hasNext()) {
            ClassInfo classInfo = (ClassInfo)iterator.next();
            if (!classInfo.getName().startsWith(packagePrefix)) continue;
            builder.add(classInfo);
        }
        return builder.build();
    }

    static ImmutableSet<LocationInfo> locationsFrom(ClassLoader classloader) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Map.Entry entry : ClassPath.getClassPathEntries(classloader).entrySet()) {
            builder.add(new LocationInfo((File)entry.getKey(), (ClassLoader)entry.getValue()));
        }
        return builder.build();
    }

    @VisibleForTesting
    static ImmutableSet<File> getClassPathFromManifest(File jarFile, @CheckForNull Manifest manifest) {
        if (manifest == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        String classpathAttribute = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH.toString());
        if (classpathAttribute != null) {
            for (String path : CLASS_PATH_ATTRIBUTE_SEPARATOR.split((CharSequence)classpathAttribute)) {
                URL url;
                try {
                    url = ClassPath.getClassPathEntry(jarFile, path);
                }
                catch (MalformedURLException e) {
                    logger.warning(new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.Invalid Class-Path entry: ").append(path).toString());
                    continue;
                }
                if (!url.getProtocol().equals((Object)"org.rascalmpl.org.rascalmpl.file")) continue;
                builder.add((Object)ClassPath.toFile(url));
            }
        }
        return builder.build();
    }

    @VisibleForTesting
    static ImmutableMap<File, ClassLoader> getClassPathEntries(ClassLoader classloader) {
        LinkedHashMap entries = Maps.newLinkedHashMap();
        ClassLoader parent = classloader.getParent();
        if (parent != null) {
            entries.putAll(ClassPath.getClassPathEntries(parent));
        }
        Iterator iterator = ClassPath.getClassLoaderUrls(classloader).iterator();
        while (iterator.hasNext()) {
            File file;
            URL url = (URL)iterator.next();
            if (!url.getProtocol().equals((Object)"org.rascalmpl.org.rascalmpl.file") || entries.containsKey((Object)(file = ClassPath.toFile(url)))) continue;
            entries.put((Object)file, (Object)classloader);
        }
        return ImmutableMap.copyOf(entries);
    }

    private static ImmutableList<URL> getClassLoaderUrls(ClassLoader classloader) {
        if (classloader instanceof URLClassLoader) {
            return ImmutableList.copyOf((Object[])((URLClassLoader)classloader).getURLs());
        }
        if (classloader.equals((Object)ClassLoader.getSystemClassLoader())) {
            return ClassPath.parseJavaClassPath();
        }
        return ImmutableList.of();
    }

    @VisibleForTesting
    static ImmutableList<URL> parseJavaClassPath() {
        ImmutableList.Builder urls = ImmutableList.builder();
        for (String entry : Splitter.on(StandardSystemProperty.PATH_SEPARATOR.value()).split((CharSequence)StandardSystemProperty.JAVA_CLASS_PATH.value())) {
            try {
                try {
                    urls.add((Object)new File(entry).toURI().toURL());
                }
                catch (SecurityException e) {
                    urls.add((Object)new URL((String)"org.rascalmpl.org.rascalmpl.file", null, new File(entry).getAbsolutePath()));
                }
            }
            catch (MalformedURLException e) {
                logger.log(Level.WARNING, new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.malformed classpath entry: ").append(entry).toString(), (Throwable)((java.lang.Object)e));
            }
        }
        return urls.build();
    }

    @VisibleForTesting
    static URL getClassPathEntry(File jarFile, String path) throws MalformedURLException {
        return new URL(jarFile.toURI().toURL(), path);
    }

    @VisibleForTesting
    static String getClassName(String filename) {
        int classNameEnd = filename.length() - "org.rascalmpl.org.rascalmpl..class".length();
        return filename.substring(0, classNameEnd).replace('/', '.');
    }

    @VisibleForTesting
    static File toFile(URL url) {
        Preconditions.checkArgument(url.getProtocol().equals((Object)"org.rascalmpl.org.rascalmpl.file"));
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            return new File(url.getPath());
        }
    }

    static final class LocationInfo
    extends Object {
        final File home;
        private final ClassLoader classloader;

        LocationInfo(File home, ClassLoader classloader) {
            this.home = Preconditions.checkNotNull(home);
            this.classloader = Preconditions.checkNotNull(classloader);
        }

        public final File file() {
            return this.home;
        }

        public ImmutableSet<ResourceInfo> scanResources() throws IOException {
            return this.scanResources((Set<File>)new HashSet());
        }

        public ImmutableSet<ResourceInfo> scanResources(Set<File> scannedFiles) throws IOException {
            ImmutableSet.Builder<ResourceInfo> builder = ImmutableSet.builder();
            scannedFiles.add((Object)this.home);
            this.scan(this.home, scannedFiles, builder);
            return builder.build();
        }

        private void scan(File file, Set<File> scannedUris, ImmutableSet.Builder<ResourceInfo> builder) throws IOException {
            try {
                if (!file.exists()) {
                    return;
                }
            }
            catch (SecurityException e) {
                logger.warning(new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.Cannot access ").append((Object)file).append((String)"org.rascalmpl.org.rascalmpl.: ").append((Object)e).toString());
                return;
            }
            if (file.isDirectory()) {
                this.scanDirectory(file, builder);
            } else {
                this.scanJar(file, scannedUris, builder);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scanJar(File file, Set<File> scannedUris, ImmutableSet.Builder<ResourceInfo> builder) throws IOException {
            JarFile jarFile;
            try {
                jarFile = new JarFile(file);
            }
            catch (IOException e) {
                return;
            }
            try {
                Iterator iterator = ClassPath.getClassPathFromManifest(file, jarFile.getManifest()).iterator();
                while (iterator.hasNext()) {
                    File path = (File)iterator.next();
                    if (!scannedUris.add((Object)path.getCanonicalFile())) continue;
                    this.scan(path, scannedUris, builder);
                }
                this.scanJarFile(jarFile, builder);
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }

        private void scanJarFile(JarFile file, ImmutableSet.Builder<ResourceInfo> builder) {
            Enumeration entries = file.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = (JarEntry)entries.nextElement();
                if (entry.isDirectory() || entry.getName().equals((Object)"org/rascalmpl/org/rascalmpl/META-INF/MANIFEST.MF")) continue;
                builder.add((Object)ResourceInfo.of(new File(file.getName()), entry.getName(), this.classloader));
            }
        }

        private void scanDirectory(File directory, ImmutableSet.Builder<ResourceInfo> builder) throws IOException {
            HashSet currentPath = new HashSet();
            currentPath.add((Object)directory.getCanonicalFile());
            this.scanDirectory(directory, (String)"org.rascalmpl.org.rascalmpl.", (Set<File>)currentPath, builder);
        }

        private void scanDirectory(File directory, String packagePrefix, Set<File> currentPath, ImmutableSet.Builder<ResourceInfo> builder) throws IOException {
            File[] files = directory.listFiles();
            if (files == null) {
                logger.warning(new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.Cannot read directory ").append((Object)directory).toString());
                return;
            }
            for (File f : files) {
                String name = f.getName();
                if (f.isDirectory()) {
                    File deref = f.getCanonicalFile();
                    if (!currentPath.add((Object)deref)) continue;
                    this.scanDirectory(deref, new StringBuilder().append(packagePrefix).append(name).append((String)"org/rascalmpl/org/rascalmpl//").toString(), currentPath, builder);
                    currentPath.remove((Object)deref);
                    continue;
                }
                String resourceName = new StringBuilder().append(packagePrefix).append(name).toString();
                if (resourceName.equals((Object)"org/rascalmpl/org/rascalmpl/META-INF/MANIFEST.MF")) continue;
                builder.add((Object)ResourceInfo.of(f, resourceName, this.classloader));
            }
        }

        public boolean equals(@CheckForNull Object obj) {
            if (obj instanceof LocationInfo) {
                LocationInfo that = (LocationInfo)obj;
                return this.home.equals((Object)that.home) && this.classloader.equals((Object)that.classloader);
            }
            return false;
        }

        public int hashCode() {
            return this.home.hashCode();
        }

        public String toString() {
            return this.home.toString();
        }
    }

    public static final class ClassInfo
    extends ResourceInfo {
        private final String className;

        ClassInfo(File file, String resourceName, ClassLoader loader) {
            super(file, resourceName, loader);
            this.className = ClassPath.getClassName(resourceName);
        }

        public String getPackageName() {
            return Reflection.getPackageName(this.className);
        }

        public String getSimpleName() {
            int lastDollarSign = this.className.lastIndexOf(36);
            if (lastDollarSign != -1) {
                String innerClassName = this.className.substring(lastDollarSign + 1);
                return CharMatcher.inRange('0', '9').trimLeadingFrom((CharSequence)innerClassName);
            }
            String packageName = this.getPackageName();
            if (packageName.isEmpty()) {
                return this.className;
            }
            return this.className.substring(packageName.length() + 1);
        }

        public String getName() {
            return this.className;
        }

        public boolean isTopLevel() {
            return this.className.indexOf(36) == -1;
        }

        public Class<?> load() {
            try {
                return this.loader.loadClass(this.className);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException((Throwable)((java.lang.Object)e));
            }
        }

        @Override
        public String toString() {
            return this.className;
        }
    }

    public static class ResourceInfo
    extends Object {
        private final File file;
        private final String resourceName;
        final ClassLoader loader;

        static ResourceInfo of(File file, String resourceName, ClassLoader loader) {
            if (resourceName.endsWith((String)"org.rascalmpl.org.rascalmpl..class")) {
                return new ClassInfo(file, resourceName, loader);
            }
            return new ResourceInfo(file, resourceName, loader);
        }

        ResourceInfo(File file, String resourceName, ClassLoader loader) {
            this.file = Preconditions.checkNotNull(file);
            this.resourceName = Preconditions.checkNotNull(resourceName);
            this.loader = Preconditions.checkNotNull(loader);
        }

        public final URL url() {
            URL url = this.loader.getResource(this.resourceName);
            if (url == null) {
                throw new NoSuchElementException(this.resourceName);
            }
            return url;
        }

        public final ByteSource asByteSource() {
            return Resources.asByteSource(this.url());
        }

        public final CharSource asCharSource(Charset charset) {
            return Resources.asCharSource(this.url(), charset);
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        final File getFile() {
            return this.file;
        }

        public int hashCode() {
            return this.resourceName.hashCode();
        }

        public boolean equals(@CheckForNull Object obj) {
            if (obj instanceof ResourceInfo) {
                ResourceInfo that = (ResourceInfo)obj;
                return this.resourceName.equals((Object)that.resourceName) && this.loader == that.loader;
            }
            return false;
        }

        public String toString() {
            return this.resourceName;
        }
    }
}

