/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.reflect;

import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableList;
import org.rascalmpl.org.rascalmpl.com.google.common.reflect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.reflect.IgnoreJRERequirement;
import org.rascalmpl.org.rascalmpl.com.google.common.reflect.Parameter;
import org.rascalmpl.org.rascalmpl.com.google.common.reflect.TypeToken;
import org.rascalmpl.org.rascalmpl.com.google.common.reflect.Types;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.org.rascalmpl.java.lang.Class;
import org.rascalmpl.org.rascalmpl.java.lang.ClassNotFoundException;
import org.rascalmpl.org.rascalmpl.java.lang.Exception;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalAccessException;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.org.rascalmpl.java.lang.InstantiationException;
import org.rascalmpl.org.rascalmpl.java.lang.RuntimeException;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.System;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.lang.annotation.Annotation;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.AccessibleObject;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.AnnotatedElement;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.AnnotatedType;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.Constructor;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.InvocationTargetException;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.Member;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.Method;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.Modifier;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.Type;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.TypeVariable;
import org.rascalmpl.org.rascalmpl.java.util.Arrays;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
public abstract class Invokable<T extends org.rascalmpl.org.rascalmpl.java.lang.Object, R extends org.rascalmpl.org.rascalmpl.java.lang.Object>
extends org.rascalmpl.org.rascalmpl.java.lang.Object
implements AnnotatedElement,
Member {
    private final AccessibleObject accessibleObject;
    private final Member member;
    private static final boolean ANNOTATED_TYPE_EXISTS = Invokable.initAnnotatedTypeExists();

    <M extends AccessibleObject> Invokable(M member) {
        Preconditions.checkNotNull(member);
        this.accessibleObject = member;
        this.member = (Member)member;
    }

    public static Invokable<?, org.rascalmpl.org.rascalmpl.java.lang.Object> from(Method method) {
        return new MethodInvokable(method);
    }

    public static <T extends org.rascalmpl.org.rascalmpl.java.lang.Object> Invokable<T, T> from(Constructor<T> constructor) {
        return new ConstructorInvokable(constructor);
    }

    public final boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.accessibleObject.isAnnotationPresent(annotationClass);
    }

    @CheckForNull
    public final <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return (A)this.accessibleObject.getAnnotation(annotationClass);
    }

    public final Annotation[] getAnnotations() {
        return this.accessibleObject.getAnnotations();
    }

    public final Annotation[] getDeclaredAnnotations() {
        return this.accessibleObject.getDeclaredAnnotations();
    }

    public abstract TypeVariable<?>[] getTypeParameters();

    public final void setAccessible(boolean flag) {
        this.accessibleObject.setAccessible(flag);
    }

    public final boolean trySetAccessible() {
        try {
            this.accessibleObject.setAccessible(true);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public final boolean isAccessible() {
        return this.accessibleObject.isAccessible();
    }

    public final String getName() {
        return this.member.getName();
    }

    public final int getModifiers() {
        return this.member.getModifiers();
    }

    public final boolean isSynthetic() {
        return this.member.isSynthetic();
    }

    public final boolean isPublic() {
        return Modifier.isPublic((int)this.getModifiers());
    }

    public final boolean isProtected() {
        return Modifier.isProtected((int)this.getModifiers());
    }

    public final boolean isPackagePrivate() {
        return !this.isPrivate() && !this.isPublic() && !this.isProtected();
    }

    public final boolean isPrivate() {
        return Modifier.isPrivate((int)this.getModifiers());
    }

    public final boolean isStatic() {
        return Modifier.isStatic((int)this.getModifiers());
    }

    public final boolean isFinal() {
        return Modifier.isFinal((int)this.getModifiers());
    }

    public final boolean isAbstract() {
        return Modifier.isAbstract((int)this.getModifiers());
    }

    public final boolean isNative() {
        return Modifier.isNative((int)this.getModifiers());
    }

    public final boolean isSynchronized() {
        return Modifier.isSynchronized((int)this.getModifiers());
    }

    final boolean isVolatile() {
        return Modifier.isVolatile((int)this.getModifiers());
    }

    final boolean isTransient() {
        return Modifier.isTransient((int)this.getModifiers());
    }

    public boolean equals(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object obj) {
        if (obj instanceof Invokable) {
            Invokable that = (Invokable)obj;
            return this.getOwnerType().equals(that.getOwnerType()) && this.member.equals((org.rascalmpl.org.rascalmpl.java.lang.Object)that.member);
        }
        return false;
    }

    public int hashCode() {
        return this.member.hashCode();
    }

    public String toString() {
        return this.member.toString();
    }

    public abstract boolean isOverridable();

    public abstract boolean isVarArgs();

    @CheckForNull
    @CanIgnoreReturnValue
    public final R invoke(@CheckForNull T receiver, org.rascalmpl.org.rascalmpl.java.lang.Object ... args) throws InvocationTargetException, IllegalAccessException {
        return (R)this.invokeInternal((org.rascalmpl.org.rascalmpl.java.lang.Object)receiver, Preconditions.checkNotNull(args));
    }

    public final TypeToken<? extends R> getReturnType() {
        return TypeToken.of(this.getGenericReturnType());
    }

    @IgnoreJRERequirement
    public final ImmutableList<Parameter> getParameters() {
        Type[] parameterTypes = this.getGenericParameterTypes();
        Annotation[][] annotations = this.getParameterAnnotations();
        @Nullable AnnotatedType[] annotatedTypes = ANNOTATED_TYPE_EXISTS ? this.getAnnotatedParameterTypes() : new org.rascalmpl.org.rascalmpl.java.lang.Object[parameterTypes.length];
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < parameterTypes.length; ++i) {
            builder.add(new Parameter(this, i, TypeToken.of(parameterTypes[i]), annotations[i], (org.rascalmpl.org.rascalmpl.java.lang.Object)annotatedTypes[i]));
        }
        return builder.build();
    }

    public final ImmutableList<TypeToken<? extends Throwable>> getExceptionTypes() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Type type : this.getGenericExceptionTypes()) {
            TypeToken<?> exceptionType = TypeToken.of(type);
            builder.add(exceptionType);
        }
        return builder.build();
    }

    public final <R1 extends R> Invokable<T, R1> returning(Class<R1> returnType) {
        return this.returning(TypeToken.of(returnType));
    }

    public final <R1 extends R> Invokable<T, R1> returning(TypeToken<R1> returnType) {
        if (!returnType.isSupertypeOf(this.getReturnType())) {
            throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.Invokable is known to return ").append(this.getReturnType()).append((String)"org.rascalmpl.org.rascalmpl., not ").append(returnType).toString());
        }
        Invokable specialized = this;
        return specialized;
    }

    public final Class<? super T> getDeclaringClass() {
        return this.member.getDeclaringClass();
    }

    public TypeToken<T> getOwnerType() {
        return TypeToken.of(this.getDeclaringClass());
    }

    @CheckForNull
    abstract org.rascalmpl.org.rascalmpl.java.lang.Object invokeInternal(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object var1, @Nullable org.rascalmpl.org.rascalmpl.java.lang.Object[] var2) throws InvocationTargetException, IllegalAccessException;

    abstract Type[] getGenericParameterTypes();

    abstract AnnotatedType[] getAnnotatedParameterTypes();

    abstract Type[] getGenericExceptionTypes();

    abstract Annotation[][] getParameterAnnotations();

    abstract Type getGenericReturnType();

    public abstract AnnotatedType getAnnotatedReturnType();

    private static boolean initAnnotatedTypeExists() {
        try {
            Class.forName((String)"org.rascalmpl.org.rascalmpl.java.lang.reflect.AnnotatedType");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    static class ConstructorInvokable<T extends org.rascalmpl.org.rascalmpl.java.lang.Object>
    extends Invokable<T, T> {
        final Constructor<?> constructor;

        ConstructorInvokable(Constructor<?> constructor) {
            super(constructor);
            this.constructor = constructor;
        }

        @Override
        final org.rascalmpl.org.rascalmpl.java.lang.Object invokeInternal(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object receiver, @Nullable org.rascalmpl.org.rascalmpl.java.lang.Object[] args) throws InvocationTargetException, IllegalAccessException {
            try {
                return this.constructor.newInstance(args);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(new StringBuilder().append(this.constructor).append((String)"org.rascalmpl.org.rascalmpl. failed.").toString(), (Throwable)((Object)e));
            }
        }

        @Override
        Type getGenericReturnType() {
            Class declaringClass = this.getDeclaringClass();
            TypeVariable[] typeParams = declaringClass.getTypeParameters();
            if (typeParams.length > 0) {
                return Types.newParameterizedType(declaringClass, (Type[])typeParams);
            }
            return declaringClass;
        }

        @Override
        Type[] getGenericParameterTypes() {
            Class[] rawParamTypes;
            Type[] types = this.constructor.getGenericParameterTypes();
            if (types.length > 0 && this.mayNeedHiddenThis() && types.length == (rawParamTypes = this.constructor.getParameterTypes()).length && rawParamTypes[0] == this.getDeclaringClass().getEnclosingClass()) {
                return (Type[])Arrays.copyOfRange((org.rascalmpl.org.rascalmpl.java.lang.Object[])types, (int)1, (int)types.length);
            }
            return types;
        }

        @Override
        AnnotatedType[] getAnnotatedParameterTypes() {
            return this.constructor.getAnnotatedParameterTypes();
        }

        @Override
        public AnnotatedType getAnnotatedReturnType() {
            return this.constructor.getAnnotatedReturnType();
        }

        @Override
        Type[] getGenericExceptionTypes() {
            return this.constructor.getGenericExceptionTypes();
        }

        @Override
        final Annotation[][] getParameterAnnotations() {
            return this.constructor.getParameterAnnotations();
        }

        @Override
        public final TypeVariable<?>[] getTypeParameters() {
            TypeVariable[] declaredByClass = this.getDeclaringClass().getTypeParameters();
            TypeVariable[] declaredByConstructor = this.constructor.getTypeParameters();
            TypeVariable[] result = new TypeVariable[declaredByClass.length + declaredByConstructor.length];
            System.arraycopy((org.rascalmpl.org.rascalmpl.java.lang.Object)declaredByClass, (int)0, (org.rascalmpl.org.rascalmpl.java.lang.Object)result, (int)0, (int)declaredByClass.length);
            System.arraycopy((org.rascalmpl.org.rascalmpl.java.lang.Object)declaredByConstructor, (int)0, (org.rascalmpl.org.rascalmpl.java.lang.Object)result, (int)declaredByClass.length, (int)declaredByConstructor.length);
            return result;
        }

        @Override
        public final boolean isOverridable() {
            return false;
        }

        @Override
        public final boolean isVarArgs() {
            return this.constructor.isVarArgs();
        }

        private boolean mayNeedHiddenThis() {
            Class declaringClass = this.constructor.getDeclaringClass();
            if (declaringClass.getEnclosingConstructor() != null) {
                return true;
            }
            Method enclosingMethod = declaringClass.getEnclosingMethod();
            if (enclosingMethod != null) {
                return !Modifier.isStatic((int)enclosingMethod.getModifiers());
            }
            return declaringClass.getEnclosingClass() != null && !Modifier.isStatic((int)declaringClass.getModifiers());
        }
    }

    static class MethodInvokable<T extends org.rascalmpl.org.rascalmpl.java.lang.Object>
    extends Invokable<T, org.rascalmpl.org.rascalmpl.java.lang.Object> {
        final Method method;

        MethodInvokable(Method method) {
            super(method);
            this.method = method;
        }

        @Override
        @CheckForNull
        final org.rascalmpl.org.rascalmpl.java.lang.Object invokeInternal(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object receiver, @Nullable org.rascalmpl.org.rascalmpl.java.lang.Object[] args) throws InvocationTargetException, IllegalAccessException {
            return this.method.invoke(receiver, args);
        }

        @Override
        Type getGenericReturnType() {
            return this.method.getGenericReturnType();
        }

        @Override
        Type[] getGenericParameterTypes() {
            return this.method.getGenericParameterTypes();
        }

        @Override
        AnnotatedType[] getAnnotatedParameterTypes() {
            return this.method.getAnnotatedParameterTypes();
        }

        @Override
        public AnnotatedType getAnnotatedReturnType() {
            return this.method.getAnnotatedReturnType();
        }

        @Override
        Type[] getGenericExceptionTypes() {
            return this.method.getGenericExceptionTypes();
        }

        @Override
        final Annotation[][] getParameterAnnotations() {
            return this.method.getParameterAnnotations();
        }

        @Override
        public final TypeVariable<?>[] getTypeParameters() {
            return this.method.getTypeParameters();
        }

        @Override
        public final boolean isOverridable() {
            return !this.isFinal() && !this.isPrivate() && !this.isStatic() && !Modifier.isFinal((int)this.getDeclaringClass().getModifiers());
        }

        @Override
        public final boolean isVarArgs() {
            return this.method.isVarArgs();
        }
    }
}

