/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.reflect;

import org.rascalmpl.org.rascalmpl.com.google.common.base.Joiner;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Objects;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableMap;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.org.rascalmpl.com.google.common.reflect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.reflect.TypeVisitor;
import org.rascalmpl.org.rascalmpl.com.google.common.reflect.Types;
import org.rascalmpl.org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.org.rascalmpl.java.lang.Class;
import org.rascalmpl.org.rascalmpl.java.lang.ClassCastException;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.GenericArrayType;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.ParameterizedType;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.Type;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.TypeVariable;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.WildcardType;
import org.rascalmpl.org.rascalmpl.java.util.Arrays;
import org.rascalmpl.org.rascalmpl.java.util.Collection;
import org.rascalmpl.org.rascalmpl.java.util.HashMap;
import org.rascalmpl.org.rascalmpl.java.util.LinkedHashSet;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.atomic.AtomicInteger;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
public final class TypeResolver
extends org.rascalmpl.org.rascalmpl.java.lang.Object {
    private final TypeTable typeTable;

    public TypeResolver() {
        this.typeTable = new TypeTable();
    }

    private TypeResolver(TypeTable typeTable) {
        this.typeTable = typeTable;
    }

    static TypeResolver covariantly(Type contextType) {
        return new TypeResolver().where(TypeMappingIntrospector.getTypeMappings(contextType));
    }

    static TypeResolver invariantly(Type contextType) {
        Type invariantContext = WildcardCapturer.INSTANCE.capture(contextType);
        return new TypeResolver().where(TypeMappingIntrospector.getTypeMappings(invariantContext));
    }

    public TypeResolver where(Type formal, Type actual) {
        HashMap mappings = Maps.newHashMap();
        TypeResolver.populateTypeMappings(mappings, Preconditions.checkNotNull(formal), Preconditions.checkNotNull(actual));
        return this.where((Map<TypeVariableKey, ? extends Type>)mappings);
    }

    TypeResolver where(Map<TypeVariableKey, ? extends Type> mappings) {
        return new TypeResolver(this.typeTable.where(mappings));
    }

    private static void populateTypeMappings(final Map<TypeVariableKey, Type> mappings, Type from, final Type to) {
        if (from.equals((org.rascalmpl.org.rascalmpl.java.lang.Object)to)) {
            return;
        }
        new TypeVisitor(){

            @Override
            void visitTypeVariable(TypeVariable<?> typeVariable) {
                mappings.put((org.rascalmpl.org.rascalmpl.java.lang.Object)new TypeVariableKey(typeVariable), (org.rascalmpl.org.rascalmpl.java.lang.Object)to);
            }

            @Override
            void visitWildcardType(WildcardType fromWildcardType) {
                int i;
                if (!(to instanceof WildcardType)) {
                    return;
                }
                WildcardType toWildcardType = (WildcardType)to;
                Type[] fromUpperBounds = fromWildcardType.getUpperBounds();
                Type[] toUpperBounds = toWildcardType.getUpperBounds();
                Type[] fromLowerBounds = fromWildcardType.getLowerBounds();
                Type[] toLowerBounds = toWildcardType.getLowerBounds();
                Preconditions.checkArgument(fromUpperBounds.length == toUpperBounds.length && fromLowerBounds.length == toLowerBounds.length, (String)"org.rascalmpl.org.rascalmpl.Incompatible type: %s vs. %s", (org.rascalmpl.org.rascalmpl.java.lang.Object)fromWildcardType, (org.rascalmpl.org.rascalmpl.java.lang.Object)to);
                for (i = 0; i < fromUpperBounds.length; ++i) {
                    TypeResolver.populateTypeMappings((Map<TypeVariableKey, Type>)mappings, fromUpperBounds[i], toUpperBounds[i]);
                }
                for (i = 0; i < fromLowerBounds.length; ++i) {
                    TypeResolver.populateTypeMappings((Map<TypeVariableKey, Type>)mappings, fromLowerBounds[i], toLowerBounds[i]);
                }
            }

            @Override
            void visitParameterizedType(ParameterizedType fromParameterizedType) {
                if (to instanceof WildcardType) {
                    return;
                }
                ParameterizedType toParameterizedType = (ParameterizedType)TypeResolver.expectArgument(ParameterizedType.class, (org.rascalmpl.org.rascalmpl.java.lang.Object)to);
                if (fromParameterizedType.getOwnerType() != null && toParameterizedType.getOwnerType() != null) {
                    TypeResolver.populateTypeMappings((Map<TypeVariableKey, Type>)mappings, fromParameterizedType.getOwnerType(), toParameterizedType.getOwnerType());
                }
                Preconditions.checkArgument(fromParameterizedType.getRawType().equals((org.rascalmpl.org.rascalmpl.java.lang.Object)toParameterizedType.getRawType()), (String)"org.rascalmpl.org.rascalmpl.Inconsistent raw type: %s vs. %s", (org.rascalmpl.org.rascalmpl.java.lang.Object)fromParameterizedType, (org.rascalmpl.org.rascalmpl.java.lang.Object)to);
                Type[] fromArgs = fromParameterizedType.getActualTypeArguments();
                Type[] toArgs = toParameterizedType.getActualTypeArguments();
                Preconditions.checkArgument(fromArgs.length == toArgs.length, (String)"org.rascalmpl.org.rascalmpl.%s not compatible with %s", (org.rascalmpl.org.rascalmpl.java.lang.Object)fromParameterizedType, (org.rascalmpl.org.rascalmpl.java.lang.Object)toParameterizedType);
                for (int i = 0; i < fromArgs.length; ++i) {
                    TypeResolver.populateTypeMappings((Map<TypeVariableKey, Type>)mappings, fromArgs[i], toArgs[i]);
                }
            }

            @Override
            void visitGenericArrayType(GenericArrayType fromArrayType) {
                if (to instanceof WildcardType) {
                    return;
                }
                Type componentType = Types.getComponentType(to);
                Preconditions.checkArgument(componentType != null, (String)"org.rascalmpl.org.rascalmpl.%s is not an array type.", (org.rascalmpl.org.rascalmpl.java.lang.Object)to);
                TypeResolver.populateTypeMappings((Map<TypeVariableKey, Type>)mappings, fromArrayType.getGenericComponentType(), componentType);
            }

            @Override
            void visitClass(Class<?> fromClass) {
                if (to instanceof WildcardType) {
                    return;
                }
                throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.No type mapping from ").append(fromClass).append((String)"org.rascalmpl.org.rascalmpl. to ").append((org.rascalmpl.org.rascalmpl.java.lang.Object)to).toString());
            }
        }.visit(from);
    }

    public Type resolveType(Type type) {
        Preconditions.checkNotNull(type);
        if (type instanceof TypeVariable) {
            return this.typeTable.resolve((TypeVariable)type);
        }
        if (type instanceof ParameterizedType) {
            return this.resolveParameterizedType((ParameterizedType)type);
        }
        if (type instanceof GenericArrayType) {
            return this.resolveGenericArrayType((GenericArrayType)type);
        }
        if (type instanceof WildcardType) {
            return this.resolveWildcardType((WildcardType)type);
        }
        return type;
    }

    Type[] resolveTypesInPlace(Type[] types) {
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.resolveType(types[i]);
        }
        return types;
    }

    private Type[] resolveTypes(Type[] types) {
        Type[] result = new Type[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = this.resolveType(types[i]);
        }
        return result;
    }

    private WildcardType resolveWildcardType(WildcardType type) {
        Type[] lowerBounds = type.getLowerBounds();
        Type[] upperBounds = type.getUpperBounds();
        return new Types.WildcardTypeImpl(this.resolveTypes(lowerBounds), this.resolveTypes(upperBounds));
    }

    private Type resolveGenericArrayType(GenericArrayType type) {
        Type componentType = type.getGenericComponentType();
        Type resolvedComponentType = this.resolveType(componentType);
        return Types.newArrayType(resolvedComponentType);
    }

    private ParameterizedType resolveParameterizedType(ParameterizedType type) {
        Type owner = type.getOwnerType();
        Type resolvedOwner = owner == null ? null : this.resolveType(owner);
        Type resolvedRawType = this.resolveType(type.getRawType());
        Type[] args = type.getActualTypeArguments();
        Type[] resolvedArgs = this.resolveTypes(args);
        return Types.newParameterizedTypeWithOwner(resolvedOwner, (Class)resolvedRawType, resolvedArgs);
    }

    private static <T extends org.rascalmpl.org.rascalmpl.java.lang.Object> T expectArgument(Class<T> type, org.rascalmpl.org.rascalmpl.java.lang.Object arg) {
        try {
            return (T)type.cast(arg);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(new StringBuilder().append(arg).append((String)"org.rascalmpl.org.rascalmpl. is not a ").append(type.getSimpleName()).toString());
        }
    }

    static final class TypeVariableKey
    extends org.rascalmpl.org.rascalmpl.java.lang.Object {
        private final TypeVariable<?> var;

        TypeVariableKey(TypeVariable<?> var) {
            this.var = Preconditions.checkNotNull(var);
        }

        public int hashCode() {
            return Objects.hashCode(new org.rascalmpl.org.rascalmpl.java.lang.Object[]{this.var.getGenericDeclaration(), this.var.getName()});
        }

        public boolean equals(@CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object obj) {
            if (obj instanceof TypeVariableKey) {
                TypeVariableKey that = (TypeVariableKey)obj;
                return this.equalsTypeVariable(that.var);
            }
            return false;
        }

        public String toString() {
            return this.var.toString();
        }

        @CheckForNull
        static TypeVariableKey forLookup(Type t2) {
            if (t2 instanceof TypeVariable) {
                return new TypeVariableKey((TypeVariable)t2);
            }
            return null;
        }

        boolean equalsType(Type type) {
            if (type instanceof TypeVariable) {
                return this.equalsTypeVariable((TypeVariable)type);
            }
            return false;
        }

        private boolean equalsTypeVariable(TypeVariable<?> that) {
            return this.var.getGenericDeclaration().equals((org.rascalmpl.org.rascalmpl.java.lang.Object)that.getGenericDeclaration()) && this.var.getName().equals((org.rascalmpl.org.rascalmpl.java.lang.Object)that.getName());
        }
    }

    private static class WildcardCapturer
    extends org.rascalmpl.org.rascalmpl.java.lang.Object {
        static final WildcardCapturer INSTANCE = new WildcardCapturer();
        private final AtomicInteger id;

        private WildcardCapturer() {
            this(new AtomicInteger());
        }

        private WildcardCapturer(AtomicInteger id) {
            this.id = id;
        }

        final Type capture(Type type) {
            Preconditions.checkNotNull(type);
            if (type instanceof Class) {
                return type;
            }
            if (type instanceof TypeVariable) {
                return type;
            }
            if (type instanceof GenericArrayType) {
                GenericArrayType arrayType = (GenericArrayType)type;
                return Types.newArrayType(this.notForTypeVariable().capture(arrayType.getGenericComponentType()));
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Class rawType = (Class)parameterizedType.getRawType();
                TypeVariable[] typeVars = rawType.getTypeParameters();
                Type[] typeArgs = parameterizedType.getActualTypeArguments();
                for (int i = 0; i < typeArgs.length; ++i) {
                    typeArgs[i] = this.forTypeVariable(typeVars[i]).capture(typeArgs[i]);
                }
                return Types.newParameterizedTypeWithOwner(this.notForTypeVariable().captureNullable(parameterizedType.getOwnerType()), rawType, typeArgs);
            }
            if (type instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)type;
                Type[] lowerBounds = wildcardType.getLowerBounds();
                if (lowerBounds.length == 0) {
                    return this.captureAsTypeVariable(wildcardType.getUpperBounds());
                }
                return type;
            }
            throw new AssertionError((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.must have been one of the known types");
        }

        TypeVariable<?> captureAsTypeVariable(Type[] upperBounds) {
            String name = new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.capture#").append(this.id.incrementAndGet()).append((String)"org.rascalmpl.org.rascalmpl.-of ? extends ").append(Joiner.on('&').join((org.rascalmpl.org.rascalmpl.java.lang.Object[])upperBounds)).toString();
            return Types.newArtificialTypeVariable(WildcardCapturer.class, name, upperBounds);
        }

        private WildcardCapturer forTypeVariable(final TypeVariable<?> typeParam) {
            return new WildcardCapturer(this.id){

                @Override
                TypeVariable<?> captureAsTypeVariable(Type[] upperBounds) {
                    LinkedHashSet combined = new LinkedHashSet((Collection)Arrays.asList((org.rascalmpl.org.rascalmpl.java.lang.Object[])upperBounds));
                    combined.addAll((Collection)Arrays.asList((org.rascalmpl.org.rascalmpl.java.lang.Object[])typeParam.getBounds()));
                    if (combined.size() > 1) {
                        combined.remove(org.rascalmpl.org.rascalmpl.java.lang.Object.class);
                    }
                    return super.captureAsTypeVariable((Type[])combined.toArray((org.rascalmpl.org.rascalmpl.java.lang.Object[])new Type[0]));
                }
            };
        }

        private WildcardCapturer notForTypeVariable() {
            return new WildcardCapturer(this.id);
        }

        @CheckForNull
        private Type captureNullable(@CheckForNull Type type) {
            if (type == null) {
                return null;
            }
            return this.capture(type);
        }
    }

    private static final class TypeMappingIntrospector
    extends TypeVisitor {
        private final Map<TypeVariableKey, Type> mappings = Maps.newHashMap();

        private TypeMappingIntrospector() {
        }

        static ImmutableMap<TypeVariableKey, Type> getTypeMappings(Type contextType) {
            Preconditions.checkNotNull(contextType);
            TypeMappingIntrospector introspector = new TypeMappingIntrospector();
            introspector.visit(contextType);
            return ImmutableMap.copyOf(introspector.mappings);
        }

        @Override
        void visitClass(Class<?> clazz) {
            this.visit(clazz.getGenericSuperclass());
            this.visit(clazz.getGenericInterfaces());
        }

        @Override
        void visitParameterizedType(ParameterizedType parameterizedType) {
            Type[] typeArgs;
            Class rawClass = (Class)parameterizedType.getRawType();
            TypeVariable[] vars = rawClass.getTypeParameters();
            Preconditions.checkState(vars.length == (typeArgs = parameterizedType.getActualTypeArguments()).length);
            for (int i = 0; i < vars.length; ++i) {
                this.map(new TypeVariableKey(vars[i]), typeArgs[i]);
            }
            this.visit(new Type[]{rawClass});
            this.visit(parameterizedType.getOwnerType());
        }

        @Override
        void visitTypeVariable(TypeVariable<?> t2) {
            this.visit(t2.getBounds());
        }

        @Override
        void visitWildcardType(WildcardType t2) {
            this.visit(t2.getUpperBounds());
        }

        private void map(TypeVariableKey var, Type arg) {
            if (this.mappings.containsKey((org.rascalmpl.org.rascalmpl.java.lang.Object)var)) {
                return;
            }
            Type t2 = arg;
            while (t2 != null) {
                if (var.equalsType(t2)) {
                    Type x = arg;
                    while (x != null) {
                        x = (Type)this.mappings.remove((org.rascalmpl.org.rascalmpl.java.lang.Object)TypeVariableKey.forLookup(x));
                    }
                    return;
                }
                t2 = (Type)this.mappings.get((org.rascalmpl.org.rascalmpl.java.lang.Object)TypeVariableKey.forLookup(t2));
            }
            this.mappings.put((org.rascalmpl.org.rascalmpl.java.lang.Object)var, (org.rascalmpl.org.rascalmpl.java.lang.Object)arg);
        }
    }

    private static class TypeTable
    extends org.rascalmpl.org.rascalmpl.java.lang.Object {
        private final ImmutableMap<TypeVariableKey, Type> map;

        TypeTable() {
            this.map = ImmutableMap.of();
        }

        private TypeTable(ImmutableMap<TypeVariableKey, Type> map) {
            this.map = map;
        }

        final TypeTable where(Map<TypeVariableKey, ? extends Type> mappings) {
            ImmutableMap.Builder<TypeVariableKey, Type> builder = ImmutableMap.builder();
            builder.putAll(this.map);
            for (Map.Entry mapping : mappings.entrySet()) {
                Type type;
                TypeVariableKey variable = (TypeVariableKey)mapping.getKey();
                Preconditions.checkArgument(!variable.equalsType(type = (Type)mapping.getValue()), (String)"org.rascalmpl.org.rascalmpl.Type variable %s bound to itself", (org.rascalmpl.org.rascalmpl.java.lang.Object)variable);
                builder.put(variable, type);
            }
            return new TypeTable(builder.buildOrThrow());
        }

        final Type resolve(final TypeVariable<?> var) {
            final TypeTable unguarded = this;
            TypeTable guarded = new TypeTable(){

                @Override
                public Type resolveInternal(TypeVariable<?> intermediateVar, TypeTable forDependent) {
                    if (intermediateVar.getGenericDeclaration().equals((org.rascalmpl.org.rascalmpl.java.lang.Object)var.getGenericDeclaration())) {
                        return intermediateVar;
                    }
                    return unguarded.resolveInternal(intermediateVar, forDependent);
                }
            };
            return this.resolveInternal(var, guarded);
        }

        Type resolveInternal(TypeVariable<?> var, TypeTable forDependants) {
            Type type = this.map.get(new TypeVariableKey(var));
            if (type == null) {
                Type[] bounds = var.getBounds();
                if (bounds.length == 0) {
                    return var;
                }
                Type[] resolvedBounds = new TypeResolver(forDependants).resolveTypes(bounds);
                if (Types.NativeTypeVariableEquals.NATIVE_TYPE_VARIABLE_ONLY && Arrays.equals((org.rascalmpl.org.rascalmpl.java.lang.Object[])bounds, (org.rascalmpl.org.rascalmpl.java.lang.Object[])resolvedBounds)) {
                    return var;
                }
                return Types.newArtificialTypeVariable(var.getGenericDeclaration(), var.getName(), resolvedBounds);
            }
            return new TypeResolver(forDependants).resolveType(type);
        }
    }
}

