/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.reflect;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.VisibleForTesting;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Joiner;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Objects;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Predicates;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableList;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableMap;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Iterables;
import org.rascalmpl.org.rascalmpl.com.google.common.reflect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.reflect.Reflection;
import org.rascalmpl.org.rascalmpl.com.google.common.reflect.TypeCapture;
import org.rascalmpl.org.rascalmpl.com.google.common.reflect.TypeVisitor;
import org.rascalmpl.org.rascalmpl.java.io.Serializable;
import org.rascalmpl.org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.org.rascalmpl.java.lang.Class;
import org.rascalmpl.org.rascalmpl.java.lang.Enum;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalAccessException;
import org.rascalmpl.org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.org.rascalmpl.java.lang.NoSuchMethodException;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.RuntimeException;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.lang.UnsupportedOperationException;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.AnnotatedElement;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.Array;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.GenericArrayType;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.GenericDeclaration;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.InvocationHandler;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.InvocationTargetException;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.Method;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.ParameterizedType;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.Proxy;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.Type;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.TypeVariable;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.WildcardType;
import org.rascalmpl.org.rascalmpl.java.security.AccessControlException;
import org.rascalmpl.org.rascalmpl.java.util.Arrays;
import org.rascalmpl.org.rascalmpl.java.util.Collection;
import org.rascalmpl.org.rascalmpl.java.util.Iterator;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.atomic.AtomicReference;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
final class Types
extends Object {
    private static final Joiner COMMA_JOINER = Joiner.on((String)"org.rascalmpl.org.rascalmpl., ").useForNull((String)"org.rascalmpl.org.rascalmpl.null");

    static Type newArrayType(Type componentType) {
        if (componentType instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)componentType;
            Type[] lowerBounds = wildcard.getLowerBounds();
            Preconditions.checkArgument(lowerBounds.length <= 1, (Object)"org.rascalmpl.org.rascalmpl.Wildcard cannot have more than one lower bounds.");
            if (lowerBounds.length == 1) {
                return Types.supertypeOf(Types.newArrayType(lowerBounds[0]));
            }
            Type[] upperBounds = wildcard.getUpperBounds();
            Preconditions.checkArgument(upperBounds.length == 1, (Object)"org.rascalmpl.org.rascalmpl.Wildcard should have only one upper bound.");
            return Types.subtypeOf(Types.newArrayType(upperBounds[0]));
        }
        return JavaVersion.CURRENT.newArrayType(componentType);
    }

    static ParameterizedType newParameterizedTypeWithOwner(@CheckForNull Type ownerType, Class<?> rawType, Type ... arguments) {
        if (ownerType == null) {
            return Types.newParameterizedType(rawType, arguments);
        }
        Preconditions.checkNotNull(arguments);
        Preconditions.checkArgument(rawType.getEnclosingClass() != null, (String)"org.rascalmpl.org.rascalmpl.Owner type for unenclosed %s", rawType);
        return new ParameterizedTypeImpl(ownerType, rawType, arguments);
    }

    static ParameterizedType newParameterizedType(Class<?> rawType, Type ... arguments) {
        return new ParameterizedTypeImpl((Type)ClassOwnership.JVM_BEHAVIOR.getOwnerType(rawType), rawType, arguments);
    }

    static <D extends GenericDeclaration> TypeVariable<D> newArtificialTypeVariable(D declaration, String name, Type ... bounds) {
        Type[] typeArray;
        if (bounds.length == 0) {
            Type[] typeArray2 = new Type[1];
            typeArray = typeArray2;
            typeArray2[0] = Object.class;
        } else {
            typeArray = bounds;
        }
        return Types.newTypeVariableImpl(declaration, name, typeArray);
    }

    @VisibleForTesting
    static WildcardType subtypeOf(Type upperBound) {
        return new WildcardTypeImpl(new Type[0], new Type[]{upperBound});
    }

    @VisibleForTesting
    static WildcardType supertypeOf(Type lowerBound) {
        return new WildcardTypeImpl(new Type[]{lowerBound}, new Type[]{Object.class});
    }

    static String toString(Type type) {
        return type instanceof Class ? ((Class)type).getName() : type.toString();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @CheckForNull
    static Type getComponentType(Type type) {
        Preconditions.checkNotNull(type);
        final @Nullable AtomicReference result = new AtomicReference();
        new TypeVisitor(){

            @Override
            void visitTypeVariable(TypeVariable<?> t2) {
                result.set((Object)Types.subtypeOfComponentType(t2.getBounds()));
            }

            @Override
            void visitWildcardType(WildcardType t2) {
                result.set((Object)Types.subtypeOfComponentType(t2.getUpperBounds()));
            }

            @Override
            void visitGenericArrayType(GenericArrayType t2) {
                result.set((Object)t2.getGenericComponentType());
            }

            @Override
            void visitClass(Class<?> t2) {
                result.set((Object)t2.getComponentType());
            }
        }.visit(type);
        return (Type)result.get();
    }

    @CheckForNull
    private static Type subtypeOfComponentType(Type[] bounds) {
        for (Type bound : bounds) {
            Class componentClass;
            Type componentType = Types.getComponentType(bound);
            if (componentType == null) continue;
            if (componentType instanceof Class && (componentClass = (Class)componentType).isPrimitive()) {
                return componentClass;
            }
            return Types.subtypeOf(componentType);
        }
        return null;
    }

    private static <D extends GenericDeclaration> TypeVariable<D> newTypeVariableImpl(D genericDeclaration, String name, Type[] bounds) {
        TypeVariableImpl<D> typeVariableImpl = new TypeVariableImpl<D>(genericDeclaration, name, bounds);
        TypeVariable typeVariable = Reflection.newProxy(TypeVariable.class, new TypeVariableInvocationHandler(typeVariableImpl));
        return typeVariable;
    }

    private static Type[] toArray(Collection<Type> types) {
        return (Type[])types.toArray((Object[])new Type[0]);
    }

    private static Iterable<Type> filterUpperBounds(Iterable<Type> bounds) {
        return Iterables.filter(bounds, Predicates.not(Predicates.equalTo(Object.class)));
    }

    private static void disallowPrimitiveType(Type[] types, String usedAs) {
        for (Type type : types) {
            if (!(type instanceof Class)) continue;
            Class cls = (Class)type;
            Preconditions.checkArgument(!cls.isPrimitive(), (String)"org.rascalmpl.org.rascalmpl.Primitive type '%s' used as %s", (Object)cls, (Object)usedAs);
        }
    }

    static Class<?> getArrayClass(Class<?> componentType) {
        return Array.newInstance(componentType, (int)0).getClass();
    }

    private Types() {
    }

    static /* synthetic */ Joiner access$400() {
        return COMMA_JOINER;
    }

    static final class NativeTypeVariableEquals<X extends Object>
    extends Object {
        static final boolean NATIVE_TYPE_VARIABLE_ONLY = !NativeTypeVariableEquals.class.getTypeParameters()[0].equals(Types.newArtificialTypeVariable(NativeTypeVariableEquals.class, (String)"org.rascalmpl.org.rascalmpl.X", new Type[0]));

        NativeTypeVariableEquals() {
        }
    }

    static abstract class JavaVersion
    extends Enum<JavaVersion> {
        public static final /* enum */ JavaVersion JAVA6 = new JavaVersion(){

            GenericArrayType newArrayType(Type componentType) {
                return new GenericArrayTypeImpl(componentType);
            }

            @Override
            Type usedInGenericType(Type type) {
                Class cls;
                Preconditions.checkNotNull(type);
                if (type instanceof Class && (cls = (Class)type).isArray()) {
                    return new GenericArrayTypeImpl((Type)cls.getComponentType());
                }
                return type;
            }
        };
        public static final /* enum */ JavaVersion JAVA7 = new JavaVersion(){

            @Override
            Type newArrayType(Type componentType) {
                if (componentType instanceof Class) {
                    return Types.getArrayClass((Class)componentType);
                }
                return new GenericArrayTypeImpl(componentType);
            }

            @Override
            Type usedInGenericType(Type type) {
                return Preconditions.checkNotNull(type);
            }
        };
        public static final /* enum */ JavaVersion JAVA8 = new JavaVersion(){

            @Override
            Type newArrayType(Type componentType) {
                return JAVA7.newArrayType(componentType);
            }

            @Override
            Type usedInGenericType(Type type) {
                return JAVA7.usedInGenericType(type);
            }

            @Override
            String typeName(Type type) {
                try {
                    Method getTypeName = Type.class.getMethod((String)"org.rascalmpl.org.rascalmpl.getTypeName", new Class[0]);
                    return (String)getTypeName.invoke((Object)type, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new AssertionError((Object)"org.rascalmpl.org.rascalmpl.Type.getTypeName should be available in Java 8");
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException((Throwable)e);
                }
            }
        };
        public static final /* enum */ JavaVersion JAVA9 = new JavaVersion(){

            @Override
            Type newArrayType(Type componentType) {
                return JAVA8.newArrayType(componentType);
            }

            @Override
            Type usedInGenericType(Type type) {
                return JAVA8.usedInGenericType(type);
            }

            @Override
            String typeName(Type type) {
                return JAVA8.typeName(type);
            }

            @Override
            boolean jdkTypeDuplicatesOwnerName() {
                return false;
            }
        };
        static final JavaVersion CURRENT;
        private static final /* synthetic */ JavaVersion[] $VALUES;

        public static JavaVersion[] values() {
            return (JavaVersion[])$VALUES.clone();
        }

        public static JavaVersion valueOf(String name) {
            return (JavaVersion)Enum.valueOf(JavaVersion.class, (String)name);
        }

        private JavaVersion() {
            super((String)string, n);
        }

        abstract Type newArrayType(Type var1);

        abstract Type usedInGenericType(Type var1);

        final ImmutableList<Type> usedInGenericType(Type[] types) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Type type : types) {
                builder.add((Object)this.usedInGenericType(type));
            }
            return builder.build();
        }

        String typeName(Type type) {
            return Types.toString(type);
        }

        boolean jdkTypeDuplicatesOwnerName() {
            return true;
        }

        static {
            $VALUES = new JavaVersion[]{JAVA6, JAVA7, JAVA8, JAVA9};
            CURRENT = AnnotatedElement.class.isAssignableFrom(TypeVariable.class) ? (new TypeCapture<Map.Entry<String, int[][]>>(){}.capture().toString().contains((CharSequence)"org.rascalmpl.org.rascalmpl.java.util.Map.java.util.Map") ? JAVA8 : JAVA9) : (new TypeCapture<int[]>(){}.capture() instanceof Class ? JAVA7 : JAVA6);
        }
    }

    static final class WildcardTypeImpl
    extends Object
    implements WildcardType,
    Serializable {
        private final ImmutableList<Type> lowerBounds;
        private final ImmutableList<Type> upperBounds;
        private static final long serialVersionUID = 0L;

        WildcardTypeImpl(Type[] lowerBounds, Type[] upperBounds) {
            Types.disallowPrimitiveType(lowerBounds, (String)"org.rascalmpl.org.rascalmpl.lower bound for wildcard");
            Types.disallowPrimitiveType(upperBounds, (String)"org.rascalmpl.org.rascalmpl.upper bound for wildcard");
            this.lowerBounds = JavaVersion.CURRENT.usedInGenericType(lowerBounds);
            this.upperBounds = JavaVersion.CURRENT.usedInGenericType(upperBounds);
        }

        public Type[] getLowerBounds() {
            return Types.toArray((Collection<Type>)this.lowerBounds);
        }

        public Type[] getUpperBounds() {
            return Types.toArray((Collection<Type>)this.upperBounds);
        }

        public boolean equals(@CheckForNull Object obj) {
            if (obj instanceof WildcardType) {
                WildcardType that = (WildcardType)obj;
                return this.lowerBounds.equals((Object)Arrays.asList((Object[])that.getLowerBounds())) && this.upperBounds.equals((Object)Arrays.asList((Object[])that.getUpperBounds()));
            }
            return false;
        }

        public int hashCode() {
            return this.lowerBounds.hashCode() ^ this.upperBounds.hashCode();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder((String)"org.rascalmpl.org.rascalmpl.?");
            Iterator iterator = this.lowerBounds.iterator();
            while (iterator.hasNext()) {
                Type lowerBound = (Type)iterator.next();
                builder.append((String)"org.rascalmpl.org.rascalmpl. super ").append(JavaVersion.CURRENT.typeName(lowerBound));
            }
            for (Type upperBound : Types.filterUpperBounds((Iterable<Type>)this.upperBounds)) {
                builder.append((String)"org.rascalmpl.org.rascalmpl. extends ").append(JavaVersion.CURRENT.typeName(upperBound));
            }
            return builder.toString();
        }
    }

    private static final class TypeVariableImpl<D extends GenericDeclaration>
    extends Object {
        private final D genericDeclaration;
        private final String name;
        private final ImmutableList<Type> bounds;

        TypeVariableImpl(D genericDeclaration, String name, Type[] bounds) {
            Types.disallowPrimitiveType(bounds, (String)"org.rascalmpl.org.rascalmpl.bound for type variable");
            this.genericDeclaration = (GenericDeclaration)Preconditions.checkNotNull(genericDeclaration);
            this.name = Preconditions.checkNotNull(name);
            this.bounds = ImmutableList.copyOf((Object[])bounds);
        }

        public Type[] getBounds() {
            return Types.toArray((Collection<Type>)this.bounds);
        }

        public D getGenericDeclaration() {
            return this.genericDeclaration;
        }

        public String getName() {
            return this.name;
        }

        public String getTypeName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return this.genericDeclaration.hashCode() ^ this.name.hashCode();
        }

        public boolean equals(@CheckForNull Object obj) {
            if (NativeTypeVariableEquals.NATIVE_TYPE_VARIABLE_ONLY) {
                if (obj != null && Proxy.isProxyClass((Class)obj.getClass()) && Proxy.getInvocationHandler((Object)obj) instanceof TypeVariableInvocationHandler) {
                    TypeVariableInvocationHandler typeVariableInvocationHandler = (TypeVariableInvocationHandler)Proxy.getInvocationHandler((Object)obj);
                    TypeVariableImpl that = typeVariableInvocationHandler.typeVariableImpl;
                    return this.name.equals((Object)that.getName()) && this.genericDeclaration.equals(that.getGenericDeclaration()) && this.bounds.equals((Object)that.bounds);
                }
                return false;
            }
            if (obj instanceof TypeVariable) {
                TypeVariable that = (TypeVariable)obj;
                return this.name.equals((Object)that.getName()) && this.genericDeclaration.equals((Object)that.getGenericDeclaration());
            }
            return false;
        }
    }

    private static final class TypeVariableInvocationHandler
    extends Object
    implements InvocationHandler {
        private static final ImmutableMap<String, Method> typeVariableMethods;
        private final TypeVariableImpl<?> typeVariableImpl;

        TypeVariableInvocationHandler(TypeVariableImpl<?> typeVariableImpl) {
            this.typeVariableImpl = typeVariableImpl;
        }

        @CheckForNull
        public Object invoke(Object proxy, Method method, @CheckForNull @Nullable Object[] args) throws Throwable {
            String methodName = method.getName();
            Method typeVariableMethod = typeVariableMethods.get((Object)methodName);
            if (typeVariableMethod == null) {
                throw new UnsupportedOperationException(methodName);
            }
            try {
                return typeVariableMethod.invoke(this.typeVariableImpl, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        static {
            ImmutableMap.Builder<String, Method> builder = ImmutableMap.builder();
            for (Method method : TypeVariableImpl.class.getMethods()) {
                if (!method.getDeclaringClass().equals(TypeVariableImpl.class)) continue;
                try {
                    method.setAccessible(true);
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
                builder.put(method.getName(), method);
            }
            typeVariableMethods = builder.buildKeepingLast();
        }
    }

    private static final class ParameterizedTypeImpl
    extends Object
    implements ParameterizedType,
    Serializable {
        @CheckForNull
        private final Type ownerType;
        private final ImmutableList<Type> argumentsList;
        private final Class<?> rawType;
        private static final long serialVersionUID = 0L;

        ParameterizedTypeImpl(@CheckForNull Type ownerType, Class<?> rawType, Type[] typeArguments) {
            Preconditions.checkNotNull(rawType);
            Preconditions.checkArgument(typeArguments.length == rawType.getTypeParameters().length);
            Types.disallowPrimitiveType(typeArguments, (String)"org.rascalmpl.org.rascalmpl.type parameter");
            this.ownerType = ownerType;
            this.rawType = rawType;
            this.argumentsList = JavaVersion.CURRENT.usedInGenericType(typeArguments);
        }

        public Type[] getActualTypeArguments() {
            return Types.toArray((Collection<Type>)this.argumentsList);
        }

        public Type getRawType() {
            return this.rawType;
        }

        @CheckForNull
        public Type getOwnerType() {
            return this.ownerType;
        }

        /*
         * Exception decompiling
         */
        public String toString() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/org/rascalmpl/java/lang/Object;)Lorg/rascalmpl/org/rascalmpl/java/lang/Object;
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
             *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public int hashCode() {
            return (this.ownerType == null ? 0 : this.ownerType.hashCode()) ^ this.argumentsList.hashCode() ^ this.rawType.hashCode();
        }

        public boolean equals(@CheckForNull Object other) {
            if (!(other instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType that = (ParameterizedType)other;
            return this.getRawType().equals((Object)that.getRawType()) && Objects.equal((Object)this.getOwnerType(), (Object)that.getOwnerType()) && Arrays.equals((Object[])this.getActualTypeArguments(), (Object[])that.getActualTypeArguments());
        }
    }

    private static final class GenericArrayTypeImpl
    extends Object
    implements GenericArrayType,
    Serializable {
        private final Type componentType;
        private static final long serialVersionUID = 0L;

        GenericArrayTypeImpl(Type componentType) {
            this.componentType = JavaVersion.CURRENT.usedInGenericType(componentType);
        }

        public Type getGenericComponentType() {
            return this.componentType;
        }

        public String toString() {
            return new StringBuilder().append(Types.toString(this.componentType)).append((String)"org.rascalmpl.org.rascalmpl.[]").toString();
        }

        public int hashCode() {
            return this.componentType.hashCode();
        }

        public boolean equals(@CheckForNull Object obj) {
            if (obj instanceof GenericArrayType) {
                GenericArrayType that = (GenericArrayType)obj;
                return Objects.equal((Object)this.getGenericComponentType(), (Object)that.getGenericComponentType());
            }
            return false;
        }
    }

    private static abstract class ClassOwnership
    extends Enum<ClassOwnership> {
        public static final /* enum */ ClassOwnership OWNED_BY_ENCLOSING_CLASS = new ClassOwnership(){

            @Override
            @CheckForNull
            Class<?> getOwnerType(Class<?> rawType) {
                return rawType.getEnclosingClass();
            }
        };
        public static final /* enum */ ClassOwnership LOCAL_CLASS_HAS_NO_OWNER = new ClassOwnership(){

            @Override
            @CheckForNull
            Class<?> getOwnerType(Class<?> rawType) {
                if (rawType.isLocalClass()) {
                    return null;
                }
                return rawType.getEnclosingClass();
            }
        };
        static final ClassOwnership JVM_BEHAVIOR;
        private static final /* synthetic */ ClassOwnership[] $VALUES;

        public static ClassOwnership[] values() {
            return (ClassOwnership[])$VALUES.clone();
        }

        public static ClassOwnership valueOf(String name) {
            return (ClassOwnership)Enum.valueOf(ClassOwnership.class, (String)name);
        }

        private ClassOwnership() {
            super((String)string, n);
        }

        @CheckForNull
        abstract Class<?> getOwnerType(Class<?> var1);

        private static ClassOwnership detectJvmBehavior() {
            class LocalClass<T extends Object>
            extends Object {
                LocalClass() {
                }
            }
            Class subclass = new LocalClass<String>(){
                {
                }
            }.getClass();
            ParameterizedType parameterizedType = (ParameterizedType)org.rascalmpl.org.rascalmpl.java.util.Objects.requireNonNull((Object)((ParameterizedType)subclass.getGenericSuperclass()));
            for (ClassOwnership behavior : ClassOwnership.values()) {
                if (behavior.getOwnerType((Class<?>)LocalClass.class) != parameterizedType.getOwnerType()) continue;
                return behavior;
            }
            throw new AssertionError();
        }

        static {
            $VALUES = new ClassOwnership[]{OWNED_BY_ENCLOSING_CLASS, LOCAL_CLASS_HAS_NO_OWNER};
            JVM_BEHAVIOR = ClassOwnership.detectJvmBehavior();
        }
    }
}

