/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Function;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.AsyncFunction;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.FluentFuture;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.Futures;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ListenableFuture;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.MoreExecutors;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.NullnessCasts;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ParametricNullness;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.Platform;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.internal.InternalFutureFailureAccess;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.internal.InternalFutures;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.ForOverride;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.concurrent.LazyInit;
import org.rascalmpl.org.rascalmpl.java.lang.Class;
import org.rascalmpl.org.rascalmpl.java.lang.Exception;
import org.rascalmpl.org.rascalmpl.java.lang.NullPointerException;
import org.rascalmpl.org.rascalmpl.java.lang.Runnable;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.ExecutionException;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.Executor;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible
abstract class AbstractCatchingFuture<V extends @Nullable org.rascalmpl.org.rascalmpl.java.lang.Object, X extends org.rascalmpl.org.rascalmpl.java.lang.Throwable, F extends org.rascalmpl.org.rascalmpl.java.lang.Object, T extends @Nullable org.rascalmpl.org.rascalmpl.java.lang.Object>
extends FluentFuture.TrustedFuture<V>
implements Runnable {
    @CheckForNull
    @LazyInit
    ListenableFuture<? extends V> inputFuture;
    @CheckForNull
    @LazyInit
    Class<X> exceptionType;
    @CheckForNull
    @LazyInit
    F fallback;

    static <V extends org.rascalmpl.org.rascalmpl.java.lang.Object, X extends org.rascalmpl.org.rascalmpl.java.lang.Throwable> ListenableFuture<V> create(ListenableFuture<? extends V> input, Class<X> exceptionType, Function<? super X, ? extends V> fallback, Executor executor) {
        CatchingFuture<? extends V, ? super X> future = new CatchingFuture<V, X>(input, exceptionType, fallback);
        input.addListener(future, MoreExecutors.rejectionPropagatingExecutor(executor, future));
        return future;
    }

    static <X extends org.rascalmpl.org.rascalmpl.java.lang.Throwable, V extends org.rascalmpl.org.rascalmpl.java.lang.Object> ListenableFuture<V> create(ListenableFuture<? extends V> input, Class<X> exceptionType, AsyncFunction<? super X, ? extends V> fallback, Executor executor) {
        AsyncCatchingFuture<? extends V, ? super X> future = new AsyncCatchingFuture<V, X>(input, exceptionType, fallback);
        input.addListener(future, MoreExecutors.rejectionPropagatingExecutor(executor, future));
        return future;
    }

    AbstractCatchingFuture(ListenableFuture<? extends V> inputFuture, Class<X> exceptionType, F fallback) {
        this.inputFuture = Preconditions.checkNotNull(inputFuture);
        this.exceptionType = Preconditions.checkNotNull(exceptionType);
        this.fallback = Preconditions.checkNotNull(fallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        T fallbackResult;
        F localFallback;
        Class<X> localExceptionType;
        ListenableFuture<? extends V> localInputFuture = this.inputFuture;
        if (localInputFuture == null | (localExceptionType = this.exceptionType) == null | (localFallback = this.fallback) == null || this.isCancelled()) {
            return;
        }
        this.inputFuture = null;
        org.rascalmpl.org.rascalmpl.java.lang.Object sourceResult = null;
        Throwable throwable = null;
        try {
            if (localInputFuture instanceof InternalFutureFailureAccess) {
                throwable = InternalFutures.tryInternalFastPathGetFailure((InternalFutureFailureAccess)((Object)localInputFuture));
            }
            if (throwable == null) {
                sourceResult = (org.rascalmpl.org.rascalmpl.java.lang.Object)Futures.getDone(localInputFuture);
            }
        }
        catch (ExecutionException e) {
            throwable = e.getCause();
            if (throwable == null) {
                throwable = new NullPointerException(new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.Future type ").append((org.rascalmpl.org.rascalmpl.java.lang.Object)localInputFuture.getClass()).append((String)"org.rascalmpl.org.rascalmpl. threw ").append((org.rascalmpl.org.rascalmpl.java.lang.Object)e.getClass()).append((String)"org.rascalmpl.org.rascalmpl. without a cause").toString());
            }
        }
        catch (org.rascalmpl.org.rascalmpl.java.lang.Throwable t2) {
            throwable = t2;
        }
        if (throwable == null) {
            this.set(NullnessCasts.uncheckedCastNullableTToT(sourceResult));
            return;
        }
        if (!Platform.isInstanceOfThrowableClass((org.rascalmpl.org.rascalmpl.java.lang.Throwable)throwable, localExceptionType)) {
            this.setFuture(localInputFuture);
            return;
        }
        org.rascalmpl.org.rascalmpl.java.lang.Throwable castThrowable = throwable;
        try {
            fallbackResult = this.doFallback(localFallback, castThrowable);
        }
        catch (org.rascalmpl.org.rascalmpl.java.lang.Throwable t3) {
            Platform.restoreInterruptIfIsInterruptedException(t3);
            this.setException(t3);
            return;
        }
        finally {
            this.exceptionType = null;
            this.fallback = null;
        }
        this.setResult(fallbackResult);
    }

    @Override
    @CheckForNull
    protected String pendingToString() {
        ListenableFuture<? extends V> localInputFuture = this.inputFuture;
        Class<X> localExceptionType = this.exceptionType;
        F localFallback = this.fallback;
        String superString = super.pendingToString();
        java.lang.String resultString = "org.rascalmpl.org.rascalmpl.";
        if (localInputFuture != null) {
            resultString = new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.inputFuture=[").append(localInputFuture).append((String)"org.rascalmpl.org.rascalmpl.], ").toString();
        }
        if (localExceptionType != null && localFallback != null) {
            return new StringBuilder().append((String)resultString).append((String)"org.rascalmpl.org.rascalmpl.exceptionType=[").append(localExceptionType).append((String)"org.rascalmpl.org.rascalmpl.], fallback=[").append(localFallback).append((String)"org.rascalmpl.org.rascalmpl.]").toString();
        }
        if (superString != null) {
            return new StringBuilder().append((String)resultString).append(superString).toString();
        }
        return null;
    }

    @ParametricNullness
    @ForOverride
    abstract T doFallback(F var1, X var2) throws Exception;

    @ForOverride
    abstract void setResult(@ParametricNullness T var1);

    @Override
    protected final void afterDone() {
        this.maybePropagateCancellationTo(this.inputFuture);
        this.inputFuture = null;
        this.exceptionType = null;
        this.fallback = null;
    }

    private static final class CatchingFuture<V extends @Nullable org.rascalmpl.org.rascalmpl.java.lang.Object, X extends org.rascalmpl.org.rascalmpl.java.lang.Throwable>
    extends AbstractCatchingFuture<V, X, Function<? super X, ? extends V>, V> {
        CatchingFuture(ListenableFuture<? extends V> input, Class<X> exceptionType, Function<? super X, ? extends V> fallback) {
            super(input, exceptionType, fallback);
        }

        @Override
        @ParametricNullness
        V doFallback(Function<? super X, ? extends V> fallback, X cause) throws Exception {
            return fallback.apply(cause);
        }

        @Override
        void setResult(@ParametricNullness V result) {
            this.set(result);
        }
    }

    private static final class AsyncCatchingFuture<V extends @Nullable org.rascalmpl.org.rascalmpl.java.lang.Object, X extends org.rascalmpl.org.rascalmpl.java.lang.Throwable>
    extends AbstractCatchingFuture<V, X, AsyncFunction<? super X, ? extends V>, ListenableFuture<? extends V>> {
        AsyncCatchingFuture(ListenableFuture<? extends V> input, Class<X> exceptionType, AsyncFunction<? super X, ? extends V> fallback) {
            super(input, exceptionType, fallback);
        }

        @Override
        ListenableFuture<? extends V> doFallback(AsyncFunction<? super X, ? extends V> fallback, X cause) throws Exception {
            ListenableFuture<? extends V> replacement = fallback.apply(cause);
            Preconditions.checkNotNull(replacement, (String)"org.rascalmpl.org.rascalmpl.AsyncFunction.apply returned null instead of a Future. Did you mean to return immediateFuture(null)? %s", fallback);
            return replacement;
        }

        @Override
        void setResult(ListenableFuture<? extends V> result) {
            this.setFuture(result);
        }
    }
}

