/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.AbstractService;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.Futures;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.Internal;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.LazyLogger;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.MoreExecutors;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.Platform;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.Service;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.concurrent.GuardedBy;
import org.rascalmpl.org.rascalmpl.java.lang.Class;
import org.rascalmpl.org.rascalmpl.java.lang.Exception;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.Runnable;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.Thread;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.lang.Void;
import org.rascalmpl.org.rascalmpl.java.time.Duration;
import org.rascalmpl.org.rascalmpl.java.util.Objects;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.Callable;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.Executor;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.Executors;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.Future;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.ScheduledExecutorService;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.ScheduledFuture;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.ThreadFactory;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.TimeoutException;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.locks.ReentrantLock;
import org.rascalmpl.org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
@J2ktIncompatible
public abstract class AbstractScheduledService
extends Object
implements Service {
    private static final LazyLogger logger = new LazyLogger((Class<?>)AbstractScheduledService.class);
    private final AbstractService delegate = new ServiceDelegate();

    protected AbstractScheduledService() {
    }

    protected abstract void runOneIteration() throws Exception;

    protected void startUp() throws Exception {
    }

    protected void shutDown() throws Exception {
    }

    protected abstract Scheduler scheduler();

    protected ScheduledExecutorService executor() {
        class ThreadFactoryImpl
        extends Object
        implements ThreadFactory {
            ThreadFactoryImpl() {
            }

            public Thread newThread(Runnable runnable) {
                return MoreExecutors.newThread(AbstractScheduledService.this.serviceName(), runnable);
            }
        }
        final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl());
        this.addListener(new Service.Listener(){

            @Override
            public void terminated(Service.State from) {
                executor.shutdown();
            }

            @Override
            public void failed(Service.State from, Throwable failure) {
                executor.shutdown();
            }
        }, MoreExecutors.directExecutor());
        return executor;
    }

    protected String serviceName() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        return new StringBuilder().append(this.serviceName()).append((String)"org.rascalmpl.org.rascalmpl. [").append((Object)this.state()).append((String)"org.rascalmpl.org.rascalmpl.]").toString();
    }

    @Override
    public final boolean isRunning() {
        return this.delegate.isRunning();
    }

    @Override
    public final Service.State state() {
        return this.delegate.state();
    }

    @Override
    public final void addListener(Service.Listener listener, Executor executor) {
        this.delegate.addListener(listener, executor);
    }

    @Override
    public final Throwable failureCause() {
        return this.delegate.failureCause();
    }

    @Override
    @CanIgnoreReturnValue
    public final Service startAsync() {
        this.delegate.startAsync();
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public final Service stopAsync() {
        this.delegate.stopAsync();
        return this;
    }

    @Override
    public final void awaitRunning() {
        this.delegate.awaitRunning();
    }

    @Override
    public final void awaitRunning(Duration timeout) throws TimeoutException {
        Service.super.awaitRunning(timeout);
    }

    @Override
    public final void awaitRunning(long timeout, TimeUnit unit) throws TimeoutException {
        this.delegate.awaitRunning(timeout, unit);
    }

    @Override
    public final void awaitTerminated() {
        this.delegate.awaitTerminated();
    }

    @Override
    public final void awaitTerminated(Duration timeout) throws TimeoutException {
        Service.super.awaitTerminated(timeout);
    }

    @Override
    public final void awaitTerminated(long timeout, TimeUnit unit) throws TimeoutException {
        this.delegate.awaitTerminated(timeout, unit);
    }

    public static abstract class CustomScheduler
    extends Scheduler {
        @Override
        final Cancellable schedule(AbstractService service, ScheduledExecutorService executor, Runnable runnable) {
            return new ReschedulableCallable(service, executor, runnable).reschedule();
        }

        protected abstract Schedule getNextSchedule() throws Exception;

        protected static final class Schedule
        extends Object {
            private final long delay;
            private final TimeUnit unit;

            public Schedule(long delay, TimeUnit unit) {
                this.delay = delay;
                this.unit = Preconditions.checkNotNull(unit);
            }

            public Schedule(Duration delay) {
                this(Internal.toNanosSaturated(delay), TimeUnit.NANOSECONDS);
            }
        }

        private static final class SupplantableFuture
        extends Object
        implements Cancellable {
            private final ReentrantLock lock;
            @GuardedBy(value="org.rascalmpl.org.rascalmpl.lock")
            private Future<@Nullable Void> currentFuture;

            SupplantableFuture(ReentrantLock lock, Future<@Nullable Void> currentFuture) {
                this.lock = lock;
                this.currentFuture = currentFuture;
            }

            @Override
            public void cancel(boolean mayInterruptIfRunning) {
                this.lock.lock();
                try {
                    this.currentFuture.cancel(mayInterruptIfRunning);
                }
                finally {
                    this.lock.unlock();
                }
            }

            @Override
            public boolean isCancelled() {
                this.lock.lock();
                try {
                    boolean bl = this.currentFuture.isCancelled();
                    return bl;
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        private final class ReschedulableCallable
        extends Object
        implements Callable<Void> {
            private final Runnable wrappedRunnable;
            private final ScheduledExecutorService executor;
            private final AbstractService service;
            private final ReentrantLock lock = new ReentrantLock();
            @CheckForNull
            @GuardedBy(value="org.rascalmpl.org.rascalmpl.lock")
            private SupplantableFuture cancellationDelegate;

            ReschedulableCallable(AbstractService service, ScheduledExecutorService executor, Runnable runnable) {
                this.wrappedRunnable = runnable;
                this.executor = executor;
                this.service = service;
            }

            @CheckForNull
            public Void call() throws Exception {
                this.wrappedRunnable.run();
                this.reschedule();
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CanIgnoreReturnValue
            public Cancellable reschedule() {
                Cancellable toReturn;
                Schedule schedule;
                try {
                    schedule = CustomScheduler.this.getNextSchedule();
                }
                catch (Throwable t2) {
                    Platform.restoreInterruptIfIsInterruptedException(t2);
                    this.service.notifyFailed(t2);
                    return new FutureAsCancellable(Futures.immediateCancelledFuture());
                }
                Throwable scheduleFailure = null;
                this.lock.lock();
                try {
                    toReturn = this.initializeOrUpdateCancellationDelegate(schedule);
                }
                catch (Throwable e) {
                    scheduleFailure = e;
                    toReturn = new FutureAsCancellable(Futures.immediateCancelledFuture());
                }
                finally {
                    this.lock.unlock();
                }
                if (scheduleFailure != null) {
                    this.service.notifyFailed(scheduleFailure);
                }
                return toReturn;
            }

            @GuardedBy(value="org.rascalmpl.org.rascalmpl.lock")
            private Cancellable initializeOrUpdateCancellationDelegate(Schedule schedule) {
                if (this.cancellationDelegate == null) {
                    this.cancellationDelegate = new SupplantableFuture(this.lock, (Future<Void>)this.submitToExecutor(schedule));
                    return this.cancellationDelegate;
                }
                if (!this.cancellationDelegate.currentFuture.isCancelled()) {
                    this.cancellationDelegate.currentFuture = this.submitToExecutor(schedule);
                }
                return this.cancellationDelegate;
            }

            private ScheduledFuture<@Nullable Void> submitToExecutor(Schedule schedule) {
                return this.executor.schedule((Callable)this, schedule.delay, schedule.unit);
            }
        }
    }

    private static final class FutureAsCancellable
    extends Object
    implements Cancellable {
        private final Future<?> delegate;

        FutureAsCancellable(Future<?> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void cancel(boolean mayInterruptIfRunning) {
            this.delegate.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }
    }

    static interface Cancellable {
        public void cancel(boolean var1);

        public boolean isCancelled();
    }

    private final class ServiceDelegate
    extends AbstractService {
        @CheckForNull
        private volatile Cancellable runningTask;
        @CheckForNull
        private volatile ScheduledExecutorService executorService;
        private final ReentrantLock lock = new ReentrantLock();
        private final Runnable task = new Task();

        private ServiceDelegate() {
        }

        /*
         * Exception decompiling
         */
        @Override
        protected final void doStart() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.org.rascalmpl.java.lang.invoke.MethodType, got ()Lorg/rascalmpl/org/rascalmpl/java/lang/Object;
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
             *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        @Override
        protected final void doStop() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.org.rascalmpl.java.lang.invoke.MethodType, got ()V
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
             *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public String toString() {
            return AbstractScheduledService.this.toString();
        }

        private /* synthetic */ void lambda$doStop$2() {
            try {
                this.lock.lock();
                try {
                    if (this.state() != Service.State.STOPPING) {
                        return;
                    }
                    AbstractScheduledService.this.shutDown();
                }
                finally {
                    this.lock.unlock();
                }
                this.notifyStopped();
            }
            catch (Throwable t2) {
                Platform.restoreInterruptIfIsInterruptedException(t2);
                this.notifyFailed(t2);
            }
        }

        private /* synthetic */ void lambda$doStart$1() {
            this.lock.lock();
            try {
                AbstractScheduledService.this.startUp();
                Objects.requireNonNull((Object)this.executorService);
                this.runningTask = AbstractScheduledService.this.scheduler().schedule(AbstractScheduledService.this.delegate, this.executorService, this.task);
                this.notifyStarted();
            }
            catch (Throwable t2) {
                Platform.restoreInterruptIfIsInterruptedException(t2);
                this.notifyFailed(t2);
                if (this.runningTask != null) {
                    this.runningTask.cancel(false);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        private /* synthetic */ String lambda$doStart$0() {
            return new StringBuilder().append(AbstractScheduledService.this.serviceName()).append((String)"org.rascalmpl.org.rascalmpl. ").append((Object)this.state()).toString();
        }

        class Task
        extends Object
        implements Runnable {
            Task() {
            }

            public void run() {
                ServiceDelegate.this.lock.lock();
                try {
                    if (((Cancellable)Objects.requireNonNull((Object)ServiceDelegate.this.runningTask)).isCancelled()) {
                        return;
                    }
                    AbstractScheduledService.this.runOneIteration();
                }
                catch (Throwable t2) {
                    Platform.restoreInterruptIfIsInterruptedException(t2);
                    try {
                        AbstractScheduledService.this.shutDown();
                    }
                    catch (Exception ignored) {
                        Platform.restoreInterruptIfIsInterruptedException((Throwable)((java.lang.Object)ignored));
                        logger.get().log(Level.WARNING, (String)"org.rascalmpl.org.rascalmpl.Error while attempting to shut down the service after failure.", (Throwable)((java.lang.Object)ignored));
                    }
                    ServiceDelegate.this.notifyFailed(t2);
                    ((Cancellable)Objects.requireNonNull((Object)ServiceDelegate.this.runningTask)).cancel(false);
                }
                finally {
                    ServiceDelegate.this.lock.unlock();
                }
            }
        }
    }

    public static abstract class Scheduler
    extends Object {
        public static Scheduler newFixedDelaySchedule(Duration initialDelay, Duration delay) {
            return Scheduler.newFixedDelaySchedule(Internal.toNanosSaturated(initialDelay), Internal.toNanosSaturated(delay), TimeUnit.NANOSECONDS);
        }

        public static Scheduler newFixedDelaySchedule(final long initialDelay, final long delay, final TimeUnit unit) {
            Preconditions.checkNotNull(unit);
            Preconditions.checkArgument(delay > 0L, (String)"org.rascalmpl.org.rascalmpl.delay must be > 0, found %s", delay);
            return new Scheduler(){

                @Override
                public Cancellable schedule(AbstractService service, ScheduledExecutorService executor, Runnable task) {
                    return new FutureAsCancellable((Future<?>)executor.scheduleWithFixedDelay(task, initialDelay, delay, unit));
                }
            };
        }

        public static Scheduler newFixedRateSchedule(Duration initialDelay, Duration period) {
            return Scheduler.newFixedRateSchedule(Internal.toNanosSaturated(initialDelay), Internal.toNanosSaturated(period), TimeUnit.NANOSECONDS);
        }

        public static Scheduler newFixedRateSchedule(final long initialDelay, final long period, final TimeUnit unit) {
            Preconditions.checkNotNull(unit);
            Preconditions.checkArgument(period > 0L, (String)"org.rascalmpl.org.rascalmpl.period must be > 0, found %s", period);
            return new Scheduler(){

                @Override
                public Cancellable schedule(AbstractService service, ScheduledExecutorService executor, Runnable task) {
                    return new FutureAsCancellable((Future<?>)executor.scheduleAtFixedRate(task, initialDelay, period, unit));
                }
            };
        }

        abstract Cancellable schedule(AbstractService var1, ScheduledExecutorService var2, Runnable var3);

        private Scheduler() {
        }
    }
}

