/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.VisibleForTesting;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Functions;
import org.rascalmpl.org.rascalmpl.com.google.common.base.MoreObjects;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.FluentIterable;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableList;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Lists;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.AsyncCallable;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.AsyncFunction;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.FluentFuture;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.FutureCallback;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.Futures;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.LazyLogger;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ListenableFuture;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.MoreExecutors;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ParametricNullness;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.Platform;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.TrustedListenableFutureTask;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.DoNotMock;
import org.rascalmpl.org.rascalmpl.com.google.j2objc.annotations.RetainedWith;
import org.rascalmpl.org.rascalmpl.java.io.Closeable;
import org.rascalmpl.org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.org.rascalmpl.java.lang.AutoCloseable;
import org.rascalmpl.org.rascalmpl.java.lang.Class;
import org.rascalmpl.org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.org.rascalmpl.java.lang.Enum;
import org.rascalmpl.org.rascalmpl.java.lang.Exception;
import org.rascalmpl.org.rascalmpl.java.lang.FunctionalInterface;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.Runnable;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.util.IdentityHashMap;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.Callable;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.CountDownLatch;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.ExecutionException;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.Executor;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.atomic.AtomicReference;
import org.rascalmpl.org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@DoNotMock(value="org.rascalmpl.org.rascalmpl.Use ClosingFuture.from(Futures.immediate*Future)")
@ElementTypesAreNonnullByDefault
@J2ktIncompatible
public final class ClosingFuture<V extends @Nullable Object>
extends Object {
    private static final LazyLogger logger = new LazyLogger((Class<?>)ClosingFuture.class);
    private final AtomicReference<State> state = new AtomicReference((Object)State.OPEN);
    private final CloseableList closeables = new CloseableList();
    private final FluentFuture<V> future;

    public static <V extends Object> ClosingFuture<V> submit(ClosingCallable<V> callable, Executor executor) {
        return new ClosingFuture<V>(callable, executor);
    }

    public static <V extends Object> ClosingFuture<V> submitAsync(AsyncClosingCallable<V> callable, Executor executor) {
        return new ClosingFuture<V>(callable, executor);
    }

    public static <V extends Object> ClosingFuture<V> from(ListenableFuture<V> future) {
        return new ClosingFuture<V>(future);
    }

    @Deprecated
    public static <C extends Object> ClosingFuture<C> eventuallyClosing(ListenableFuture<C> future, final Executor closingExecutor) {
        Preconditions.checkNotNull(closingExecutor);
        final ClosingFuture<C> closingFuture = new ClosingFuture<C>(Futures.nonCancellationPropagating(future));
        Futures.addCallback(future, new FutureCallback<AutoCloseable>(){

            @Override
            public void onSuccess(@CheckForNull AutoCloseable result) {
                closingFuture.closeables.closer.eventuallyClose(result, closingExecutor);
            }

            @Override
            public void onFailure(Throwable t2) {
            }
        }, MoreExecutors.directExecutor());
        return closingFuture;
    }

    public static Combiner whenAllComplete(Iterable<? extends ClosingFuture<?>> futures) {
        return new Combiner(false, futures);
    }

    public static Combiner whenAllComplete(ClosingFuture<?> future1, ClosingFuture<?> ... moreFutures) {
        return ClosingFuture.whenAllComplete(Lists.asList(future1, (Object[])moreFutures));
    }

    public static Combiner whenAllSucceed(Iterable<? extends ClosingFuture<?>> futures) {
        return new Combiner(true, futures);
    }

    public static <V1 extends Object, V2 extends Object> Combiner2<V1, V2> whenAllSucceed(ClosingFuture<V1> future1, ClosingFuture<V2> future2) {
        return new Combiner2(future1, future2);
    }

    public static <V1 extends Object, V2 extends Object, V3 extends Object> Combiner3<V1, V2, V3> whenAllSucceed(ClosingFuture<V1> future1, ClosingFuture<V2> future2, ClosingFuture<V3> future3) {
        return new Combiner3(future1, future2, future3);
    }

    public static <V1 extends Object, V2 extends Object, V3 extends Object, V4 extends Object> Combiner4<V1, V2, V3, V4> whenAllSucceed(ClosingFuture<V1> future1, ClosingFuture<V2> future2, ClosingFuture<V3> future3, ClosingFuture<V4> future4) {
        return new Combiner4(future1, future2, future3, future4);
    }

    public static <V1 extends Object, V2 extends Object, V3 extends Object, V4 extends Object, V5 extends Object> Combiner5<V1, V2, V3, V4, V5> whenAllSucceed(ClosingFuture<V1> future1, ClosingFuture<V2> future2, ClosingFuture<V3> future3, ClosingFuture<V4> future4, ClosingFuture<V5> future5) {
        return new Combiner5(future1, future2, future3, future4, future5);
    }

    public static Combiner whenAllSucceed(ClosingFuture<?> future1, ClosingFuture<?> future2, ClosingFuture<?> future3, ClosingFuture<?> future4, ClosingFuture<?> future5, ClosingFuture<?> future6, ClosingFuture<?> ... moreFutures) {
        return ClosingFuture.whenAllSucceed(FluentIterable.of(future1, (Object[])new ClosingFuture[]{future2, future3, future4, future5, future6}).append(moreFutures));
    }

    private ClosingFuture(ListenableFuture<V> future) {
        this.future = FluentFuture.from(future);
    }

    private ClosingFuture(final ClosingCallable<V> callable, Executor executor) {
        Preconditions.checkNotNull(callable);
        TrustedListenableFutureTask task = TrustedListenableFutureTask.create(new Callable<V>(){

            @ParametricNullness
            public V call() throws Exception {
                return callable.call(ClosingFuture.this.closeables.closer);
            }

            public String toString() {
                return callable.toString();
            }
        });
        executor.execute(task);
        this.future = task;
    }

    private ClosingFuture(final AsyncClosingCallable<V> callable, Executor executor) {
        Preconditions.checkNotNull(callable);
        TrustedListenableFutureTask task = TrustedListenableFutureTask.create(new AsyncCallable<V>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ListenableFuture<V> call() throws Exception {
                CloseableList newCloseables = new CloseableList();
                try {
                    ClosingFuture closingFuture = callable.call(newCloseables.closer);
                    closingFuture.becomeSubsumedInto(ClosingFuture.this.closeables);
                    FluentFuture fluentFuture = closingFuture.future;
                    return fluentFuture;
                }
                finally {
                    ClosingFuture.this.closeables.add((AutoCloseable)newCloseables, MoreExecutors.directExecutor());
                }
            }

            public String toString() {
                return callable.toString();
            }
        });
        executor.execute(task);
        this.future = task;
    }

    public ListenableFuture<?> statusFuture() {
        return Futures.nonCancellationPropagating(this.future.transform(Functions.constant(null), MoreExecutors.directExecutor()));
    }

    public <U extends Object> ClosingFuture<U> transform(final ClosingFunction<? super V, U> function, Executor executor) {
        Preconditions.checkNotNull(function);
        AsyncFunction applyFunction = new AsyncFunction<V, U>(){

            @Override
            public ListenableFuture<U> apply(V input) throws Exception {
                return ClosingFuture.this.closeables.applyClosingFunction(function, input);
            }

            public String toString() {
                return function.toString();
            }
        };
        return this.derive(this.future.transformAsync(applyFunction, executor));
    }

    public <U extends Object> ClosingFuture<U> transformAsync(final AsyncClosingFunction<? super V, U> function, Executor executor) {
        Preconditions.checkNotNull(function);
        AsyncFunction applyFunction = new AsyncFunction<V, U>(){

            @Override
            public ListenableFuture<U> apply(V input) throws Exception {
                return ClosingFuture.this.closeables.applyAsyncClosingFunction(function, input);
            }

            public String toString() {
                return function.toString();
            }
        };
        return this.derive(this.future.transformAsync(applyFunction, executor));
    }

    public static <V extends Object, U extends Object> AsyncClosingFunction<V, U> withoutCloser(final AsyncFunction<V, U> function) {
        Preconditions.checkNotNull(function);
        return new AsyncClosingFunction<V, U>(){

            @Override
            public ClosingFuture<U> apply(DeferredCloser closer, V input) throws Exception {
                return ClosingFuture.from(function.apply(input));
            }
        };
    }

    public <X extends Throwable> ClosingFuture<V> catching(Class<X> exceptionType, ClosingFunction<? super X, ? extends V> fallback, Executor executor) {
        return this.catchingMoreGeneric(exceptionType, fallback, executor);
    }

    private <X extends Throwable, W extends V> ClosingFuture<V> catchingMoreGeneric(Class<X> exceptionType, final ClosingFunction<? super X, W> fallback, Executor executor) {
        Preconditions.checkNotNull(fallback);
        AsyncFunction applyFallback = new AsyncFunction<X, W>(){

            @Override
            public ListenableFuture<W> apply(X exception) throws Exception {
                return ClosingFuture.this.closeables.applyClosingFunction(fallback, exception);
            }

            public String toString() {
                return fallback.toString();
            }
        };
        return this.derive(this.future.catchingAsync(exceptionType, applyFallback, executor));
    }

    public <X extends Throwable> ClosingFuture<V> catchingAsync(Class<X> exceptionType, AsyncClosingFunction<? super X, ? extends V> fallback, Executor executor) {
        return this.catchingAsyncMoreGeneric(exceptionType, fallback, executor);
    }

    private <X extends Throwable, W extends V> ClosingFuture<V> catchingAsyncMoreGeneric(Class<X> exceptionType, final AsyncClosingFunction<? super X, W> fallback, Executor executor) {
        Preconditions.checkNotNull(fallback);
        AsyncFunction asyncFunction = new AsyncFunction<X, W>(){

            @Override
            public ListenableFuture<W> apply(X exception) throws Exception {
                return ClosingFuture.this.closeables.applyAsyncClosingFunction(fallback, exception);
            }

            public String toString() {
                return fallback.toString();
            }
        };
        return this.derive(this.future.catchingAsync(exceptionType, asyncFunction, executor));
    }

    public FluentFuture<V> finishToFuture() {
        if (this.compareAndUpdateState(State.OPEN, State.WILL_CLOSE)) {
            logger.get().log(Level.FINER, (String)"org.rascalmpl.org.rascalmpl.will close {0}", (Object)this);
            this.future.addListener(new Runnable(){

                public void run() {
                    ClosingFuture.this.checkAndUpdateState(State.WILL_CLOSE, State.CLOSING);
                    ClosingFuture.this.close();
                    ClosingFuture.this.checkAndUpdateState(State.CLOSING, State.CLOSED);
                }
            }, MoreExecutors.directExecutor());
        } else {
            switch ((State)this.state.get()) {
                case SUBSUMED: {
                    throw new IllegalStateException((String)"org.rascalmpl.org.rascalmpl.Cannot call finishToFuture() after deriving another step");
                }
                case WILL_CREATE_VALUE_AND_CLOSER: {
                    throw new IllegalStateException((String)"org.rascalmpl.org.rascalmpl.Cannot call finishToFuture() after calling finishToValueAndCloser()");
                }
                case WILL_CLOSE: 
                case CLOSING: 
                case CLOSED: {
                    throw new IllegalStateException((String)"org.rascalmpl.org.rascalmpl.Cannot call finishToFuture() twice");
                }
                case OPEN: {
                    throw new AssertionError();
                }
            }
        }
        return this.future;
    }

    public void finishToValueAndCloser(final ValueAndCloserConsumer<? super V> consumer, Executor executor) {
        Preconditions.checkNotNull(consumer);
        if (!this.compareAndUpdateState(State.OPEN, State.WILL_CREATE_VALUE_AND_CLOSER)) {
            switch ((State)this.state.get()) {
                case SUBSUMED: {
                    throw new IllegalStateException((String)"org.rascalmpl.org.rascalmpl.Cannot call finishToValueAndCloser() after deriving another step");
                }
                case WILL_CLOSE: 
                case CLOSING: 
                case CLOSED: {
                    throw new IllegalStateException((String)"org.rascalmpl.org.rascalmpl.Cannot call finishToValueAndCloser() after calling finishToFuture()");
                }
                case WILL_CREATE_VALUE_AND_CLOSER: {
                    throw new IllegalStateException((String)"org.rascalmpl.org.rascalmpl.Cannot call finishToValueAndCloser() twice");
                }
            }
            throw new AssertionError(this.state);
        }
        this.future.addListener(new Runnable(){

            public void run() {
                ClosingFuture.provideValueAndCloser(consumer, ClosingFuture.this);
            }
        }, executor);
    }

    private static <C extends Object, V extends C> void provideValueAndCloser(ValueAndCloserConsumer<C> consumer, ClosingFuture<V> closingFuture) {
        consumer.accept(new ValueAndCloser<V>(closingFuture));
    }

    @CanIgnoreReturnValue
    public boolean cancel(boolean mayInterruptIfRunning) {
        logger.get().log(Level.FINER, (String)"org.rascalmpl.org.rascalmpl.cancelling {0}", (Object)this);
        boolean cancelled = this.future.cancel(mayInterruptIfRunning);
        if (cancelled) {
            this.close();
        }
        return cancelled;
    }

    private void close() {
        logger.get().log(Level.FINER, (String)"org.rascalmpl.org.rascalmpl.closing {0}", (Object)this);
        this.closeables.close();
    }

    private <U extends Object> ClosingFuture<U> derive(FluentFuture<U> future) {
        ClosingFuture<U> derived = new ClosingFuture<U>(future);
        this.becomeSubsumedInto(derived.closeables);
        return derived;
    }

    private void becomeSubsumedInto(CloseableList otherCloseables) {
        this.checkAndUpdateState(State.OPEN, State.SUBSUMED);
        otherCloseables.add((AutoCloseable)this.closeables, MoreExecutors.directExecutor());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add((String)"org.rascalmpl.org.rascalmpl.state", this.state.get()).addValue(this.future).toString();
    }

    protected void finalize() {
        if (((State)this.state.get()).equals((Object)State.OPEN)) {
            logger.get().log(Level.SEVERE, (String)"org.rascalmpl.org.rascalmpl.Uh oh! An open ClosingFuture has leaked and will close: {0}", (Object)this);
            FluentFuture<V> fluentFuture = this.finishToFuture();
        }
    }

    /*
     * Exception decompiling
     */
    private static void closeQuietly(@CheckForNull AutoCloseable closeable, Executor executor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.org.rascalmpl.java.lang.invoke.MethodType, got ()V
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkAndUpdateState(State oldState, State newState) {
        Preconditions.checkState(this.compareAndUpdateState(oldState, newState), (String)"org.rascalmpl.org.rascalmpl.Expected state to be %s, but it was %s", (Object)oldState, (Object)newState);
    }

    private boolean compareAndUpdateState(State oldState, State newState) {
        return this.state.compareAndSet((Object)oldState, (Object)newState);
    }

    @VisibleForTesting
    CountDownLatch whenClosedCountDown() {
        return this.closeables.whenClosedCountDown();
    }

    private static /* synthetic */ void lambda$closeQuietly$0(AutoCloseable closeable) {
        try {
            closeable.close();
        }
        catch (Exception e) {
            Platform.restoreInterruptIfIsInterruptedException((Throwable)((java.lang.Object)e));
            logger.get().log(Level.WARNING, (String)"org.rascalmpl.org.rascalmpl.thrown by close()", (Throwable)((java.lang.Object)e));
        }
    }

    static final class State
    extends Enum<State> {
        public static final /* enum */ State OPEN = new State((String)"org.rascalmpl.org.rascalmpl.OPEN", 0);
        public static final /* enum */ State SUBSUMED = new State((String)"org.rascalmpl.org.rascalmpl.SUBSUMED", 1);
        public static final /* enum */ State WILL_CLOSE = new State((String)"org.rascalmpl.org.rascalmpl.WILL_CLOSE", 2);
        public static final /* enum */ State CLOSING = new State((String)"org.rascalmpl.org.rascalmpl.CLOSING", 3);
        public static final /* enum */ State CLOSED = new State((String)"org.rascalmpl.org.rascalmpl.CLOSED", 4);
        public static final /* enum */ State WILL_CREATE_VALUE_AND_CLOSER = new State((String)"org.rascalmpl.org.rascalmpl.WILL_CREATE_VALUE_AND_CLOSER", 5);
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String name) {
            return (State)Enum.valueOf(State.class, (String)name);
        }

        private State() {
            super((String)string, n);
        }

        static {
            $VALUES = new State[]{OPEN, SUBSUMED, WILL_CLOSE, CLOSING, CLOSED, WILL_CREATE_VALUE_AND_CLOSER};
        }
    }

    private static final class CloseableList
    extends IdentityHashMap<AutoCloseable, Executor>
    implements Closeable {
        private final DeferredCloser closer = new DeferredCloser(this);
        private volatile boolean closed;
        @CheckForNull
        private volatile CountDownLatch whenClosed;

        private CloseableList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <V extends Object, U extends Object> ListenableFuture<U> applyClosingFunction(ClosingFunction<? super V, U> transformation, @ParametricNullness V input) throws Exception {
            CloseableList newCloseables = new CloseableList();
            try {
                ListenableFuture<U> listenableFuture = Futures.immediateFuture(transformation.apply(newCloseables.closer, input));
                return listenableFuture;
            }
            finally {
                this.add((AutoCloseable)newCloseables, MoreExecutors.directExecutor());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <V extends Object, U extends Object> FluentFuture<U> applyAsyncClosingFunction(AsyncClosingFunction<V, U> transformation, @ParametricNullness V input) throws Exception {
            CloseableList newCloseables = new CloseableList();
            try {
                ClosingFuture<U> closingFuture = transformation.apply(newCloseables.closer, input);
                ((ClosingFuture)closingFuture).becomeSubsumedInto(newCloseables);
                FluentFuture fluentFuture = ((ClosingFuture)closingFuture).future;
                return fluentFuture;
            }
            finally {
                this.add((AutoCloseable)newCloseables, MoreExecutors.directExecutor());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (this.closed) {
                return;
            }
            CloseableList closeableList = this;
            synchronized (closeableList) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            for (Map.Entry entry : this.entrySet()) {
                ClosingFuture.closeQuietly((AutoCloseable)entry.getKey(), (Executor)entry.getValue());
            }
            this.clear();
            if (this.whenClosed != null) {
                this.whenClosed.countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(@CheckForNull AutoCloseable closeable, Executor executor) {
            Preconditions.checkNotNull(executor);
            if (closeable == null) {
                return;
            }
            CloseableList closeableList = this;
            synchronized (closeableList) {
                if (!this.closed) {
                    this.put((Object)closeable, (Object)executor);
                    return;
                }
            }
            ClosingFuture.closeQuietly(closeable, executor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CountDownLatch whenClosedCountDown() {
            if (this.closed) {
                return new CountDownLatch(0);
            }
            CloseableList closeableList = this;
            synchronized (closeableList) {
                if (this.closed) {
                    return new CountDownLatch(0);
                }
                Preconditions.checkState(this.whenClosed == null);
                this.whenClosed = new CountDownLatch(1);
                return this.whenClosed;
            }
        }
    }

    public static final class Combiner5<V1 extends @Nullable Object, V2 extends @Nullable Object, V3 extends @Nullable Object, V4 extends @Nullable Object, V5 extends @Nullable Object>
    extends Combiner {
        private final ClosingFuture<V1> future1;
        private final ClosingFuture<V2> future2;
        private final ClosingFuture<V3> future3;
        private final ClosingFuture<V4> future4;
        private final ClosingFuture<V5> future5;

        private Combiner5(ClosingFuture<V1> future1, ClosingFuture<V2> future2, ClosingFuture<V3> future3, ClosingFuture<V4> future4, ClosingFuture<V5> future5) {
            super(true, (Iterable)ImmutableList.of(future1, future2, future3, future4, future5));
            this.future1 = future1;
            this.future2 = future2;
            this.future3 = future3;
            this.future4 = future4;
            this.future5 = future5;
        }

        public <U extends Object> ClosingFuture<U> call(final ClosingFunction5<V1, V2, V3, V4, V5, U> function, Executor executor) {
            return this.call(new Combiner.CombiningCallable<U>(){

                @Override
                @ParametricNullness
                public U call(DeferredCloser closer, Peeker peeker) throws Exception {
                    return function.apply(closer, peeker.getDone(future1), peeker.getDone(future2), peeker.getDone(future3), peeker.getDone(future4), peeker.getDone(future5));
                }

                public String toString() {
                    return function.toString();
                }
            }, executor);
        }

        public <U extends Object> ClosingFuture<U> callAsync(final AsyncClosingFunction5<V1, V2, V3, V4, V5, U> function, Executor executor) {
            return this.callAsync(new Combiner.AsyncCombiningCallable<U>(){

                @Override
                public ClosingFuture<U> call(DeferredCloser closer, Peeker peeker) throws Exception {
                    return function.apply(closer, peeker.getDone(future1), peeker.getDone(future2), peeker.getDone(future3), peeker.getDone(future4), peeker.getDone(future5));
                }

                public String toString() {
                    return function.toString();
                }
            }, executor);
        }

        @FunctionalInterface
        public static interface AsyncClosingFunction5<V1 extends @Nullable Object, V2 extends @Nullable Object, V3 extends @Nullable Object, V4 extends @Nullable Object, V5 extends @Nullable Object, U extends @Nullable Object> {
            public ClosingFuture<U> apply(DeferredCloser var1, @ParametricNullness V1 var2, @ParametricNullness V2 var3, @ParametricNullness V3 var4, @ParametricNullness V4 var5, @ParametricNullness V5 var6) throws Exception;
        }

        @FunctionalInterface
        public static interface ClosingFunction5<V1 extends @Nullable Object, V2 extends @Nullable Object, V3 extends @Nullable Object, V4 extends @Nullable Object, V5 extends @Nullable Object, U extends @Nullable Object> {
            @ParametricNullness
            public U apply(DeferredCloser var1, @ParametricNullness V1 var2, @ParametricNullness V2 var3, @ParametricNullness V3 var4, @ParametricNullness V4 var5, @ParametricNullness V5 var6) throws Exception;
        }
    }

    public static final class Combiner4<V1 extends @Nullable Object, V2 extends @Nullable Object, V3 extends @Nullable Object, V4 extends @Nullable Object>
    extends Combiner {
        private final ClosingFuture<V1> future1;
        private final ClosingFuture<V2> future2;
        private final ClosingFuture<V3> future3;
        private final ClosingFuture<V4> future4;

        private Combiner4(ClosingFuture<V1> future1, ClosingFuture<V2> future2, ClosingFuture<V3> future3, ClosingFuture<V4> future4) {
            super(true, (Iterable)ImmutableList.of(future1, future2, future3, future4));
            this.future1 = future1;
            this.future2 = future2;
            this.future3 = future3;
            this.future4 = future4;
        }

        public <U extends Object> ClosingFuture<U> call(final ClosingFunction4<V1, V2, V3, V4, U> function, Executor executor) {
            return this.call(new Combiner.CombiningCallable<U>(){

                @Override
                @ParametricNullness
                public U call(DeferredCloser closer, Peeker peeker) throws Exception {
                    return function.apply(closer, peeker.getDone(future1), peeker.getDone(future2), peeker.getDone(future3), peeker.getDone(future4));
                }

                public String toString() {
                    return function.toString();
                }
            }, executor);
        }

        public <U extends Object> ClosingFuture<U> callAsync(final AsyncClosingFunction4<V1, V2, V3, V4, U> function, Executor executor) {
            return this.callAsync(new Combiner.AsyncCombiningCallable<U>(){

                @Override
                public ClosingFuture<U> call(DeferredCloser closer, Peeker peeker) throws Exception {
                    return function.apply(closer, peeker.getDone(future1), peeker.getDone(future2), peeker.getDone(future3), peeker.getDone(future4));
                }

                public String toString() {
                    return function.toString();
                }
            }, executor);
        }

        @FunctionalInterface
        public static interface AsyncClosingFunction4<V1 extends @Nullable Object, V2 extends @Nullable Object, V3 extends @Nullable Object, V4 extends @Nullable Object, U extends @Nullable Object> {
            public ClosingFuture<U> apply(DeferredCloser var1, @ParametricNullness V1 var2, @ParametricNullness V2 var3, @ParametricNullness V3 var4, @ParametricNullness V4 var5) throws Exception;
        }

        @FunctionalInterface
        public static interface ClosingFunction4<V1 extends @Nullable Object, V2 extends @Nullable Object, V3 extends @Nullable Object, V4 extends @Nullable Object, U extends @Nullable Object> {
            @ParametricNullness
            public U apply(DeferredCloser var1, @ParametricNullness V1 var2, @ParametricNullness V2 var3, @ParametricNullness V3 var4, @ParametricNullness V4 var5) throws Exception;
        }
    }

    public static final class Combiner3<V1 extends @Nullable Object, V2 extends @Nullable Object, V3 extends @Nullable Object>
    extends Combiner {
        private final ClosingFuture<V1> future1;
        private final ClosingFuture<V2> future2;
        private final ClosingFuture<V3> future3;

        private Combiner3(ClosingFuture<V1> future1, ClosingFuture<V2> future2, ClosingFuture<V3> future3) {
            super(true, (Iterable)ImmutableList.of(future1, future2, future3));
            this.future1 = future1;
            this.future2 = future2;
            this.future3 = future3;
        }

        public <U extends Object> ClosingFuture<U> call(final ClosingFunction3<V1, V2, V3, U> function, Executor executor) {
            return this.call(new Combiner.CombiningCallable<U>(){

                @Override
                @ParametricNullness
                public U call(DeferredCloser closer, Peeker peeker) throws Exception {
                    return function.apply(closer, peeker.getDone(future1), peeker.getDone(future2), peeker.getDone(future3));
                }

                public String toString() {
                    return function.toString();
                }
            }, executor);
        }

        public <U extends Object> ClosingFuture<U> callAsync(final AsyncClosingFunction3<V1, V2, V3, U> function, Executor executor) {
            return this.callAsync(new Combiner.AsyncCombiningCallable<U>(){

                @Override
                public ClosingFuture<U> call(DeferredCloser closer, Peeker peeker) throws Exception {
                    return function.apply(closer, peeker.getDone(future1), peeker.getDone(future2), peeker.getDone(future3));
                }

                public String toString() {
                    return function.toString();
                }
            }, executor);
        }

        @FunctionalInterface
        public static interface AsyncClosingFunction3<V1 extends @Nullable Object, V2 extends @Nullable Object, V3 extends @Nullable Object, U extends @Nullable Object> {
            public ClosingFuture<U> apply(DeferredCloser var1, @ParametricNullness V1 var2, @ParametricNullness V2 var3, @ParametricNullness V3 var4) throws Exception;
        }

        @FunctionalInterface
        public static interface ClosingFunction3<V1 extends @Nullable Object, V2 extends @Nullable Object, V3 extends @Nullable Object, U extends @Nullable Object> {
            @ParametricNullness
            public U apply(DeferredCloser var1, @ParametricNullness V1 var2, @ParametricNullness V2 var3, @ParametricNullness V3 var4) throws Exception;
        }
    }

    public static final class Combiner2<V1 extends @Nullable Object, V2 extends @Nullable Object>
    extends Combiner {
        private final ClosingFuture<V1> future1;
        private final ClosingFuture<V2> future2;

        private Combiner2(ClosingFuture<V1> future1, ClosingFuture<V2> future2) {
            super(true, (Iterable)ImmutableList.of(future1, future2));
            this.future1 = future1;
            this.future2 = future2;
        }

        public <U extends Object> ClosingFuture<U> call(final ClosingFunction2<V1, V2, U> function, Executor executor) {
            return this.call(new Combiner.CombiningCallable<U>(){

                @Override
                @ParametricNullness
                public U call(DeferredCloser closer, Peeker peeker) throws Exception {
                    return function.apply(closer, peeker.getDone(future1), peeker.getDone(future2));
                }

                public String toString() {
                    return function.toString();
                }
            }, executor);
        }

        public <U extends Object> ClosingFuture<U> callAsync(final AsyncClosingFunction2<V1, V2, U> function, Executor executor) {
            return this.callAsync(new Combiner.AsyncCombiningCallable<U>(){

                @Override
                public ClosingFuture<U> call(DeferredCloser closer, Peeker peeker) throws Exception {
                    return function.apply(closer, peeker.getDone(future1), peeker.getDone(future2));
                }

                public String toString() {
                    return function.toString();
                }
            }, executor);
        }

        @FunctionalInterface
        public static interface AsyncClosingFunction2<V1 extends @Nullable Object, V2 extends @Nullable Object, U extends @Nullable Object> {
            public ClosingFuture<U> apply(DeferredCloser var1, @ParametricNullness V1 var2, @ParametricNullness V2 var3) throws Exception;
        }

        @FunctionalInterface
        public static interface ClosingFunction2<V1 extends @Nullable Object, V2 extends @Nullable Object, U extends @Nullable Object> {
            @ParametricNullness
            public U apply(DeferredCloser var1, @ParametricNullness V1 var2, @ParametricNullness V2 var3) throws Exception;
        }
    }

    @DoNotMock(value="org.rascalmpl.org.rascalmpl.Use ClosingFuture.whenAllSucceed() or .whenAllComplete() instead.")
    public static class Combiner
    extends Object {
        private final CloseableList closeables = new CloseableList();
        private final boolean allMustSucceed;
        protected final ImmutableList<ClosingFuture<?>> inputs;

        private Combiner(boolean allMustSucceed, Iterable<? extends ClosingFuture<?>> inputs) {
            this.allMustSucceed = allMustSucceed;
            this.inputs = ImmutableList.copyOf(inputs);
            for (ClosingFuture input : inputs) {
                input.becomeSubsumedInto(this.closeables);
            }
        }

        public <V extends Object> ClosingFuture<V> call(final CombiningCallable<V> combiningCallable, Executor executor) {
            Callable callable = new Callable<V>(){

                @ParametricNullness
                public V call() throws Exception {
                    return new Peeker(inputs).call(combiningCallable, closeables);
                }

                public String toString() {
                    return combiningCallable.toString();
                }
            };
            ClosingFuture derived = new ClosingFuture(this.futureCombiner().call(callable, executor));
            derived.closeables.add((AutoCloseable)this.closeables, MoreExecutors.directExecutor());
            return derived;
        }

        public <V extends Object> ClosingFuture<V> callAsync(final AsyncCombiningCallable<V> combiningCallable, Executor executor) {
            AsyncCallable asyncCallable = new AsyncCallable<V>(){

                @Override
                public ListenableFuture<V> call() throws Exception {
                    return new Peeker(inputs).callAsync(combiningCallable, closeables);
                }

                public String toString() {
                    return combiningCallable.toString();
                }
            };
            ClosingFuture derived = new ClosingFuture(this.futureCombiner().callAsync(asyncCallable, executor));
            derived.closeables.add((AutoCloseable)this.closeables, MoreExecutors.directExecutor());
            return derived;
        }

        private Futures.FutureCombiner<@Nullable Object> futureCombiner() {
            return this.allMustSucceed ? Futures.whenAllSucceed(this.inputFutures()) : Futures.whenAllComplete(this.inputFutures());
        }

        /*
         * Exception decompiling
         */
        private ImmutableList<FluentFuture<?>> inputFutures() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/org/rascalmpl/java/lang/Object;)Lorg/rascalmpl/org/rascalmpl/java/lang/Object;
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
             *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static /* synthetic */ FluentFuture lambda$inputFutures$0(ClosingFuture future) {
            return future.future;
        }

        @FunctionalInterface
        public static interface AsyncCombiningCallable<V extends @Nullable Object> {
            public ClosingFuture<V> call(DeferredCloser var1, Peeker var2) throws Exception;
        }

        @FunctionalInterface
        public static interface CombiningCallable<V extends @Nullable Object> {
            @ParametricNullness
            public V call(DeferredCloser var1, Peeker var2) throws Exception;
        }
    }

    public static final class Peeker
    extends Object {
        private final ImmutableList<ClosingFuture<?>> futures;
        private volatile boolean beingCalled;

        private Peeker(ImmutableList<ClosingFuture<?>> futures) {
            this.futures = Preconditions.checkNotNull(futures);
        }

        @ParametricNullness
        public final <D extends Object> D getDone(ClosingFuture<D> closingFuture) throws ExecutionException {
            Preconditions.checkState(this.beingCalled);
            Preconditions.checkArgument(this.futures.contains(closingFuture));
            return (D)Futures.getDone(((ClosingFuture)closingFuture).future);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ParametricNullness
        private <V extends Object> V call(Combiner.CombiningCallable<V> combiner, CloseableList closeables) throws Exception {
            this.beingCalled = true;
            CloseableList newCloseables = new CloseableList();
            try {
                V v = combiner.call(newCloseables.closer, this);
                return v;
            }
            finally {
                closeables.add((AutoCloseable)newCloseables, MoreExecutors.directExecutor());
                this.beingCalled = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <V extends Object> FluentFuture<V> callAsync(Combiner.AsyncCombiningCallable<V> combiner, CloseableList closeables) throws Exception {
            this.beingCalled = true;
            CloseableList newCloseables = new CloseableList();
            try {
                ClosingFuture<V> closingFuture = combiner.call(newCloseables.closer, this);
                ((ClosingFuture)closingFuture).becomeSubsumedInto(closeables);
                FluentFuture fluentFuture = ((ClosingFuture)closingFuture).future;
                return fluentFuture;
            }
            finally {
                closeables.add((AutoCloseable)newCloseables, MoreExecutors.directExecutor());
                this.beingCalled = false;
            }
        }
    }

    @FunctionalInterface
    public static interface ValueAndCloserConsumer<V extends @Nullable Object> {
        public void accept(ValueAndCloser<V> var1);
    }

    public static final class ValueAndCloser<V extends @Nullable Object>
    extends Object {
        private final ClosingFuture<? extends V> closingFuture;

        ValueAndCloser(ClosingFuture<? extends V> closingFuture) {
            this.closingFuture = Preconditions.checkNotNull(closingFuture);
        }

        @ParametricNullness
        public V get() throws ExecutionException {
            return Futures.getDone(((ClosingFuture)this.closingFuture).future);
        }

        public void closeAsync() {
            ((ClosingFuture)this.closingFuture).close();
        }
    }

    @FunctionalInterface
    public static interface AsyncClosingFunction<T extends @Nullable Object, U extends @Nullable Object> {
        public ClosingFuture<U> apply(DeferredCloser var1, @ParametricNullness T var2) throws Exception;
    }

    @FunctionalInterface
    public static interface ClosingFunction<T extends @Nullable Object, U extends @Nullable Object> {
        @ParametricNullness
        public U apply(DeferredCloser var1, @ParametricNullness T var2) throws Exception;
    }

    @FunctionalInterface
    public static interface AsyncClosingCallable<V extends @Nullable Object> {
        public ClosingFuture<V> call(DeferredCloser var1) throws Exception;
    }

    @FunctionalInterface
    public static interface ClosingCallable<V extends @Nullable Object> {
        @ParametricNullness
        public V call(DeferredCloser var1) throws Exception;
    }

    public static final class DeferredCloser
    extends Object {
        @RetainedWith
        private final CloseableList list;

        DeferredCloser(CloseableList list) {
            this.list = list;
        }

        @ParametricNullness
        @CanIgnoreReturnValue
        public <C extends Object> C eventuallyClose(@ParametricNullness C closeable, Executor closingExecutor) {
            Preconditions.checkNotNull(closingExecutor);
            if (closeable != null) {
                this.list.add((AutoCloseable)closeable, closingExecutor);
            }
            return closeable;
        }
    }
}

