/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.ImmutableCollection;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.AggregateFuture;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.AsyncCallable;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.InterruptibleTask;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ListenableFuture;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ParametricNullness;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.concurrent.LazyInit;
import org.rascalmpl.org.rascalmpl.java.lang.Exception;
import org.rascalmpl.org.rascalmpl.java.lang.Runnable;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.Callable;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.CancellationException;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.ExecutionException;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.Executor;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.RejectedExecutionException;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class CombinedFuture<V extends @Nullable org.rascalmpl.org.rascalmpl.java.lang.Object>
extends AggregateFuture<org.rascalmpl.org.rascalmpl.java.lang.Object, V> {
    @CheckForNull
    @LazyInit
    private CombinedFutureInterruptibleTask<?> task;

    CombinedFuture(ImmutableCollection<? extends ListenableFuture<?>> futures, boolean allMustSucceed, Executor listenerExecutor, AsyncCallable<V> callable) {
        super(futures, allMustSucceed, false);
        this.task = new AsyncCallableInterruptibleTask(callable, listenerExecutor);
        this.init();
    }

    CombinedFuture(ImmutableCollection<? extends ListenableFuture<?>> futures, boolean allMustSucceed, Executor listenerExecutor, Callable<V> callable) {
        super(futures, allMustSucceed, false);
        this.task = new CallableInterruptibleTask(callable, listenerExecutor);
        this.init();
    }

    @Override
    void collectOneValue(int index, @CheckForNull org.rascalmpl.org.rascalmpl.java.lang.Object returnValue) {
    }

    @Override
    void handleAllCompleted() {
        CombinedFutureInterruptibleTask<?> localTask = this.task;
        if (localTask != null) {
            localTask.execute();
        }
    }

    @Override
    void releaseResources(AggregateFuture.ReleaseResourcesReason reason) {
        super.releaseResources(reason);
        if (reason == AggregateFuture.ReleaseResourcesReason.OUTPUT_FUTURE_DONE) {
            this.task = null;
        }
    }

    @Override
    protected void interruptTask() {
        CombinedFutureInterruptibleTask<?> localTask = this.task;
        if (localTask != null) {
            localTask.interruptTask();
        }
    }

    private final class CallableInterruptibleTask
    extends CombinedFutureInterruptibleTask<V> {
        private final Callable<V> callable;

        CallableInterruptibleTask(Callable<V> callable, Executor listenerExecutor) {
            super(listenerExecutor);
            this.callable = Preconditions.checkNotNull(callable);
        }

        @Override
        @ParametricNullness
        V runInterruptibly() throws Exception {
            return this.callable.call();
        }

        @Override
        void setValue(@ParametricNullness V value) {
            CombinedFuture.this.set(value);
        }

        @Override
        String toPendingString() {
            return this.callable.toString();
        }
    }

    private final class AsyncCallableInterruptibleTask
    extends CombinedFutureInterruptibleTask<ListenableFuture<V>> {
        private final AsyncCallable<V> callable;

        AsyncCallableInterruptibleTask(AsyncCallable<V> callable, Executor listenerExecutor) {
            super(listenerExecutor);
            this.callable = Preconditions.checkNotNull(callable);
        }

        @Override
        ListenableFuture<V> runInterruptibly() throws Exception {
            ListenableFuture result = this.callable.call();
            return Preconditions.checkNotNull(result, (String)"org.rascalmpl.org.rascalmpl.AsyncCallable.call returned null instead of a Future. Did you mean to return immediateFuture(null)? %s", this.callable);
        }

        @Override
        void setValue(ListenableFuture<V> value) {
            CombinedFuture.this.setFuture(value);
        }

        @Override
        String toPendingString() {
            return this.callable.toString();
        }
    }

    private abstract class CombinedFutureInterruptibleTask<T extends @Nullable org.rascalmpl.org.rascalmpl.java.lang.Object>
    extends InterruptibleTask<T> {
        private final Executor listenerExecutor;

        CombinedFutureInterruptibleTask(Executor listenerExecutor) {
            this.listenerExecutor = Preconditions.checkNotNull(listenerExecutor);
        }

        @Override
        final boolean isDone() {
            return CombinedFuture.this.isDone();
        }

        final void execute() {
            try {
                this.listenerExecutor.execute((Runnable)this);
            }
            catch (RejectedExecutionException e) {
                CombinedFuture.this.setException((Throwable)((Object)e));
            }
        }

        @Override
        final void afterRanInterruptiblySuccess(@ParametricNullness T result) {
            CombinedFuture.this.task = null;
            this.setValue(result);
        }

        @Override
        final void afterRanInterruptiblyFailure(Throwable error) {
            CombinedFuture.this.task = null;
            if (error instanceof ExecutionException) {
                CombinedFuture.this.setException(((ExecutionException)((Object)error)).getCause());
            } else if (error instanceof CancellationException) {
                CombinedFuture.this.cancel(false);
            } else {
                CombinedFuture.this.setException(error);
            }
        }

        abstract void setValue(@ParametricNullness T var1);
    }
}

