/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.AbstractListeningExecutorService;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.concurrent.GuardedBy;
import org.rascalmpl.org.rascalmpl.java.lang.InterruptedException;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.Runnable;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.System;
import org.rascalmpl.org.rascalmpl.java.util.Collections;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.RejectedExecutionException;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.TimeUnit;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
final class DirectExecutorService
extends AbstractListeningExecutorService {
    private final Object lock = new Object();
    @GuardedBy(value="org.rascalmpl.org.rascalmpl.lock")
    private int runningTasks = 0;
    @GuardedBy(value="org.rascalmpl.org.rascalmpl.lock")
    private boolean shutdown = false;

    DirectExecutorService() {
    }

    public void execute(Runnable command) {
        this.startTask();
        try {
            command.run();
        }
        finally {
            this.endTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShutdown() {
        Object object = this.lock;
        synchronized (object) {
            return this.shutdown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            this.shutdown = true;
            if (this.runningTasks == 0) {
                this.lock.notifyAll();
            }
        }
    }

    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTerminated() {
        Object object = this.lock;
        synchronized (object) {
            return this.shutdown && this.runningTasks == 0;
        }
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                if (this.shutdown && this.runningTasks == 0) {
                    return true;
                }
                if (nanos <= 0L) {
                    return false;
                }
                long now = System.nanoTime();
                TimeUnit.NANOSECONDS.timedWait(this.lock, nanos);
                nanos -= System.nanoTime() - now;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTask() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                throw new RejectedExecutionException((String)"org.rascalmpl.org.rascalmpl.Executor already shutdown");
            }
            ++this.runningTasks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endTask() {
        Object object = this.lock;
        synchronized (object) {
            int numRunning = --this.runningTasks;
            if (numRunning == 0) {
                this.lock.notifyAll();
            }
        }
    }
}

