/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.AsyncCallable;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.Futures;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ListenableFuture;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.SettableFuture;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.TrustedListenableFutureTask;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.concurrent.LazyInit;
import org.rascalmpl.org.rascalmpl.java.lang.Enum;
import org.rascalmpl.org.rascalmpl.java.lang.Exception;
import org.rascalmpl.org.rascalmpl.java.lang.Runnable;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.Thread;
import org.rascalmpl.org.rascalmpl.java.lang.Void;
import org.rascalmpl.org.rascalmpl.java.util.Objects;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.Callable;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.Executor;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.atomic.AtomicReference;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
public final class ExecutionSequencer
extends org.rascalmpl.org.rascalmpl.java.lang.Object {
    private final AtomicReference<ListenableFuture<@Nullable Void>> ref = new AtomicReference(Futures.immediateVoidFuture());
    @LazyInit
    private ThreadConfinedTaskQueue latestTaskQueue = new ThreadConfinedTaskQueue();

    private ExecutionSequencer() {
    }

    public static ExecutionSequencer create() {
        return new ExecutionSequencer();
    }

    public <T extends org.rascalmpl.org.rascalmpl.java.lang.Object> ListenableFuture<T> submit(final Callable<T> callable, Executor executor) {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(executor);
        return this.submitAsync(new AsyncCallable<T>(){

            @Override
            public ListenableFuture<T> call() throws Exception {
                return Futures.immediateFuture(callable.call());
            }

            public String toString() {
                return callable.toString();
            }
        }, executor);
    }

    /*
     * Exception decompiling
     */
    public <T extends org.rascalmpl.org.rascalmpl.java.lang.Object> ListenableFuture<T> submitAsync(AsyncCallable<T> callable, Executor executor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.org.rascalmpl.java.lang.invoke.MethodType, got ()V
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ void lambda$submitAsync$0(TrustedListenableFutureTask taskFuture, SettableFuture newFuture, ListenableFuture oldFuture, ListenableFuture outputFuture, TaskNonReentrantExecutor taskExecutor) {
        if (taskFuture.isDone()) {
            newFuture.setFuture(oldFuture);
        } else if (outputFuture.isCancelled() && taskExecutor.trySetCancelled()) {
            taskFuture.cancel(false);
        }
    }

    private static final class TaskNonReentrantExecutor
    extends AtomicReference<RunningState>
    implements Executor,
    Runnable {
        @CheckForNull
        ExecutionSequencer sequencer;
        @CheckForNull
        Executor delegate;
        @CheckForNull
        Runnable task;
        @CheckForNull
        @LazyInit
        Thread submitting;

        private TaskNonReentrantExecutor(Executor delegate, ExecutionSequencer sequencer) {
            super((org.rascalmpl.org.rascalmpl.java.lang.Object)RunningState.NOT_RUN);
            this.delegate = delegate;
            this.sequencer = sequencer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Runnable task) {
            if (this.get() == RunningState.CANCELLED) {
                this.delegate = null;
                this.sequencer = null;
                return;
            }
            this.submitting = Thread.currentThread();
            try {
                ThreadConfinedTaskQueue submittingTaskQueue = ((ExecutionSequencer)Objects.requireNonNull((org.rascalmpl.org.rascalmpl.java.lang.Object)this.sequencer)).latestTaskQueue;
                if (submittingTaskQueue.thread == this.submitting) {
                    this.sequencer = null;
                    Preconditions.checkState(submittingTaskQueue.nextTask == null);
                    submittingTaskQueue.nextTask = task;
                    submittingTaskQueue.nextExecutor = (Executor)Objects.requireNonNull((org.rascalmpl.org.rascalmpl.java.lang.Object)this.delegate);
                    this.delegate = null;
                } else {
                    Executor localDelegate = (Executor)Objects.requireNonNull((org.rascalmpl.org.rascalmpl.java.lang.Object)this.delegate);
                    this.delegate = null;
                    this.task = task;
                    localDelegate.execute((Runnable)this);
                }
            }
            finally {
                this.submitting = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread currentThread = Thread.currentThread();
            if (currentThread != this.submitting) {
                Runnable localTask = (Runnable)Objects.requireNonNull((org.rascalmpl.org.rascalmpl.java.lang.Object)this.task);
                this.task = null;
                localTask.run();
                return;
            }
            ThreadConfinedTaskQueue executingTaskQueue = new ThreadConfinedTaskQueue();
            executingTaskQueue.thread = currentThread;
            ((ExecutionSequencer)Objects.requireNonNull((org.rascalmpl.org.rascalmpl.java.lang.Object)this.sequencer)).latestTaskQueue = executingTaskQueue;
            this.sequencer = null;
            try {
                Executor queuedExecutor;
                Runnable queuedTask;
                Runnable localTask = (Runnable)Objects.requireNonNull((org.rascalmpl.org.rascalmpl.java.lang.Object)this.task);
                this.task = null;
                localTask.run();
                while ((queuedTask = executingTaskQueue.nextTask) != null && (queuedExecutor = executingTaskQueue.nextExecutor) != null) {
                    executingTaskQueue.nextTask = null;
                    executingTaskQueue.nextExecutor = null;
                    queuedExecutor.execute(queuedTask);
                }
            }
            finally {
                executingTaskQueue.thread = null;
            }
        }

        private boolean trySetStarted() {
            return this.compareAndSet((org.rascalmpl.org.rascalmpl.java.lang.Object)RunningState.NOT_RUN, (org.rascalmpl.org.rascalmpl.java.lang.Object)RunningState.STARTED);
        }

        private boolean trySetCancelled() {
            return this.compareAndSet((org.rascalmpl.org.rascalmpl.java.lang.Object)RunningState.NOT_RUN, (org.rascalmpl.org.rascalmpl.java.lang.Object)RunningState.CANCELLED);
        }
    }

    static final class RunningState
    extends Enum<RunningState> {
        public static final /* enum */ RunningState NOT_RUN = new RunningState((String)"org.rascalmpl.org.rascalmpl.NOT_RUN", 0);
        public static final /* enum */ RunningState CANCELLED = new RunningState((String)"org.rascalmpl.org.rascalmpl.CANCELLED", 1);
        public static final /* enum */ RunningState STARTED = new RunningState((String)"org.rascalmpl.org.rascalmpl.STARTED", 2);
        private static final /* synthetic */ RunningState[] $VALUES;

        public static RunningState[] values() {
            return (RunningState[])$VALUES.clone();
        }

        public static RunningState valueOf(String name) {
            return (RunningState)Enum.valueOf(RunningState.class, (String)name);
        }

        private RunningState() {
            super((String)string, n);
        }

        static {
            $VALUES = new RunningState[]{NOT_RUN, CANCELLED, STARTED};
        }
    }

    private static final class ThreadConfinedTaskQueue
    extends org.rascalmpl.org.rascalmpl.java.lang.Object {
        @CheckForNull
        @LazyInit
        Thread thread;
        @CheckForNull
        Runnable nextTask;
        @CheckForNull
        Executor nextExecutor;

        private ThreadConfinedTaskQueue() {
        }
    }
}

