/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Function;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.AbstractFuture;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.AsyncFunction;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ForwardingFluentFuture;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.FutureCallback;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.Futures;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.GwtFluentFutureCatchingSpecialization;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.Internal;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ListenableFuture;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ParametricNullness;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.Partially;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.DoNotMock;
import org.rascalmpl.org.rascalmpl.java.lang.Class;
import org.rascalmpl.org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.org.rascalmpl.java.lang.InterruptedException;
import org.rascalmpl.org.rascalmpl.java.lang.Runnable;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.time.Duration;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.ExecutionException;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.Executor;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.ScheduledExecutorService;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.TimeoutException;
import org.rascalmpl.org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@DoNotMock(value="org.rascalmpl.org.rascalmpl.Use FluentFuture.from(Futures.immediate*Future) or SettableFuture")
@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public abstract class FluentFuture<V extends @Nullable org.rascalmpl.org.rascalmpl.java.lang.Object>
extends GwtFluentFutureCatchingSpecialization<V> {
    FluentFuture() {
    }

    public static <V extends org.rascalmpl.org.rascalmpl.java.lang.Object> FluentFuture<V> from(ListenableFuture<V> future) {
        return future instanceof FluentFuture ? (FluentFuture<V>)future : new ForwardingFluentFuture<V>(future);
    }

    @Deprecated
    public static <V extends org.rascalmpl.org.rascalmpl.java.lang.Object> FluentFuture<V> from(FluentFuture<V> future) {
        return Preconditions.checkNotNull(future);
    }

    @J2ktIncompatible
    @Partially.GwtIncompatible(value="org.rascalmpl.org.rascalmpl.AVAILABLE but requires exceptionType to be Throwable.class")
    public final <X extends Throwable> FluentFuture<V> catching(Class<X> exceptionType, Function<? super X, ? extends V> fallback, Executor executor) {
        return (FluentFuture)Futures.catching(this, exceptionType, fallback, executor);
    }

    @J2ktIncompatible
    @Partially.GwtIncompatible(value="org.rascalmpl.org.rascalmpl.AVAILABLE but requires exceptionType to be Throwable.class")
    public final <X extends Throwable> FluentFuture<V> catchingAsync(Class<X> exceptionType, AsyncFunction<? super X, ? extends V> fallback, Executor executor) {
        return (FluentFuture)Futures.catchingAsync(this, exceptionType, fallback, executor);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public final FluentFuture<V> withTimeout(Duration timeout, ScheduledExecutorService scheduledExecutor) {
        return this.withTimeout(Internal.toNanosSaturated(timeout), TimeUnit.NANOSECONDS, scheduledExecutor);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public final FluentFuture<V> withTimeout(long timeout, TimeUnit unit, ScheduledExecutorService scheduledExecutor) {
        return (FluentFuture)Futures.withTimeout(this, timeout, unit, scheduledExecutor);
    }

    public final <T extends org.rascalmpl.org.rascalmpl.java.lang.Object> FluentFuture<T> transformAsync(AsyncFunction<? super V, T> function, Executor executor) {
        return (FluentFuture)Futures.transformAsync(this, function, executor);
    }

    public final <T extends org.rascalmpl.org.rascalmpl.java.lang.Object> FluentFuture<T> transform(Function<? super V, T> function, Executor executor) {
        return (FluentFuture)Futures.transform(this, function, executor);
    }

    public final void addCallback(FutureCallback<? super V> callback, Executor executor) {
        Futures.addCallback(this, callback, executor);
    }

    static abstract class TrustedFuture<V extends @Nullable org.rascalmpl.org.rascalmpl.java.lang.Object>
    extends FluentFuture<V>
    implements AbstractFuture.Trusted<V> {
        TrustedFuture() {
        }

        @Override
        @ParametricNullness
        @CanIgnoreReturnValue
        public final V get() throws InterruptedException, ExecutionException {
            return super.get();
        }

        @Override
        @ParametricNullness
        @CanIgnoreReturnValue
        public final V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return super.get(timeout, unit);
        }

        @Override
        public final boolean isDone() {
            return super.isDone();
        }

        @Override
        public final boolean isCancelled() {
            return super.isCancelled();
        }

        @Override
        public final void addListener(Runnable listener, Executor executor) {
            super.addListener(listener, executor);
        }

        @Override
        @CanIgnoreReturnValue
        public final boolean cancel(boolean mayInterruptIfRunning) {
            return super.cancel(mayInterruptIfRunning);
        }
    }
}

