/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.VisibleForTesting;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Ordering;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ExecutionError;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ParametricNullness;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.UncheckedExecutionException;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.org.rascalmpl.java.lang.Class;
import org.rascalmpl.org.rascalmpl.java.lang.ClassNotFoundException;
import org.rascalmpl.org.rascalmpl.java.lang.ClassValue;
import org.rascalmpl.org.rascalmpl.java.lang.Comparable;
import org.rascalmpl.org.rascalmpl.java.lang.Enum;
import org.rascalmpl.org.rascalmpl.java.lang.Error;
import org.rascalmpl.org.rascalmpl.java.lang.Exception;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalAccessException;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.org.rascalmpl.java.lang.InstantiationException;
import org.rascalmpl.org.rascalmpl.java.lang.InterruptedException;
import org.rascalmpl.org.rascalmpl.java.lang.RuntimeException;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.Thread;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.lang.ref.WeakReference;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.Constructor;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.InvocationTargetException;
import org.rascalmpl.org.rascalmpl.java.util.Arrays;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.Set;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.CopyOnWriteArraySet;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.ExecutionException;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.Future;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.TimeoutException;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
final class FuturesGetChecked
extends org.rascalmpl.org.rascalmpl.java.lang.Object {
    private static final Ordering<List<Class<?>>> ORDERING_BY_CONSTRUCTOR_PARAMETER_LIST;
    private static final Ordering<Constructor<?>> WITH_STRING_PARAM_THEN_WITH_THROWABLE_PARAM;

    @ParametricNullness
    @CanIgnoreReturnValue
    static <V extends org.rascalmpl.org.rascalmpl.java.lang.Object, X extends Exception> V getChecked(Future<V> future, Class<X> exceptionClass) throws X {
        return FuturesGetChecked.getChecked(FuturesGetChecked.bestGetCheckedTypeValidator(), future, exceptionClass);
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    @VisibleForTesting
    static <V extends org.rascalmpl.org.rascalmpl.java.lang.Object, X extends Exception> V getChecked(GetCheckedTypeValidator validator, Future<V> future, Class<X> exceptionClass) throws X {
        validator.validateClass(exceptionClass);
        try {
            return (V)future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw FuturesGetChecked.newWithCause(exceptionClass, (Throwable)((Object)e));
        }
        catch (ExecutionException e) {
            FuturesGetChecked.wrapAndThrowExceptionOrError(e.getCause(), exceptionClass);
            throw new AssertionError();
        }
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    static <V extends org.rascalmpl.org.rascalmpl.java.lang.Object, X extends Exception> V getChecked(Future<V> future, Class<X> exceptionClass, long timeout, TimeUnit unit) throws X {
        FuturesGetChecked.bestGetCheckedTypeValidator().validateClass(exceptionClass);
        try {
            return (V)future.get(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw FuturesGetChecked.newWithCause(exceptionClass, (Throwable)((Object)e));
        }
        catch (TimeoutException e) {
            throw FuturesGetChecked.newWithCause(exceptionClass, (Throwable)((Object)e));
        }
        catch (ExecutionException e) {
            FuturesGetChecked.wrapAndThrowExceptionOrError(e.getCause(), exceptionClass);
            throw new AssertionError();
        }
    }

    private static GetCheckedTypeValidator bestGetCheckedTypeValidator() {
        return GetCheckedTypeValidatorHolder.BEST_VALIDATOR;
    }

    @VisibleForTesting
    static GetCheckedTypeValidator weakSetValidator() {
        return GetCheckedTypeValidatorHolder.WeakSetValidator.INSTANCE;
    }

    @VisibleForTesting
    static GetCheckedTypeValidator classValueValidator() {
        return GetCheckedTypeValidatorHolder.ClassValueValidator.INSTANCE;
    }

    private static <X extends Exception> void wrapAndThrowExceptionOrError(Throwable cause, Class<X> exceptionClass) throws X {
        if (cause instanceof Error) {
            throw new ExecutionError((Error)((Object)cause));
        }
        if (cause instanceof RuntimeException) {
            throw new UncheckedExecutionException(cause);
        }
        throw FuturesGetChecked.newWithCause(exceptionClass, cause);
    }

    private static boolean hasConstructorUsableByGetChecked(Class<? extends Exception> exceptionClass) {
        try {
            Exception unused = FuturesGetChecked.newWithCause(exceptionClass, (Throwable)((Object)new Exception()));
            return true;
        }
        catch (Throwable t2) {
            return false;
        }
    }

    private static <X extends Exception> X newWithCause(Class<X> exceptionClass, Throwable cause) {
        List constructors = Arrays.asList((org.rascalmpl.org.rascalmpl.java.lang.Object[])exceptionClass.getConstructors());
        for (Constructor constructor : FuturesGetChecked.preferringStringsThenThrowables(constructors)) {
            Exception instance = (Exception)((Object)FuturesGetChecked.newFromConstructor(constructor, cause));
            if (instance == null) continue;
            if (instance.getCause() == null) {
                instance.initCause(cause);
            }
            return (X)((Object)instance);
        }
        throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.No appropriate constructor for exception of type ").append(exceptionClass).append((String)"org.rascalmpl.org.rascalmpl. in response to chained exception").toString(), cause);
    }

    private static <X extends Exception> List<Constructor<X>> preferringStringsThenThrowables(List<Constructor<X>> constructors) {
        return WITH_STRING_PARAM_THEN_WITH_THROWABLE_PARAM.sortedCopy(constructors);
    }

    @CheckForNull
    private static <X extends org.rascalmpl.org.rascalmpl.java.lang.Object> X newFromConstructor(Constructor<X> constructor, Throwable cause) {
        Class[] paramTypes = constructor.getParameterTypes();
        org.rascalmpl.org.rascalmpl.java.lang.Object[] params = new org.rascalmpl.org.rascalmpl.java.lang.Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            Class paramType = paramTypes[i];
            if (paramType.equals(String.class)) {
                params[i] = cause.toString();
                continue;
            }
            if (paramType.equals(Throwable.class)) {
                params[i] = cause;
                continue;
            }
            return null;
        }
        try {
            return (X)constructor.newInstance(params);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            return null;
        }
    }

    @VisibleForTesting
    static boolean isCheckedException(Class<? extends Exception> type) {
        return !RuntimeException.class.isAssignableFrom(type);
    }

    @VisibleForTesting
    static void checkExceptionClassValidity(Class<? extends Exception> exceptionClass) {
        Preconditions.checkArgument(FuturesGetChecked.isCheckedException(exceptionClass), (String)"org.rascalmpl.org.rascalmpl.Futures.getChecked exception type (%s) must not be a RuntimeException", exceptionClass);
        Preconditions.checkArgument(FuturesGetChecked.hasConstructorUsableByGetChecked(exceptionClass), (String)"org/rascalmpl/org/rascalmpl/Futures.getChecked exception type (%s) must be an accessible class with an accessible constructor whose parameters (if any) must be of type String and/or Throwable", exceptionClass);
    }

    private FuturesGetChecked() {
    }

    private static /* synthetic */ List lambda$static$2(Constructor constructor) {
        return Arrays.asList((org.rascalmpl.org.rascalmpl.java.lang.Object[])constructor.getParameterTypes());
    }

    private static /* synthetic */ Comparable lambda$static$1(List params) {
        return Boolean.valueOf((boolean)params.contains(Throwable.class));
    }

    private static /* synthetic */ Comparable lambda$static$0(List params) {
        return Boolean.valueOf((boolean)params.contains(String.class));
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/org/rascalmpl/java/lang/Object;)Lorg/rascalmpl/org/rascalmpl/java/lang/Object;
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @VisibleForTesting
    static class GetCheckedTypeValidatorHolder
    extends org.rascalmpl.org.rascalmpl.java.lang.Object {
        static final String CLASS_VALUE_VALIDATOR_NAME = new StringBuilder().append(GetCheckedTypeValidatorHolder.class.getName()).append((String)"org.rascalmpl.org.rascalmpl.$ClassValueValidator").toString();
        static final GetCheckedTypeValidator BEST_VALIDATOR = GetCheckedTypeValidatorHolder.getBestValidator();

        GetCheckedTypeValidatorHolder() {
        }

        static GetCheckedTypeValidator getBestValidator() {
            try {
                Class theClass = Class.forName((String)CLASS_VALUE_VALIDATOR_NAME).asSubclass(Enum.class);
                return (GetCheckedTypeValidator)((Enum[])theClass.getEnumConstants())[0];
            }
            catch (ClassNotFoundException | Error | RuntimeException t2) {
                return FuturesGetChecked.weakSetValidator();
            }
        }

        static final class WeakSetValidator
        extends Enum<WeakSetValidator>
        implements GetCheckedTypeValidator {
            public static final /* enum */ WeakSetValidator INSTANCE = new WeakSetValidator((String)"org.rascalmpl.org.rascalmpl.INSTANCE", 0);
            private static final Set<WeakReference<Class<? extends Exception>>> validClasses;
            private static final /* synthetic */ WeakSetValidator[] $VALUES;

            public static WeakSetValidator[] values() {
                return (WeakSetValidator[])$VALUES.clone();
            }

            public static WeakSetValidator valueOf(String name) {
                return (WeakSetValidator)Enum.valueOf(WeakSetValidator.class, (String)name);
            }

            private WeakSetValidator() {
                super((String)string, n);
            }

            @Override
            public void validateClass(Class<? extends Exception> exceptionClass) {
                for (WeakReference knownGood : validClasses) {
                    if (!exceptionClass.equals(knownGood.get())) continue;
                    return;
                }
                FuturesGetChecked.checkExceptionClassValidity(exceptionClass);
                if (validClasses.size() > 1000) {
                    validClasses.clear();
                }
                validClasses.add((org.rascalmpl.org.rascalmpl.java.lang.Object)new WeakReference(exceptionClass));
            }

            static {
                $VALUES = new WeakSetValidator[]{INSTANCE};
                validClasses = new CopyOnWriteArraySet();
            }
        }

        static final class ClassValueValidator
        extends Enum<ClassValueValidator>
        implements GetCheckedTypeValidator {
            public static final /* enum */ ClassValueValidator INSTANCE = new ClassValueValidator((String)"org.rascalmpl.org.rascalmpl.INSTANCE", 0);
            private static final ClassValue<Boolean> isValidClass;
            private static final /* synthetic */ ClassValueValidator[] $VALUES;

            public static ClassValueValidator[] values() {
                return (ClassValueValidator[])$VALUES.clone();
            }

            public static ClassValueValidator valueOf(String name) {
                return (ClassValueValidator)Enum.valueOf(ClassValueValidator.class, (String)name);
            }

            private ClassValueValidator() {
                super((String)string, n);
            }

            @Override
            public void validateClass(Class<? extends Exception> exceptionClass) {
                isValidClass.get(exceptionClass);
            }

            static {
                $VALUES = new ClassValueValidator[]{INSTANCE};
                isValidClass = new ClassValue<Boolean>(){

                    protected Boolean computeValue(Class<?> type) {
                        FuturesGetChecked.checkExceptionClassValidity((Class<? extends Exception>)type.asSubclass(Exception.class));
                        return Boolean.valueOf((boolean)true);
                    }
                };
            }
        }
    }

    @VisibleForTesting
    static interface GetCheckedTypeValidator {
        public void validateClass(Class<? extends Exception> var1);
    }
}

