/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.AbstractFuture;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.LazyLogger;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ListenableFuture;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ParametricNullness;
import org.rascalmpl.org.rascalmpl.java.lang.Class;
import org.rascalmpl.org.rascalmpl.java.lang.Exception;
import org.rascalmpl.org.rascalmpl.java.lang.Runnable;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.ExecutionException;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.Executor;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible
class ImmediateFuture<V extends @Nullable org.rascalmpl.org.rascalmpl.java.lang.Object>
extends org.rascalmpl.org.rascalmpl.java.lang.Object
implements ListenableFuture<V> {
    static final ListenableFuture<?> NULL = new ImmediateFuture<Object>(null);
    private static final LazyLogger log = new LazyLogger((Class<?>)ImmediateFuture.class);
    @ParametricNullness
    private final V value;

    ImmediateFuture(@ParametricNullness V value) {
        this.value = value;
    }

    @Override
    public void addListener(Runnable listener, Executor executor) {
        Preconditions.checkNotNull(listener, (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.Runnable was null.");
        Preconditions.checkNotNull(executor, (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.Executor was null.");
        try {
            executor.execute(listener);
        }
        catch (Exception e) {
            log.get().log(Level.SEVERE, new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.RuntimeException while executing runnable ").append((org.rascalmpl.org.rascalmpl.java.lang.Object)listener).append((String)"org.rascalmpl.org.rascalmpl. with executor ").append((org.rascalmpl.org.rascalmpl.java.lang.Object)executor).toString(), (Throwable)((Object)e));
        }
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @ParametricNullness
    public V get() {
        return this.value;
    }

    @ParametricNullness
    public V get(long timeout, TimeUnit unit) throws ExecutionException {
        Preconditions.checkNotNull(unit);
        return this.get();
    }

    public boolean isCancelled() {
        return false;
    }

    public boolean isDone() {
        return true;
    }

    public String toString() {
        return new StringBuilder().append(super.toString()).append((String)"org.rascalmpl.org.rascalmpl.[status=SUCCESS, result=[").append(this.value).append((String)"org.rascalmpl.org.rascalmpl.]]").toString();
    }

    static final class ImmediateCancelledFuture<V extends @Nullable org.rascalmpl.org.rascalmpl.java.lang.Object>
    extends AbstractFuture.TrustedFuture<V> {
        @CheckForNull
        static final ImmediateCancelledFuture<org.rascalmpl.org.rascalmpl.java.lang.Object> INSTANCE = AbstractFuture.GENERATE_CANCELLATION_CAUSES ? null : new ImmediateCancelledFuture();

        ImmediateCancelledFuture() {
            this.cancel(false);
        }
    }

    static final class ImmediateFailedFuture<V extends @Nullable org.rascalmpl.org.rascalmpl.java.lang.Object>
    extends AbstractFuture.TrustedFuture<V> {
        ImmediateFailedFuture(Throwable thrown) {
            this.setException(thrown);
        }
    }
}

