/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.VisibleForTesting;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.NullnessCasts;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ParametricNullness;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.Platform;
import org.rascalmpl.org.rascalmpl.com.google.j2objc.annotations.ReflectionSupport;
import org.rascalmpl.org.rascalmpl.java.lang.Exception;
import org.rascalmpl.org.rascalmpl.java.lang.Runnable;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.Thread;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.atomic.AtomicReference;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.locks.AbstractOwnableSynchronizer;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.locks.LockSupport;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
@ReflectionSupport(value=ReflectionSupport.Level.FULL)
abstract class InterruptibleTask<T extends @Nullable org.rascalmpl.org.rascalmpl.java.lang.Object>
extends AtomicReference<Runnable>
implements Runnable {
    private static final Runnable DONE;
    private static final Runnable PARKED;
    private static final int MAX_BUSY_WAIT_SPINS = 1000;

    InterruptibleTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        Thread currentThread = Thread.currentThread();
        if (!this.compareAndSet(null, (org.rascalmpl.org.rascalmpl.java.lang.Object)currentThread)) {
            return;
        }
        boolean run = !this.isDone();
        org.rascalmpl.org.rascalmpl.java.lang.Object result = null;
        Throwable error = null;
        try {
            if (run) {
                result = this.runInterruptibly();
            }
        }
        catch (Throwable t2) {
            Platform.restoreInterruptIfIsInterruptedException(t2);
            error = t2;
        }
        finally {
            if (!this.compareAndSet((org.rascalmpl.org.rascalmpl.java.lang.Object)currentThread, (org.rascalmpl.org.rascalmpl.java.lang.Object)DONE)) {
                this.waitForInterrupt(currentThread);
            }
            if (run) {
                if (error == null) {
                    this.afterRanInterruptiblySuccess(NullnessCasts.uncheckedCastNullableTToT(result));
                } else {
                    this.afterRanInterruptiblyFailure(error);
                }
            }
        }
    }

    private void waitForInterrupt(Thread currentThread) {
        boolean restoreInterruptedBit = false;
        int spinCount = 0;
        Runnable state = (Runnable)this.get();
        Blocker blocker = null;
        while (state instanceof Blocker || state == PARKED) {
            if (state instanceof Blocker) {
                blocker = (Blocker)state;
            }
            if (++spinCount > 1000) {
                if (state == PARKED || this.compareAndSet((org.rascalmpl.org.rascalmpl.java.lang.Object)state, (org.rascalmpl.org.rascalmpl.java.lang.Object)PARKED)) {
                    restoreInterruptedBit = Thread.interrupted() || restoreInterruptedBit;
                    LockSupport.park((org.rascalmpl.org.rascalmpl.java.lang.Object)blocker);
                }
            } else {
                Thread.yield();
            }
            state = (Runnable)this.get();
        }
        if (restoreInterruptedBit) {
            currentThread.interrupt();
        }
    }

    abstract boolean isDone();

    @ParametricNullness
    abstract T runInterruptibly() throws Exception;

    abstract void afterRanInterruptiblySuccess(@ParametricNullness T var1);

    abstract void afterRanInterruptiblyFailure(Throwable var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void interruptTask() {
        Runnable currentRunner = (Runnable)this.get();
        if (currentRunner instanceof Thread) {
            Blocker blocker = new Blocker(this);
            blocker.setOwner(Thread.currentThread());
            if (this.compareAndSet((org.rascalmpl.org.rascalmpl.java.lang.Object)currentRunner, (org.rascalmpl.org.rascalmpl.java.lang.Object)blocker)) {
                try {
                    ((Thread)currentRunner).interrupt();
                }
                finally {
                    Runnable prev = (Runnable)this.getAndSet((org.rascalmpl.org.rascalmpl.java.lang.Object)DONE);
                    if (prev == PARKED) {
                        LockSupport.unpark((Thread)((Thread)currentRunner));
                    }
                }
            }
        }
    }

    public final String toString() {
        Runnable state = (Runnable)this.get();
        Object result = state == DONE ? "org.rascalmpl.org.rascalmpl.running=[DONE]" : (state instanceof Blocker ? "org.rascalmpl.org.rascalmpl.running=[INTERRUPTED]" : (state instanceof Thread ? new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.running=[RUNNING ON ").append(((Thread)state).getName()).append((String)"org.rascalmpl.org.rascalmpl.]").toString() : "org.rascalmpl.org.rascalmpl.running=[NOT STARTED YET]"));
        return new StringBuilder().append((String)result).append((String)"org.rascalmpl.org.rascalmpl., ").append(this.toPendingString()).toString();
    }

    abstract String toPendingString();

    static {
        Class<LockSupport> clazz = LockSupport.class;
        DONE = new DoNothingRunnable();
        PARKED = new DoNothingRunnable();
    }

    @VisibleForTesting
    static final class Blocker
    extends AbstractOwnableSynchronizer
    implements Runnable {
        private final InterruptibleTask<?> task;

        private Blocker(InterruptibleTask<?> task) {
            this.task = task;
        }

        public void run() {
        }

        private void setOwner(Thread thread) {
            super.setExclusiveOwnerThread(thread);
        }

        @CheckForNull
        @VisibleForTesting
        Thread getOwner() {
            return super.getExclusiveOwnerThread();
        }

        public String toString() {
            return this.task.toString();
        }
    }

    private static final class DoNothingRunnable
    extends org.rascalmpl.org.rascalmpl.java.lang.Object
    implements Runnable {
        private DoNothingRunnable() {
        }

        public void run() {
        }
    }
}

