/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Queues;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.LazyLogger;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.concurrent.GuardedBy;
import org.rascalmpl.org.rascalmpl.java.lang.Class;
import org.rascalmpl.org.rascalmpl.java.lang.Exception;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.Runnable;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.org.rascalmpl.java.util.Collections;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.Queue;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.Executor;
import org.rascalmpl.org.rascalmpl.java.util.logging.Level;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
final class ListenerCallQueue<L extends Object>
extends Object {
    private static final LazyLogger logger = new LazyLogger((Class<?>)ListenerCallQueue.class);
    private final List<PerListenerQueue<L>> listeners = Collections.synchronizedList((List)new ArrayList());

    ListenerCallQueue() {
    }

    public void addListener(L listener, Executor executor) {
        Preconditions.checkNotNull(listener, (Object)"org.rascalmpl.org.rascalmpl.listener");
        Preconditions.checkNotNull(executor, (Object)"org.rascalmpl.org.rascalmpl.executor");
        this.listeners.add(new PerListenerQueue<L>(listener, executor));
    }

    public void enqueue(Event<L> event) {
        this.enqueueHelper(event, event);
    }

    public void enqueue(Event<L> event, String label) {
        this.enqueueHelper(event, (Object)label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueHelper(Event<L> event, Object label) {
        Preconditions.checkNotNull(event, (Object)"org.rascalmpl.org.rascalmpl.event");
        Preconditions.checkNotNull(label, (Object)"org.rascalmpl.org.rascalmpl.label");
        List<PerListenerQueue<L>> list = this.listeners;
        synchronized (list) {
            for (PerListenerQueue queue : this.listeners) {
                queue.add(event, label);
            }
        }
    }

    public void dispatch() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((PerListenerQueue)this.listeners.get(i)).dispatch();
        }
    }

    private static final class PerListenerQueue<L extends Object>
    extends Object
    implements Runnable {
        final L listener;
        final Executor executor;
        @GuardedBy(value="org.rascalmpl.org.rascalmpl.this")
        final Queue<Event<L>> waitQueue = Queues.newArrayDeque();
        @GuardedBy(value="org.rascalmpl.org.rascalmpl.this")
        final Queue<Object> labelQueue = Queues.newArrayDeque();
        @GuardedBy(value="org.rascalmpl.org.rascalmpl.this")
        boolean isThreadScheduled;

        PerListenerQueue(L listener, Executor executor) {
            this.listener = Preconditions.checkNotNull(listener);
            this.executor = Preconditions.checkNotNull(executor);
        }

        synchronized void add(Event<L> event, Object label) {
            this.waitQueue.add(event);
            this.labelQueue.add(label);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispatch() {
            boolean scheduleEventRunner = false;
            PerListenerQueue perListenerQueue = this;
            synchronized (perListenerQueue) {
                if (!this.isThreadScheduled) {
                    this.isThreadScheduled = true;
                    scheduleEventRunner = true;
                }
            }
            if (scheduleEventRunner) {
                try {
                    this.executor.execute((Runnable)this);
                }
                catch (Exception e) {
                    PerListenerQueue perListenerQueue2 = this;
                    synchronized (perListenerQueue2) {
                        this.isThreadScheduled = false;
                    }
                    logger.get().log(Level.SEVERE, new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.Exception while running callbacks for ").append(this.listener).append((String)"org.rascalmpl.org.rascalmpl. on ").append((Object)this.executor).toString(), (Throwable)((java.lang.Object)e));
                    throw e;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block18: {
                boolean stillRunning = true;
                block14: while (true) {
                    while (true) {
                        Object nextLabel;
                        Event nextToRun;
                        PerListenerQueue perListenerQueue = this;
                        synchronized (perListenerQueue) {
                            Preconditions.checkState(this.isThreadScheduled);
                            nextToRun = (Event)this.waitQueue.poll();
                            nextLabel = this.labelQueue.poll();
                            if (nextToRun == null) {
                                this.isThreadScheduled = false;
                                stillRunning = false;
                                break block18;
                            }
                        }
                        try {
                            nextToRun.call(this.listener);
                            continue block14;
                        }
                        catch (Exception e) {
                            logger.get().log(Level.SEVERE, new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.Exception while executing callback: ").append(this.listener).append((String)"org.rascalmpl.org.rascalmpl. ").append(nextLabel).toString(), (Throwable)((java.lang.Object)e));
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    if (stillRunning) {
                        PerListenerQueue perListenerQueue = this;
                        synchronized (perListenerQueue) {
                            this.isThreadScheduled = false;
                        }
                    }
                }
            }
        }
    }

    static interface Event<L extends Object> {
        public void call(L var1);
    }
}

