/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.VisibleForTesting;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Supplier;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Throwables;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Lists;
import org.rascalmpl.org.rascalmpl.com.google.common.collect.Queues;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.AbstractFuture;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.AbstractListeningExecutorService;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.Callables;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.DirectExecutor;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.DirectExecutorService;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ForwardingListenableFuture;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.Internal;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ListenableFuture;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ListenableScheduledFuture;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ListeningExecutorService;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ListeningScheduledExecutorService;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ParametricNullness;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.SequentialExecutor;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.TrustedListenableFutureTask;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.WrappingExecutorService;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.WrappingScheduledExecutorService;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.org.rascalmpl.java.lang.Class;
import org.rascalmpl.org.rascalmpl.java.lang.ClassNotFoundException;
import org.rascalmpl.org.rascalmpl.java.lang.Exception;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalAccessException;
import org.rascalmpl.org.rascalmpl.java.lang.InterruptedException;
import org.rascalmpl.org.rascalmpl.java.lang.NoSuchMethodException;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.Runnable;
import org.rascalmpl.org.rascalmpl.java.lang.Runtime;
import org.rascalmpl.org.rascalmpl.java.lang.RuntimeException;
import org.rascalmpl.org.rascalmpl.java.lang.SecurityException;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.System;
import org.rascalmpl.org.rascalmpl.java.lang.Thread;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.lang.Void;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.InvocationTargetException;
import org.rascalmpl.org.rascalmpl.java.time.Duration;
import org.rascalmpl.org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.org.rascalmpl.java.util.Collection;
import org.rascalmpl.org.rascalmpl.java.util.Iterator;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.Objects;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.BlockingQueue;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.Callable;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.Delayed;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.ExecutionException;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.Executor;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.ExecutorService;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.Executors;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.Future;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.LinkedBlockingQueue;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.RejectedExecutionException;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.ScheduledExecutorService;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.ScheduledFuture;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.ScheduledThreadPoolExecutor;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.ThreadFactory;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.ThreadPoolExecutor;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.TimeoutException;
import org.rascalmpl.org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class MoreExecutors
extends Object {
    private MoreExecutors() {
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static ExecutorService getExitingExecutorService(ThreadPoolExecutor executor, Duration terminationTimeout) {
        return MoreExecutors.getExitingExecutorService(executor, Internal.toNanosSaturated(terminationTimeout), TimeUnit.NANOSECONDS);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static ExecutorService getExitingExecutorService(ThreadPoolExecutor executor, long terminationTimeout, TimeUnit timeUnit) {
        return new Application().getExitingExecutorService(executor, terminationTimeout, timeUnit);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static ExecutorService getExitingExecutorService(ThreadPoolExecutor executor) {
        return new Application().getExitingExecutorService(executor);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static ScheduledExecutorService getExitingScheduledExecutorService(ScheduledThreadPoolExecutor executor, Duration terminationTimeout) {
        return MoreExecutors.getExitingScheduledExecutorService(executor, Internal.toNanosSaturated(terminationTimeout), TimeUnit.NANOSECONDS);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static ScheduledExecutorService getExitingScheduledExecutorService(ScheduledThreadPoolExecutor executor, long terminationTimeout, TimeUnit timeUnit) {
        return new Application().getExitingScheduledExecutorService(executor, terminationTimeout, timeUnit);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static ScheduledExecutorService getExitingScheduledExecutorService(ScheduledThreadPoolExecutor executor) {
        return new Application().getExitingScheduledExecutorService(executor);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static void addDelayedShutdownHook(ExecutorService service, Duration terminationTimeout) {
        MoreExecutors.addDelayedShutdownHook(service, Internal.toNanosSaturated(terminationTimeout), TimeUnit.NANOSECONDS);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static void addDelayedShutdownHook(ExecutorService service, long terminationTimeout, TimeUnit timeUnit) {
        new Application().addDelayedShutdownHook(service, terminationTimeout, timeUnit);
    }

    @J2ktIncompatible
    @GwtIncompatible
    private static void useDaemonThreadFactory(ThreadPoolExecutor executor) {
        executor.setThreadFactory(new ThreadFactoryBuilder().setDaemon(true).setThreadFactory(executor.getThreadFactory()).build());
    }

    @GwtIncompatible
    public static ListeningExecutorService newDirectExecutorService() {
        return new DirectExecutorService();
    }

    public static Executor directExecutor() {
        return DirectExecutor.INSTANCE;
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static Executor newSequentialExecutor(Executor delegate) {
        return new SequentialExecutor(delegate);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static ListeningExecutorService listeningDecorator(ExecutorService delegate) {
        return delegate instanceof ListeningExecutorService ? (ListeningExecutorService)delegate : (delegate instanceof ScheduledExecutorService ? new ScheduledListeningDecorator((ScheduledExecutorService)delegate) : new ListeningDecorator(delegate));
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static ListeningScheduledExecutorService listeningDecorator(ScheduledExecutorService delegate) {
        return delegate instanceof ListeningScheduledExecutorService ? (ListeningScheduledExecutorService)delegate : new ScheduledListeningDecorator(delegate);
    }

    @ParametricNullness
    @J2ktIncompatible
    @GwtIncompatible
    static <T extends Object> T invokeAnyImpl(ListeningExecutorService executorService, Collection<? extends Callable<T>> tasks, boolean timed, Duration timeout) throws InterruptedException, ExecutionException, TimeoutException {
        return MoreExecutors.invokeAnyImpl(executorService, tasks, timed, Internal.toNanosSaturated(timeout), TimeUnit.NANOSECONDS);
    }

    @ParametricNullness
    @J2ktIncompatible
    @GwtIncompatible
    static <T extends Object> T invokeAnyImpl(ListeningExecutorService executorService, Collection<? extends Callable<T>> tasks, boolean timed, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ExecutionException ee;
        ArrayList futures;
        block16: {
            Preconditions.checkNotNull(executorService);
            Preconditions.checkNotNull(unit);
            int ntasks = tasks.size();
            Preconditions.checkArgument(ntasks > 0);
            futures = Lists.newArrayListWithCapacity(ntasks);
            LinkedBlockingQueue futureQueue = Queues.newLinkedBlockingQueue();
            long timeoutNanos = unit.toNanos(timeout);
            ee = null;
            long lastTime = timed ? System.nanoTime() : 0L;
            Iterator it = tasks.iterator();
            futures.add(MoreExecutors.submitAndAddQueueListener(executorService, (Callable)it.next(), futureQueue));
            --ntasks;
            int active = 1;
            while (true) {
                Object now2;
                Future f;
                if ((f = (Future)futureQueue.poll()) == null) {
                    if (ntasks > 0) {
                        --ntasks;
                        futures.add(MoreExecutors.submitAndAddQueueListener(executorService, (Callable)it.next(), futureQueue));
                        ++active;
                    } else {
                        if (active == 0) break;
                        if (timed) {
                            f = (Future)futureQueue.poll(timeoutNanos, TimeUnit.NANOSECONDS);
                            if (f == null) {
                                throw new TimeoutException();
                            }
                            long now2 = System.nanoTime();
                            timeoutNanos -= now2 - lastTime;
                            lastTime = now2;
                        } else {
                            f = (Future)futureQueue.take();
                        }
                    }
                }
                if (f == null) continue;
                --active;
                try {
                    now2 = f.get();
                }
                catch (ExecutionException eex) {
                    ee = eex;
                    continue;
                }
                catch (InterruptedException iex) {
                    throw iex;
                }
                catch (Exception rex) {
                    ee = new ExecutionException((Throwable)((java.lang.Object)rex));
                    continue;
                }
                return (T)now2;
                break;
            }
            if (ee != null) break block16;
            ee = new ExecutionException(null);
        }
        throw ee;
        finally {
            for (Future f : futures) {
                f.cancel(true);
            }
        }
    }

    @J2ktIncompatible
    @GwtIncompatible
    private static <T extends Object> ListenableFuture<T> submitAndAddQueueListener(ListeningExecutorService executorService, Callable<T> task, final BlockingQueue<Future<T>> queue) {
        Future future = executorService.submit((Callable)task);
        future.addListener(new Runnable((ListenableFuture)future){
            final /* synthetic */ ListenableFuture val$future;
            {
                this.val$future = listenableFuture;
            }

            public void run() {
                queue.add((Object)this.val$future);
            }
        }, MoreExecutors.directExecutor());
        return future;
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static ThreadFactory platformThreadFactory() {
        if (!MoreExecutors.isAppEngineWithApiClasses()) {
            return Executors.defaultThreadFactory();
        }
        try {
            return (ThreadFactory)Class.forName((String)"org.rascalmpl.org.rascalmpl.com.google.appengine.api.ThreadManager").getMethod((String)"org.rascalmpl.org.rascalmpl.currentRequestThreadFactory", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException((String)"org.rascalmpl.org.rascalmpl.Couldn't invoke ThreadManager.currentRequestThreadFactory", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw Throwables.propagate(e.getCause());
        }
    }

    @J2ktIncompatible
    @GwtIncompatible
    private static boolean isAppEngineWithApiClasses() {
        if (System.getProperty((String)"org.rascalmpl.org.rascalmpl.com.google.appengine.runtime.environment") == null) {
            return false;
        }
        try {
            Class.forName((String)"org.rascalmpl.org.rascalmpl.com.google.appengine.api.utils.SystemProperty");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        try {
            return Class.forName((String)"org.rascalmpl.org.rascalmpl.com.google.apphosting.api.ApiProxy").getMethod((String)"org.rascalmpl.org.rascalmpl.getCurrentEnvironment", new Class[0]).invoke(null, new Object[0]) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    @J2ktIncompatible
    @GwtIncompatible
    static Thread newThread(String name, Runnable runnable) {
        Preconditions.checkNotNull(name);
        Preconditions.checkNotNull(runnable);
        Thread result = (Thread)Objects.requireNonNull((Object)MoreExecutors.platformThreadFactory().newThread(runnable));
        try {
            result.setName(name);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return result;
    }

    @J2ktIncompatible
    @GwtIncompatible
    static Executor renamingDecorator(final Executor executor, final Supplier<String> nameSupplier) {
        Preconditions.checkNotNull(executor);
        Preconditions.checkNotNull(nameSupplier);
        return new Executor(){

            public void execute(Runnable command) {
                executor.execute(Callables.threadRenaming(command, (Supplier<String>)nameSupplier));
            }
        };
    }

    @J2ktIncompatible
    @GwtIncompatible
    static ExecutorService renamingDecorator(ExecutorService service, final Supplier<String> nameSupplier) {
        Preconditions.checkNotNull(service);
        Preconditions.checkNotNull(nameSupplier);
        return new WrappingExecutorService(service){

            @Override
            protected <T extends Object> Callable<T> wrapTask(Callable<T> callable) {
                return Callables.threadRenaming(callable, (Supplier<String>)nameSupplier);
            }

            @Override
            protected Runnable wrapTask(Runnable command) {
                return Callables.threadRenaming(command, (Supplier<String>)nameSupplier);
            }
        };
    }

    @J2ktIncompatible
    @GwtIncompatible
    static ScheduledExecutorService renamingDecorator(ScheduledExecutorService service, final Supplier<String> nameSupplier) {
        Preconditions.checkNotNull(service);
        Preconditions.checkNotNull(nameSupplier);
        return new WrappingScheduledExecutorService(service){

            @Override
            protected <T extends Object> Callable<T> wrapTask(Callable<T> callable) {
                return Callables.threadRenaming(callable, (Supplier<String>)nameSupplier);
            }

            @Override
            protected Runnable wrapTask(Runnable command) {
                return Callables.threadRenaming(command, (Supplier<String>)nameSupplier);
            }
        };
    }

    @CanIgnoreReturnValue
    @J2ktIncompatible
    @GwtIncompatible
    public static boolean shutdownAndAwaitTermination(ExecutorService service, Duration timeout) {
        return MoreExecutors.shutdownAndAwaitTermination(service, Internal.toNanosSaturated(timeout), TimeUnit.NANOSECONDS);
    }

    @CanIgnoreReturnValue
    @J2ktIncompatible
    @GwtIncompatible
    public static boolean shutdownAndAwaitTermination(ExecutorService service, long timeout, TimeUnit unit) {
        long halfTimeoutNanos = unit.toNanos(timeout) / 2L;
        service.shutdown();
        try {
            if (!service.awaitTermination(halfTimeoutNanos, TimeUnit.NANOSECONDS)) {
                service.shutdownNow();
                service.awaitTermination(halfTimeoutNanos, TimeUnit.NANOSECONDS);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            service.shutdownNow();
        }
        return service.isTerminated();
    }

    static Executor rejectionPropagatingExecutor(final Executor delegate, final AbstractFuture<?> future) {
        Preconditions.checkNotNull(delegate);
        Preconditions.checkNotNull(future);
        if (delegate == MoreExecutors.directExecutor()) {
            return delegate;
        }
        return new Executor(){

            public void execute(Runnable command) {
                try {
                    delegate.execute(command);
                }
                catch (RejectedExecutionException e) {
                    future.setException((Throwable)((java.lang.Object)e));
                }
            }
        };
    }

    @J2ktIncompatible
    @GwtIncompatible
    private static final class ScheduledListeningDecorator
    extends ListeningDecorator
    implements ListeningScheduledExecutorService {
        final ScheduledExecutorService delegate;

        ScheduledListeningDecorator(ScheduledExecutorService delegate) {
            super((ExecutorService)delegate);
            this.delegate = Preconditions.checkNotNull(delegate);
        }

        @Override
        public ListenableScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            TrustedListenableFutureTask<@Nullable java.lang.Object> task = TrustedListenableFutureTask.create(command, null);
            ScheduledFuture scheduled = this.delegate.schedule(task, delay, unit);
            return new ListenableScheduledTask<java.lang.Object>(task, scheduled);
        }

        @Override
        public <V extends Object> ListenableScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            TrustedListenableFutureTask<V> task = TrustedListenableFutureTask.create(callable);
            ScheduledFuture scheduled = this.delegate.schedule(task, delay, unit);
            return new ListenableScheduledTask<V>(task, scheduled);
        }

        @Override
        public ListenableScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            NeverSuccessfulListenableFutureTask task = new NeverSuccessfulListenableFutureTask(command);
            ScheduledFuture scheduled = this.delegate.scheduleAtFixedRate((Runnable)task, initialDelay, period, unit);
            return new ListenableScheduledTask<Void>(task, scheduled);
        }

        @Override
        public ListenableScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            NeverSuccessfulListenableFutureTask task = new NeverSuccessfulListenableFutureTask(command);
            ScheduledFuture scheduled = this.delegate.scheduleWithFixedDelay((Runnable)task, initialDelay, delay, unit);
            return new ListenableScheduledTask<Void>(task, scheduled);
        }

        @J2ktIncompatible
        @GwtIncompatible
        private static final class NeverSuccessfulListenableFutureTask
        extends AbstractFuture.TrustedFuture<Void>
        implements Runnable {
            private final Runnable delegate;

            public NeverSuccessfulListenableFutureTask(Runnable delegate) {
                this.delegate = Preconditions.checkNotNull(delegate);
            }

            public void run() {
                try {
                    this.delegate.run();
                }
                catch (Throwable t2) {
                    this.setException(t2);
                    throw t2;
                }
            }

            @Override
            protected String pendingToString() {
                return new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.task=[").append((Object)this.delegate).append((String)"org.rascalmpl.org.rascalmpl.]").toString();
            }
        }

        private static final class ListenableScheduledTask<V extends @Nullable Object>
        extends ForwardingListenableFuture.SimpleForwardingListenableFuture<V>
        implements ListenableScheduledFuture<V> {
            private final ScheduledFuture<?> scheduledDelegate;

            public ListenableScheduledTask(ListenableFuture<V> listenableDelegate, ScheduledFuture<?> scheduledDelegate) {
                super(listenableDelegate);
                this.scheduledDelegate = scheduledDelegate;
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                boolean cancelled = super.cancel(mayInterruptIfRunning);
                if (cancelled) {
                    this.scheduledDelegate.cancel(mayInterruptIfRunning);
                }
                return cancelled;
            }

            public long getDelay(TimeUnit unit) {
                return this.scheduledDelegate.getDelay(unit);
            }

            public int compareTo(Delayed other) {
                return this.scheduledDelegate.compareTo((Object)other);
            }
        }
    }

    @J2ktIncompatible
    @GwtIncompatible
    private static class ListeningDecorator
    extends AbstractListeningExecutorService {
        private final ExecutorService delegate;

        ListeningDecorator(ExecutorService delegate) {
            this.delegate = Preconditions.checkNotNull(delegate);
        }

        public final boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.awaitTermination(timeout, unit);
        }

        public final boolean isShutdown() {
            return this.delegate.isShutdown();
        }

        public final boolean isTerminated() {
            return this.delegate.isTerminated();
        }

        public final void shutdown() {
            this.delegate.shutdown();
        }

        public final List<Runnable> shutdownNow() {
            return this.delegate.shutdownNow();
        }

        public final void execute(Runnable command) {
            this.delegate.execute(command);
        }

        public final String toString() {
            return new StringBuilder().append(super.toString()).append((String)"org.rascalmpl.org.rascalmpl.[").append((Object)this.delegate).append((String)"org.rascalmpl.org.rascalmpl.]").toString();
        }
    }

    @J2ktIncompatible
    @GwtIncompatible
    @VisibleForTesting
    static class Application
    extends Object {
        Application() {
        }

        final ExecutorService getExitingExecutorService(ThreadPoolExecutor executor, long terminationTimeout, TimeUnit timeUnit) {
            MoreExecutors.useDaemonThreadFactory(executor);
            ExecutorService service = Executors.unconfigurableExecutorService((ExecutorService)executor);
            this.addDelayedShutdownHook((ExecutorService)executor, terminationTimeout, timeUnit);
            return service;
        }

        final ExecutorService getExitingExecutorService(ThreadPoolExecutor executor) {
            return this.getExitingExecutorService(executor, 120L, TimeUnit.SECONDS);
        }

        final ScheduledExecutorService getExitingScheduledExecutorService(ScheduledThreadPoolExecutor executor, long terminationTimeout, TimeUnit timeUnit) {
            MoreExecutors.useDaemonThreadFactory((ThreadPoolExecutor)executor);
            ScheduledExecutorService service = Executors.unconfigurableScheduledExecutorService((ScheduledExecutorService)executor);
            this.addDelayedShutdownHook((ExecutorService)executor, terminationTimeout, timeUnit);
            return service;
        }

        final ScheduledExecutorService getExitingScheduledExecutorService(ScheduledThreadPoolExecutor executor) {
            return this.getExitingScheduledExecutorService(executor, 120L, TimeUnit.SECONDS);
        }

        final void addDelayedShutdownHook(final ExecutorService service, final long terminationTimeout, final TimeUnit timeUnit) {
            Preconditions.checkNotNull(service);
            Preconditions.checkNotNull(timeUnit);
            this.addShutdownHook(MoreExecutors.newThread(new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.DelayedShutdownHook-for-").append((Object)service).toString(), new Runnable(){

                public void run() {
                    try {
                        service.shutdown();
                        service.awaitTermination(terminationTimeout, timeUnit);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }));
        }

        @VisibleForTesting
        void addShutdownHook(Thread hook) {
            Runtime.getRuntime().addShutdownHook(hook);
        }
    }
}

