/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.FluentFuture;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.ListenableFuture;
import org.rascalmpl.org.rascalmpl.com.google.common.util.concurrent.MoreExecutors;
import org.rascalmpl.org.rascalmpl.com.google.errorprone.annotations.concurrent.LazyInit;
import org.rascalmpl.org.rascalmpl.java.lang.Math;
import org.rascalmpl.org.rascalmpl.java.lang.Runnable;
import org.rascalmpl.org.rascalmpl.java.lang.StackTraceElement;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.ScheduledExecutorService;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.ScheduledFuture;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.TimeoutException;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
final class TimeoutFuture<V extends @Nullable org.rascalmpl.org.rascalmpl.java.lang.Object>
extends FluentFuture.TrustedFuture<V> {
    @CheckForNull
    @LazyInit
    private ListenableFuture<V> delegateRef;
    @CheckForNull
    @LazyInit
    private ScheduledFuture<?> timer;

    static <V extends org.rascalmpl.org.rascalmpl.java.lang.Object> ListenableFuture<V> create(ListenableFuture<V> delegate, long time, TimeUnit unit, ScheduledExecutorService scheduledExecutor) {
        TimeoutFuture<V> result = new TimeoutFuture<V>(delegate);
        Fire<V> fire = new Fire<V>(result);
        result.timer = scheduledExecutor.schedule(fire, time, unit);
        delegate.addListener(fire, MoreExecutors.directExecutor());
        return result;
    }

    private TimeoutFuture(ListenableFuture<V> delegate) {
        this.delegateRef = Preconditions.checkNotNull(delegate);
    }

    @Override
    @CheckForNull
    protected String pendingToString() {
        ListenableFuture<V> localInputFuture = this.delegateRef;
        ScheduledFuture<?> localTimer = this.timer;
        if (localInputFuture != null) {
            long delay;
            String message = new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.inputFuture=[").append(localInputFuture).append((String)"org.rascalmpl.org.rascalmpl.]").toString();
            if (localTimer != null && (delay = localTimer.getDelay(TimeUnit.MILLISECONDS)) > 0L) {
                message = new StringBuilder().append(message).append((String)"org.rascalmpl.org.rascalmpl., remaining delay=[").append(delay).append((String)"org.rascalmpl.org.rascalmpl. ms]").toString();
            }
            return message;
        }
        return null;
    }

    @Override
    protected void afterDone() {
        this.maybePropagateCancellationTo(this.delegateRef);
        ScheduledFuture<?> localTimer = this.timer;
        if (localTimer != null) {
            localTimer.cancel(false);
        }
        this.delegateRef = null;
        this.timer = null;
    }

    private static final class TimeoutFutureException
    extends TimeoutException {
        private TimeoutFutureException(String message) {
            super(message);
        }

        public synchronized Throwable fillInStackTrace() {
            this.setStackTrace(new StackTraceElement[0]);
            return this;
        }
    }

    private static final class Fire<V extends @Nullable org.rascalmpl.org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.org.rascalmpl.java.lang.Object
    implements Runnable {
        @CheckForNull
        @LazyInit
        TimeoutFuture<V> timeoutFutureRef;

        Fire(TimeoutFuture<V> timeoutFuture) {
            this.timeoutFutureRef = timeoutFuture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            TimeoutFuture<V> timeoutFuture = this.timeoutFutureRef;
            if (timeoutFuture == null) {
                return;
            }
            ListenableFuture delegate = ((TimeoutFuture)timeoutFuture).delegateRef;
            if (delegate == null) {
                return;
            }
            this.timeoutFutureRef = null;
            if (delegate.isDone()) {
                timeoutFuture.setFuture(delegate);
            } else {
                try {
                    ScheduledFuture timer = ((TimeoutFuture)timeoutFuture).timer;
                    ((TimeoutFuture)timeoutFuture).timer = null;
                    java.lang.String message = "org.rascalmpl.org.rascalmpl.Timed out";
                    try {
                        long overDelayMs;
                        if (timer != null && (overDelayMs = Math.abs((long)timer.getDelay(TimeUnit.MILLISECONDS))) > 10L) {
                            message = new StringBuilder().append((String)message).append((String)"org.rascalmpl.org.rascalmpl. (timeout delayed by ").append(overDelayMs).append((String)"org.rascalmpl.org.rascalmpl. ms after scheduled time)").toString();
                        }
                        message = new StringBuilder().append((String)message).append((String)"org.rascalmpl.org.rascalmpl.: ").append((org.rascalmpl.org.rascalmpl.java.lang.Object)delegate).toString();
                    }
                    finally {
                        timeoutFuture.setException((Throwable)((Object)new TimeoutFutureException((String)message)));
                    }
                }
                finally {
                    delegate.cancel(true);
                }
            }
        }
    }
}

