/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.com.google.common.xml;

import org.rascalmpl.org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.org.rascalmpl.com.google.common.escape.Escaper;
import org.rascalmpl.org.rascalmpl.com.google.common.escape.Escapers;
import org.rascalmpl.org.rascalmpl.com.google.common.xml.ElementTypesAreNonnullByDefault;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public class XmlEscapers
extends Object {
    private static final char MIN_ASCII_CONTROL_CHAR = '\u0000';
    private static final char MAX_ASCII_CONTROL_CHAR = '\u001f';
    private static final Escaper XML_ESCAPER;
    private static final Escaper XML_CONTENT_ESCAPER;
    private static final Escaper XML_ATTRIBUTE_ESCAPER;

    private XmlEscapers() {
    }

    public static Escaper xmlContentEscaper() {
        return XML_CONTENT_ESCAPER;
    }

    public static Escaper xmlAttributeEscaper() {
        return XML_ATTRIBUTE_ESCAPER;
    }

    static {
        Escapers.Builder builder = Escapers.builder();
        builder.setSafeRange('\u0000', '\ufffd');
        builder.setUnsafeReplacement((String)"org.rascalmpl.org.rascalmpl.\ufffd");
        for (char c = '\u0000'; c <= '\u001f'; c = (char)((char)(c + 1))) {
            if (c == 9 || c == 10 || c == 13) continue;
            builder.addEscape(c, (String)"org.rascalmpl.org.rascalmpl.\ufffd");
        }
        builder.addEscape('&', (String)"org.rascalmpl.org.rascalmpl.&amp;");
        builder.addEscape('<', (String)"org.rascalmpl.org.rascalmpl.&lt;");
        builder.addEscape('>', (String)"org.rascalmpl.org.rascalmpl.&gt;");
        XML_CONTENT_ESCAPER = builder.build();
        builder.addEscape('\'', (String)"org.rascalmpl.org.rascalmpl.&apos;");
        builder.addEscape('\"', (String)"org.rascalmpl.org.rascalmpl.&quot;");
        XML_ESCAPER = builder.build();
        builder.addEscape('\t', (String)"org.rascalmpl.org.rascalmpl.&#x9;");
        builder.addEscape('\n', (String)"org.rascalmpl.org.rascalmpl.&#xA;");
        builder.addEscape('\r', (String)"org.rascalmpl.org.rascalmpl.&#xD;");
        XML_ATTRIBUTE_ESCAPER = builder.build();
    }
}

