/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.dev.failsafe;

import org.rascalmpl.org.rascalmpl.dev.failsafe.CircuitBreaker;
import org.rascalmpl.org.rascalmpl.dev.failsafe.CircuitBreakerConfig;
import org.rascalmpl.org.rascalmpl.dev.failsafe.DelayablePolicyBuilder;
import org.rascalmpl.org.rascalmpl.dev.failsafe.PolicyListeners;
import org.rascalmpl.org.rascalmpl.dev.failsafe.event.CircuitBreakerStateChangedEvent;
import org.rascalmpl.org.rascalmpl.dev.failsafe.event.EventListener;
import org.rascalmpl.org.rascalmpl.dev.failsafe.internal.CircuitBreakerImpl;
import org.rascalmpl.org.rascalmpl.dev.failsafe.internal.util.Assert;
import org.rascalmpl.org.rascalmpl.dev.failsafe.internal.util.Durations;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.time.Duration;

public class CircuitBreakerBuilder<R extends Object>
extends DelayablePolicyBuilder<CircuitBreakerBuilder<R>, CircuitBreakerConfig<R>, R>
implements PolicyListeners<CircuitBreakerBuilder<R>, R> {
    CircuitBreakerBuilder() {
        super(new CircuitBreakerConfig());
        ((CircuitBreakerConfig)this.config).delay = Duration.ofMinutes((long)1L);
        ((CircuitBreakerConfig)this.config).failureThreshold = 1;
        ((CircuitBreakerConfig)this.config).failureThresholdingCapacity = 1;
    }

    CircuitBreakerBuilder(CircuitBreakerConfig<R> config) {
        super(new CircuitBreakerConfig<R>(config));
    }

    public CircuitBreaker<R> build() {
        return new CircuitBreakerImpl(new CircuitBreakerConfig((CircuitBreakerConfig)this.config));
    }

    public CircuitBreakerBuilder<R> onClose(EventListener<CircuitBreakerStateChangedEvent> listener) {
        ((CircuitBreakerConfig)this.config).closeListener = Assert.notNull(listener, (String)"org.rascalmpl.org.rascalmpl.runnable");
        return this;
    }

    public CircuitBreakerBuilder<R> onHalfOpen(EventListener<CircuitBreakerStateChangedEvent> listener) {
        ((CircuitBreakerConfig)this.config).halfOpenListener = Assert.notNull(listener, (String)"org.rascalmpl.org.rascalmpl.runnable");
        return this;
    }

    public CircuitBreakerBuilder<R> onOpen(EventListener<CircuitBreakerStateChangedEvent> listener) {
        ((CircuitBreakerConfig)this.config).openListener = Assert.notNull(listener, (String)"org.rascalmpl.org.rascalmpl.listener");
        return this;
    }

    @Override
    public CircuitBreakerBuilder<R> withDelay(Duration delay) {
        Assert.notNull(delay, (String)"org.rascalmpl.org.rascalmpl.delay");
        delay = Durations.ofSafeNanos(delay);
        Assert.isTrue(delay.toNanos() >= 0L, (String)"org.rascalmpl.org.rascalmpl.delay must be >= 0", new Object[0]);
        ((CircuitBreakerConfig)this.config).delay = delay;
        return this;
    }

    public CircuitBreakerBuilder<R> withFailureThreshold(int failureThreshold) {
        return this.withFailureThreshold(failureThreshold, failureThreshold);
    }

    public CircuitBreakerBuilder<R> withFailureThreshold(int failureThreshold, int failureThresholdingCapacity) {
        Assert.isTrue(failureThreshold >= 1, (String)"org.rascalmpl.org.rascalmpl.failureThreshold must be >= 1", new Object[0]);
        Assert.isTrue(failureThresholdingCapacity >= 1, (String)"org.rascalmpl.org.rascalmpl.failureThresholdingCapacity must be >= 1", new Object[0]);
        Assert.isTrue(failureThresholdingCapacity >= failureThreshold, (String)"org.rascalmpl.org.rascalmpl.failureThresholdingCapacity must be >= failureThreshold", new Object[0]);
        ((CircuitBreakerConfig)this.config).failureThreshold = failureThreshold;
        ((CircuitBreakerConfig)this.config).failureThresholdingCapacity = failureThresholdingCapacity;
        return this;
    }

    public CircuitBreakerBuilder<R> withFailureThreshold(int failureThreshold, Duration failureThresholdingPeriod) {
        return this.withFailureThreshold(failureThreshold, failureThreshold, failureThresholdingPeriod);
    }

    public CircuitBreakerBuilder<R> withFailureThreshold(int failureThreshold, int failureExecutionThreshold, Duration failureThresholdingPeriod) {
        Assert.isTrue(failureThreshold >= 1, (String)"org.rascalmpl.org.rascalmpl.failureThreshold must be >= 1", new Object[0]);
        Assert.isTrue(failureExecutionThreshold >= failureThreshold, (String)"org.rascalmpl.org.rascalmpl.failureExecutionThreshold must be >= failureThreshold", new Object[0]);
        this.assertFailureExecutionThreshold(failureExecutionThreshold);
        this.assertFailureThresholdingPeriod(failureThresholdingPeriod);
        ((CircuitBreakerConfig)this.config).failureThreshold = failureThreshold;
        ((CircuitBreakerConfig)this.config).failureThresholdingCapacity = failureThreshold;
        ((CircuitBreakerConfig)this.config).failureExecutionThreshold = failureExecutionThreshold;
        ((CircuitBreakerConfig)this.config).failureThresholdingPeriod = failureThresholdingPeriod;
        return this;
    }

    public CircuitBreakerBuilder<R> withFailureRateThreshold(int failureRateThreshold, int failureExecutionThreshold, Duration failureThresholdingPeriod) {
        Assert.isTrue(failureRateThreshold >= 1 && failureRateThreshold <= 100, (String)"org.rascalmpl.org.rascalmpl.failureRateThreshold must be between 1 and 100", new Object[0]);
        this.assertFailureExecutionThreshold(failureExecutionThreshold);
        this.assertFailureThresholdingPeriod(failureThresholdingPeriod);
        ((CircuitBreakerConfig)this.config).failureRateThreshold = failureRateThreshold;
        ((CircuitBreakerConfig)this.config).failureExecutionThreshold = failureExecutionThreshold;
        ((CircuitBreakerConfig)this.config).failureThresholdingPeriod = failureThresholdingPeriod;
        return this;
    }

    private void assertFailureExecutionThreshold(int failureExecutionThreshold) {
        Assert.isTrue(failureExecutionThreshold >= 1, (String)"org.rascalmpl.org.rascalmpl.failureExecutionThreshold must be >= 1", new Object[0]);
    }

    private void assertFailureThresholdingPeriod(Duration failureThresholdingPeriod) {
        Assert.notNull(failureThresholdingPeriod, (String)"org.rascalmpl.org.rascalmpl.failureThresholdingPeriod");
        Assert.isTrue(failureThresholdingPeriod.toMillis() >= 10L, (String)"org.rascalmpl.org.rascalmpl.failureThresholdingPeriod must be >= 10 ms", new Object[0]);
    }

    public CircuitBreakerBuilder<R> withSuccessThreshold(int successThreshold) {
        return this.withSuccessThreshold(successThreshold, successThreshold);
    }

    public CircuitBreakerBuilder<R> withSuccessThreshold(int successThreshold, int successThresholdingCapacity) {
        Assert.isTrue(successThreshold >= 1, (String)"org.rascalmpl.org.rascalmpl.successThreshold must be >= 1", new Object[0]);
        Assert.isTrue(successThresholdingCapacity >= 1, (String)"org.rascalmpl.org.rascalmpl.successThresholdingCapacity must be >= 1", new Object[0]);
        Assert.isTrue(successThresholdingCapacity >= successThreshold, (String)"org.rascalmpl.org.rascalmpl.successThresholdingCapacity must be >= successThreshold", new Object[0]);
        ((CircuitBreakerConfig)this.config).successThreshold = successThreshold;
        ((CircuitBreakerConfig)this.config).successThresholdingCapacity = successThresholdingCapacity;
        return this;
    }
}

