/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.dev.failsafe;

import org.rascalmpl.org.rascalmpl.dev.failsafe.PolicyBuilder;
import org.rascalmpl.org.rascalmpl.dev.failsafe.RateLimiter;
import org.rascalmpl.org.rascalmpl.dev.failsafe.RateLimiterConfig;
import org.rascalmpl.org.rascalmpl.dev.failsafe.internal.RateLimiterImpl;
import org.rascalmpl.org.rascalmpl.dev.failsafe.internal.util.Assert;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.time.Duration;

public class RateLimiterBuilder<R extends Object>
extends PolicyBuilder<RateLimiterBuilder<R>, RateLimiterConfig<R>, R> {
    RateLimiterBuilder(Duration executionRate) {
        super(new RateLimiterConfig(executionRate));
        ((RateLimiterConfig)this.config).maxWaitTime = Duration.ZERO;
    }

    RateLimiterBuilder(long maxPermits, Duration period) {
        super(new RateLimiterConfig(maxPermits, period));
        ((RateLimiterConfig)this.config).maxWaitTime = Duration.ZERO;
    }

    RateLimiterBuilder(RateLimiterConfig<R> config) {
        super(new RateLimiterConfig<R>(config));
    }

    public RateLimiter<R> build() {
        return new RateLimiterImpl(new RateLimiterConfig((RateLimiterConfig)this.config));
    }

    public RateLimiterBuilder<R> withMaxWaitTime(Duration maxWaitTime) {
        ((RateLimiterConfig)this.config).maxWaitTime = Assert.notNull(maxWaitTime, (String)"org.rascalmpl.org.rascalmpl.maxWaitTime");
        return this;
    }
}

