/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.dev.failsafe.internal;

import org.rascalmpl.org.rascalmpl.dev.failsafe.CircuitBreaker;
import org.rascalmpl.org.rascalmpl.dev.failsafe.CircuitBreakerConfig;
import org.rascalmpl.org.rascalmpl.dev.failsafe.ExecutionContext;
import org.rascalmpl.org.rascalmpl.dev.failsafe.internal.CircuitBreakerImpl;
import org.rascalmpl.org.rascalmpl.dev.failsafe.internal.CircuitStats;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.time.Duration;

abstract class CircuitState<R extends Object>
extends Object {
    final CircuitBreakerImpl<R> breaker;
    final CircuitBreakerConfig<R> config;
    volatile CircuitStats stats;

    CircuitState(CircuitBreakerImpl<R> breaker, CircuitStats stats) {
        this.breaker = breaker;
        this.config = breaker.getConfig();
        this.stats = stats;
    }

    public Duration getRemainingDelay() {
        return Duration.ZERO;
    }

    public CircuitStats getStats() {
        return this.stats;
    }

    public abstract CircuitBreaker.State getState();

    public synchronized void recordFailure(ExecutionContext<R> context) {
        this.stats.recordFailure();
        this.checkThreshold(context);
        this.releasePermit();
    }

    public synchronized void recordSuccess() {
        this.stats.recordSuccess();
        this.checkThreshold(null);
        this.releasePermit();
    }

    public void handleConfigChange() {
    }

    void checkThreshold(ExecutionContext<R> context) {
    }

    abstract boolean tryAcquirePermit();

    void releasePermit() {
    }
}

