/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.dev.failsafe.internal;

import org.rascalmpl.org.rascalmpl.dev.failsafe.CircuitBreaker;
import org.rascalmpl.org.rascalmpl.dev.failsafe.internal.CircuitBreakerImpl;
import org.rascalmpl.org.rascalmpl.dev.failsafe.internal.CircuitState;
import org.rascalmpl.org.rascalmpl.java.lang.Math;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.System;
import org.rascalmpl.org.rascalmpl.java.time.Duration;

class OpenState<R extends Object>
extends CircuitState<R> {
    private final long startTime = System.nanoTime();
    private final long delayNanos;

    public OpenState(CircuitBreakerImpl<R> breaker, CircuitState<R> previousState, Duration delay) {
        super(breaker, previousState.stats);
        this.delayNanos = delay.toNanos();
    }

    @Override
    public boolean tryAcquirePermit() {
        if (System.nanoTime() - this.startTime >= this.delayNanos) {
            this.breaker.halfOpen();
            return this.breaker.tryAcquirePermit();
        }
        return false;
    }

    @Override
    public Duration getRemainingDelay() {
        long elapsedTime = System.nanoTime() - this.startTime;
        long remainingDelay = this.delayNanos - elapsedTime;
        return Duration.ofNanos((long)Math.max((long)remainingDelay, (long)0L));
    }

    @Override
    public CircuitBreaker.State getState() {
        return CircuitBreaker.State.OPEN;
    }
}

