/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.dev.failsafe.internal;

import org.rascalmpl.org.rascalmpl.dev.failsafe.RetryPolicy;
import org.rascalmpl.org.rascalmpl.dev.failsafe.RetryPolicyConfig;
import org.rascalmpl.org.rascalmpl.dev.failsafe.function.CheckedBiPredicate;
import org.rascalmpl.org.rascalmpl.dev.failsafe.internal.RetryPolicyExecutor;
import org.rascalmpl.org.rascalmpl.dev.failsafe.spi.DelayablePolicy;
import org.rascalmpl.org.rascalmpl.dev.failsafe.spi.FailurePolicy;
import org.rascalmpl.org.rascalmpl.dev.failsafe.spi.PolicyExecutor;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;

public class RetryPolicyImpl<R extends Object>
extends Object
implements RetryPolicy<R>,
FailurePolicy<R>,
DelayablePolicy<R> {
    private final RetryPolicyConfig<R> config;

    public RetryPolicyImpl(RetryPolicyConfig<R> config) {
        this.config = config;
    }

    @Override
    public RetryPolicyConfig<R> getConfig() {
        return this.config;
    }

    public boolean isAbortable(R result, Throwable failure) {
        for (CheckedBiPredicate predicate : this.config.getAbortConditions()) {
            try {
                if (!predicate.test(result, failure)) continue;
                return true;
            }
            catch (Throwable throwable) {
            }
        }
        return false;
    }

    @Override
    public PolicyExecutor<R> toExecutor(int policyIndex) {
        return new RetryPolicyExecutor(this, policyIndex);
    }
}

