/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.api;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.OpenTelemetry;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.internal.ConfigUtil;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.logs.LoggerProvider;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.metrics.Meter;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.metrics.MeterBuilder;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.metrics.MeterProvider;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.trace.Tracer;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.trace.TracerBuilder;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.trace.TracerProvider;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.context.propagation.ContextPropagators;
import org.rascalmpl.org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.org.rascalmpl.java.lang.Class;
import org.rascalmpl.org.rascalmpl.java.lang.ClassNotFoundException;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalAccessException;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.org.rascalmpl.java.lang.NoSuchMethodException;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.InvocationTargetException;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.Method;
import org.rascalmpl.org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.org.rascalmpl.java.util.logging.Logger;
import org.rascalmpl.org.rascalmpl.javax.annotation.Nullable;
import org.rascalmpl.org.rascalmpl.javax.annotation.concurrent.ThreadSafe;

public final class GlobalOpenTelemetry
extends org.rascalmpl.org.rascalmpl.java.lang.Object {
    private static final String GLOBAL_AUTOCONFIGURE_ENABLED_PROPERTY = "org.rascalmpl.org.rascalmpl.otel.java.global-autoconfigure.enabled";
    private static final Logger logger = Logger.getLogger((String)GlobalOpenTelemetry.class.getName());
    private static final org.rascalmpl.org.rascalmpl.java.lang.Object mutex = new org.rascalmpl.org.rascalmpl.java.lang.Object();
    @Nullable
    private static volatile ObfuscatedOpenTelemetry globalOpenTelemetry;
    @Nullable
    private static Throwable setGlobalCaller;

    private GlobalOpenTelemetry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenTelemetry get() {
        ObfuscatedOpenTelemetry openTelemetry = globalOpenTelemetry;
        if (openTelemetry == null) {
            org.rascalmpl.org.rascalmpl.java.lang.Object object = mutex;
            synchronized (object) {
                openTelemetry = globalOpenTelemetry;
                if (openTelemetry == null) {
                    OpenTelemetry autoConfigured = GlobalOpenTelemetry.maybeAutoConfigureAndSetGlobal();
                    if (autoConfigured != null) {
                        return autoConfigured;
                    }
                    GlobalOpenTelemetry.set(OpenTelemetry.noop());
                    return OpenTelemetry.noop();
                }
            }
        }
        return openTelemetry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set(OpenTelemetry openTelemetry) {
        org.rascalmpl.org.rascalmpl.java.lang.Object object = mutex;
        synchronized (object) {
            if (globalOpenTelemetry != null) {
                throw new IllegalStateException((String)"org.rascalmpl.org.rascalmpl.GlobalOpenTelemetry.set has already been called. GlobalOpenTelemetry.set must be called only once before any calls to GlobalOpenTelemetry.get. If you are using the OpenTelemetrySdk, use OpenTelemetrySdkBuilder.buildAndRegisterGlobal instead. Previous invocation set to cause of this exception.", setGlobalCaller);
            }
            globalOpenTelemetry = new ObfuscatedOpenTelemetry(openTelemetry);
            setGlobalCaller = new Throwable();
        }
    }

    public static TracerProvider getTracerProvider() {
        return GlobalOpenTelemetry.get().getTracerProvider();
    }

    public static Tracer getTracer(String instrumentationScopeName) {
        return GlobalOpenTelemetry.get().getTracer(instrumentationScopeName);
    }

    public static Tracer getTracer(String instrumentationScopeName, String instrumentationScopeVersion) {
        return GlobalOpenTelemetry.get().getTracer(instrumentationScopeName, instrumentationScopeVersion);
    }

    public static TracerBuilder tracerBuilder(String instrumentationScopeName) {
        return GlobalOpenTelemetry.get().tracerBuilder(instrumentationScopeName);
    }

    public static MeterProvider getMeterProvider() {
        return GlobalOpenTelemetry.get().getMeterProvider();
    }

    public static Meter getMeter(String instrumentationScopeName) {
        return GlobalOpenTelemetry.get().getMeter(instrumentationScopeName);
    }

    public static MeterBuilder meterBuilder(String instrumentationScopeName) {
        return GlobalOpenTelemetry.get().meterBuilder(instrumentationScopeName);
    }

    public static void resetForTest() {
        globalOpenTelemetry = null;
    }

    public static ContextPropagators getPropagators() {
        return GlobalOpenTelemetry.get().getPropagators();
    }

    @Nullable
    private static OpenTelemetry maybeAutoConfigureAndSetGlobal() {
        Class openTelemetrySdkAutoConfiguration;
        try {
            openTelemetrySdkAutoConfiguration = Class.forName((String)"org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        boolean globalAutoconfigureEnabled = Boolean.parseBoolean((String)ConfigUtil.getString((String)"org.rascalmpl.org.rascalmpl.otel.java.global-autoconfigure.enabled", (String)"org.rascalmpl.org.rascalmpl.false"));
        if (!globalAutoconfigureEnabled) {
            logger.log(Level.INFO, (String)"org.rascalmpl.org.rascalmpl.AutoConfiguredOpenTelemetrySdk found on classpath but automatic configuration is disabled. To enable, run your JVM with -Dotel.java.global-autoconfigure.enabled=true");
            return null;
        }
        try {
            Method initialize = openTelemetrySdkAutoConfiguration.getMethod((String)"org.rascalmpl.org.rascalmpl.initialize", new Class[0]);
            org.rascalmpl.org.rascalmpl.java.lang.Object autoConfiguredSdk = initialize.invoke(null, new org.rascalmpl.org.rascalmpl.java.lang.Object[0]);
            Method getOpenTelemetrySdk = openTelemetrySdkAutoConfiguration.getMethod((String)"org.rascalmpl.org.rascalmpl.getOpenTelemetrySdk", new Class[0]);
            return new ObfuscatedOpenTelemetry((OpenTelemetry)getOpenTelemetrySdk.invoke(autoConfiguredSdk, new org.rascalmpl.org.rascalmpl.java.lang.Object[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalStateException((String)"org.rascalmpl.org.rascalmpl.AutoConfiguredOpenTelemetrySdk detected on classpath but could not invoke initialize method. This is a bug in OpenTelemetry.", (Throwable)e);
        }
        catch (InvocationTargetException t2) {
            logger.log(Level.SEVERE, (String)"org.rascalmpl.org.rascalmpl.Error automatically configuring OpenTelemetry SDK. OpenTelemetry will not be enabled.", t2.getTargetException());
            return null;
        }
    }

    @ThreadSafe
    static class ObfuscatedOpenTelemetry
    extends org.rascalmpl.org.rascalmpl.java.lang.Object
    implements OpenTelemetry {
        private final OpenTelemetry delegate;

        ObfuscatedOpenTelemetry(OpenTelemetry delegate) {
            this.delegate = delegate;
        }

        @Override
        public TracerProvider getTracerProvider() {
            return this.delegate.getTracerProvider();
        }

        @Override
        public MeterProvider getMeterProvider() {
            return this.delegate.getMeterProvider();
        }

        @Override
        public LoggerProvider getLogsBridge() {
            return this.delegate.getLogsBridge();
        }

        @Override
        public ContextPropagators getPropagators() {
            return this.delegate.getPropagators();
        }

        @Override
        public TracerBuilder tracerBuilder(String instrumentationScopeName) {
            return this.delegate.tracerBuilder(instrumentationScopeName);
        }
    }
}

