/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.api.baggage;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.baggage.Baggage;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.baggage.BaggageBuilder;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.baggage.BaggageEntry;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.baggage.BaggageEntryMetadata;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.baggage.ImmutableEntry;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.internal.ImmutableKeyValuePairs;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.org.rascalmpl.java.util.Comparator;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.javax.annotation.Nullable;
import org.rascalmpl.org.rascalmpl.javax.annotation.concurrent.Immutable;

@Immutable
final class ImmutableBaggage
extends ImmutableKeyValuePairs<String, BaggageEntry>
implements Baggage {
    private static final Baggage EMPTY = new Builder().build();

    private ImmutableBaggage(Object[] data) {
        super(data, Comparator.naturalOrder());
    }

    static Baggage empty() {
        return EMPTY;
    }

    static BaggageBuilder builder() {
        return new Builder();
    }

    @Override
    @Nullable
    public String getEntryValue(String entryKey) {
        BaggageEntry entry = (BaggageEntry)((java.lang.Object)this.get(entryKey));
        return entry != null ? entry.getValue() : null;
    }

    @Override
    public BaggageBuilder toBuilder() {
        return new Builder((List<Object>)new ArrayList(this.data()));
    }

    private static Baggage sortAndFilterToBaggage(Object[] data) {
        return new ImmutableBaggage(data);
    }

    static class Builder
    extends Object
    implements BaggageBuilder {
        private final List<Object> data;

        Builder() {
            this.data = new ArrayList();
        }

        Builder(List<Object> data) {
            this.data = data;
        }

        @Override
        public BaggageBuilder put(String key, String value, BaggageEntryMetadata entryMetadata) {
            if (key == null || value == null || entryMetadata == null) {
                return this;
            }
            this.data.add((Object)key);
            this.data.add((Object)ImmutableEntry.create(value, entryMetadata));
            return this;
        }

        @Override
        public BaggageBuilder remove(String key) {
            if (key == null) {
                return this;
            }
            this.data.add((Object)key);
            this.data.add(null);
            return this;
        }

        @Override
        public Baggage build() {
            return ImmutableBaggage.sortAndFilterToBaggage(this.data.toArray());
        }
    }
}

