/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.api.baggage.propagation;

import org.rascalmpl.org.rascalmpl.java.io.ByteArrayOutputStream;
import org.rascalmpl.org.rascalmpl.java.lang.ArrayIndexOutOfBoundsException;
import org.rascalmpl.org.rascalmpl.java.lang.Character;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.nio.charset.Charset;
import org.rascalmpl.org.rascalmpl.java.nio.charset.StandardCharsets;

class BaggageCodec
extends Object {
    private static final byte ESCAPE_CHAR = 37;
    private static final int RADIX = 16;

    private BaggageCodec() {
    }

    private static byte[] decode(byte[] bytes) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (b == 37) {
                try {
                    int u = BaggageCodec.digit16(bytes[++i]);
                    int l = BaggageCodec.digit16(bytes[++i]);
                    buffer.write((int)((char)((u << 4) + l)));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new IllegalArgumentException((String)"org.rascalmpl.org.rascalmpl.Invalid URL encoding: ", (Throwable)((java.lang.Object)e));
                }
            }
            buffer.write((int)b);
        }
        return buffer.toByteArray();
    }

    static String decode(String value, Charset charset) {
        byte[] bytes = BaggageCodec.decode(value.getBytes(StandardCharsets.US_ASCII));
        return new String(bytes, charset);
    }

    private static int digit16(byte b) {
        int i = Character.digit((char)((char)b), (int)16);
        if (i == -1) {
            throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.Invalid URL encoding: not a valid digit (radix 16): ").append((int)b).toString());
        }
        return i;
    }
}

