/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.api.common;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.common.AttributeType;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.internal.InternalAttributeKeyImpl;
import org.rascalmpl.org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.org.rascalmpl.java.lang.Double;
import org.rascalmpl.org.rascalmpl.java.lang.Long;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.javax.annotation.concurrent.Immutable;

@Immutable
public interface AttributeKey<T extends Object> {
    public String getKey();

    public AttributeType getType();

    public static AttributeKey<String> stringKey(String key) {
        return InternalAttributeKeyImpl.create(key, AttributeType.STRING);
    }

    public static AttributeKey<Boolean> booleanKey(String key) {
        return InternalAttributeKeyImpl.create(key, AttributeType.BOOLEAN);
    }

    public static AttributeKey<Long> longKey(String key) {
        return InternalAttributeKeyImpl.create(key, AttributeType.LONG);
    }

    public static AttributeKey<Double> doubleKey(String key) {
        return InternalAttributeKeyImpl.create(key, AttributeType.DOUBLE);
    }

    public static AttributeKey<List<String>> stringArrayKey(String key) {
        return InternalAttributeKeyImpl.create(key, AttributeType.STRING_ARRAY);
    }

    public static AttributeKey<List<Boolean>> booleanArrayKey(String key) {
        return InternalAttributeKeyImpl.create(key, AttributeType.BOOLEAN_ARRAY);
    }

    public static AttributeKey<List<Long>> longArrayKey(String key) {
        return InternalAttributeKeyImpl.create(key, AttributeType.LONG_ARRAY);
    }

    public static AttributeKey<List<Double>> doubleArrayKey(String key) {
        return InternalAttributeKeyImpl.create(key, AttributeType.DOUBLE_ARRAY);
    }
}

