/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.api.common;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.common.ArrayBackedAttributesBuilder;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.common.AttributeKey;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.common.Attributes;
import org.rascalmpl.org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.org.rascalmpl.java.lang.Double;
import org.rascalmpl.org.rascalmpl.java.lang.Long;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.util.Arrays;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.function.Predicate;

public interface AttributesBuilder {
    public Attributes build();

    public <T extends Object> AttributesBuilder put(AttributeKey<Long> var1, int var2);

    public <T extends Object> AttributesBuilder put(AttributeKey<T> var1, T var2);

    default public AttributesBuilder put(String key, String value) {
        return this.put(AttributeKey.stringKey(key), (Object)value);
    }

    default public AttributesBuilder put(String key, long value) {
        return this.put((AttributeKey)AttributeKey.longKey(key), (Object)Long.valueOf((long)value));
    }

    default public AttributesBuilder put(String key, double value) {
        return this.put(AttributeKey.doubleKey(key), (Object)Double.valueOf((double)value));
    }

    default public AttributesBuilder put(String key, boolean value) {
        return this.put(AttributeKey.booleanKey(key), (Object)Boolean.valueOf((boolean)value));
    }

    default public AttributesBuilder put(String key, String ... value) {
        if (value == null) {
            return this;
        }
        return this.put(AttributeKey.stringArrayKey(key), (Object)Arrays.asList((Object[])value));
    }

    default public <T extends Object> AttributesBuilder put(AttributeKey<List<T>> key, T ... value) {
        if (value == null) {
            return this;
        }
        return this.put((AttributeKey<T>)key, (T)Arrays.asList(value));
    }

    default public AttributesBuilder put(String key, long ... value) {
        if (value == null) {
            return this;
        }
        return this.put(AttributeKey.longArrayKey(key), (Object)ArrayBackedAttributesBuilder.toList(value));
    }

    default public AttributesBuilder put(String key, double ... value) {
        if (value == null) {
            return this;
        }
        return this.put(AttributeKey.doubleArrayKey(key), (Object)ArrayBackedAttributesBuilder.toList(value));
    }

    default public AttributesBuilder put(String key, boolean ... value) {
        if (value == null) {
            return this;
        }
        return this.put(AttributeKey.booleanArrayKey(key), (Object)ArrayBackedAttributesBuilder.toList(value));
    }

    public AttributesBuilder putAll(Attributes var1);

    default public <T extends Object> AttributesBuilder remove(AttributeKey<T> key) {
        return this;
    }

    default public AttributesBuilder removeIf(Predicate<AttributeKey<?>> filter) {
        return this;
    }
}

