/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.api.internal;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.internal.TemporaryBuffers;
import org.rascalmpl.org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.org.rascalmpl.java.lang.Character;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.org.rascalmpl.java.lang.IndexOutOfBoundsException;
import org.rascalmpl.org.rascalmpl.java.lang.Math;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.System;
import org.rascalmpl.org.rascalmpl.javax.annotation.CheckForNull;

public final class PercentEscaper
extends Object {
    private static final int DEST_PAD = 32;
    private static final String SAFE_CHARS = "org.rascalmpl.org.rascalmpl.-._~!$'()*&@:abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final char[] UPPER_HEX_DIGITS = "org.rascalmpl.org.rascalmpl.0123456789ABCDEF".toCharArray();
    private static final boolean[] safeOctets = PercentEscaper.createSafeOctets((String)"org.rascalmpl.org.rascalmpl.-._~!$'()*&@:abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789");

    public static PercentEscaper create() {
        return new PercentEscaper();
    }

    private static boolean[] createSafeOctets(String safeChars) {
        char[] safeCharArray;
        int maxChar = -1;
        for (char c : safeCharArray = safeChars.toCharArray()) {
            maxChar = Math.max((int)c, (int)maxChar);
        }
        boolean[] octets = new boolean[maxChar + 1];
        for (char c : safeCharArray) {
            octets[c] = true;
        }
        return octets;
    }

    public String escape(String s2) {
        int slen = s2.length();
        for (int index = 0; index < slen; ++index) {
            char c = s2.charAt(index);
            if (c < safeOctets.length && safeOctets[c]) continue;
            return PercentEscaper.escapeSlow(s2, index);
        }
        return s2;
    }

    private static String escapeSlow(String s2, int index) {
        int end = s2.length();
        char[] dest = TemporaryBuffers.chars(1024);
        int destIndex = 0;
        int unescapedChunkStart = 0;
        while (index < end) {
            int cp = PercentEscaper.codePointAt((CharSequence)s2, index, end);
            if (cp < 0) {
                throw new IllegalArgumentException((String)"org.rascalmpl.org.rascalmpl.Trailing high surrogate at end of input");
            }
            char[] escaped = PercentEscaper.escape(cp);
            int nextIndex = index + (Character.isSupplementaryCodePoint((int)cp) ? 2 : 1);
            if (escaped != null) {
                int charsSkipped = index - unescapedChunkStart;
                int sizeNeeded = destIndex + charsSkipped + escaped.length;
                if (dest.length < sizeNeeded) {
                    int destLength = sizeNeeded + (end - index) + 32;
                    dest = PercentEscaper.growBuffer(dest, destIndex, destLength);
                }
                if (charsSkipped > 0) {
                    s2.getChars(unescapedChunkStart, index, dest, destIndex);
                    destIndex += charsSkipped;
                }
                if (escaped.length > 0) {
                    System.arraycopy((Object)escaped, (int)0, (Object)dest, (int)destIndex, (int)escaped.length);
                    destIndex += escaped.length;
                }
                unescapedChunkStart = nextIndex;
            }
            index = PercentEscaper.nextEscapeIndex((CharSequence)s2, nextIndex, end);
        }
        int charsSkipped = end - unescapedChunkStart;
        if (charsSkipped > 0) {
            int endIndex = destIndex + charsSkipped;
            if (dest.length < endIndex) {
                dest = PercentEscaper.growBuffer(dest, destIndex, endIndex);
            }
            s2.getChars(unescapedChunkStart, end, dest, destIndex);
            destIndex = endIndex;
        }
        return new String(dest, 0, destIndex);
    }

    private static int nextEscapeIndex(CharSequence csq, int index, int end) {
        char c;
        while (index < end && (c = csq.charAt(index)) < safeOctets.length && safeOctets[c]) {
            ++index;
        }
        return index;
    }

    @CheckForNull
    private static char[] escape(int cp) {
        if (cp < safeOctets.length && safeOctets[cp]) {
            return null;
        }
        if (cp <= 127) {
            char[] dest = new char[3];
            dest[0] = 37;
            dest[2] = UPPER_HEX_DIGITS[cp & 0xF];
            dest[1] = UPPER_HEX_DIGITS[cp >>> 4];
            return dest;
        }
        if (cp <= 2047) {
            char[] dest = new char[6];
            dest[0] = 37;
            dest[3] = 37;
            dest[5] = UPPER_HEX_DIGITS[cp & 0xF];
            dest[4] = UPPER_HEX_DIGITS[8 | (cp >>>= 4) & 3];
            dest[2] = UPPER_HEX_DIGITS[(cp >>>= 2) & 0xF];
            dest[1] = UPPER_HEX_DIGITS[0xC | (cp >>>= 4)];
            return dest;
        }
        if (cp <= 65535) {
            char[] dest = new char[9];
            dest[0] = 37;
            dest[1] = 69;
            dest[3] = 37;
            dest[6] = 37;
            dest[8] = UPPER_HEX_DIGITS[cp & 0xF];
            dest[7] = UPPER_HEX_DIGITS[8 | (cp >>>= 4) & 3];
            dest[5] = UPPER_HEX_DIGITS[(cp >>>= 2) & 0xF];
            dest[4] = UPPER_HEX_DIGITS[8 | (cp >>>= 4) & 3];
            dest[2] = UPPER_HEX_DIGITS[cp >>>= 2];
            return dest;
        }
        if (cp <= 0x10FFFF) {
            char[] dest = new char[12];
            dest[0] = 37;
            dest[1] = 70;
            dest[3] = 37;
            dest[6] = 37;
            dest[9] = 37;
            dest[11] = UPPER_HEX_DIGITS[cp & 0xF];
            dest[10] = UPPER_HEX_DIGITS[8 | (cp >>>= 4) & 3];
            dest[8] = UPPER_HEX_DIGITS[(cp >>>= 2) & 0xF];
            dest[7] = UPPER_HEX_DIGITS[8 | (cp >>>= 4) & 3];
            dest[5] = UPPER_HEX_DIGITS[(cp >>>= 2) & 0xF];
            dest[4] = UPPER_HEX_DIGITS[8 | (cp >>>= 4) & 3];
            dest[2] = UPPER_HEX_DIGITS[(cp >>>= 2) & 7];
            return dest;
        }
        throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.Invalid unicode character value ").append(cp).toString());
    }

    private static int codePointAt(CharSequence seq, int index, int end) {
        if (index < end) {
            char c1;
            if ((c1 = seq.charAt(index++)) < '\ud800' || c1 > '\udfff') {
                return c1;
            }
            if (c1 <= '\udbff') {
                if (index == end) {
                    return -c1;
                }
                char c2 = seq.charAt(index);
                if (Character.isLowSurrogate((char)c2)) {
                    return Character.toCodePoint((char)c1, (char)c2);
                }
                throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.Expected low surrogate but got char '").append(c2).append((String)"org.rascalmpl.org.rascalmpl.' with value ").append((int)c2).append((String)"org.rascalmpl.org.rascalmpl. at index ").append(index).append((String)"org.rascalmpl.org.rascalmpl. in '").append((Object)seq).append((String)"org.rascalmpl.org.rascalmpl.'").toString());
            }
            throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.Unexpected low surrogate character '").append(c1).append((String)"org.rascalmpl.org.rascalmpl.' with value ").append((int)c1).append((String)"org.rascalmpl.org.rascalmpl. at index ").append(index - 1).append((String)"org.rascalmpl.org.rascalmpl. in '").append((Object)seq).append((String)"org.rascalmpl.org.rascalmpl.'").toString());
        }
        throw new IndexOutOfBoundsException((String)"org.rascalmpl.org.rascalmpl.Index exceeds specified range");
    }

    private static char[] growBuffer(char[] dest, int index, int size) {
        if (size < 0) {
            throw new AssertionError((Object)"org.rascalmpl.org.rascalmpl.Cannot increase internal buffer any further");
        }
        char[] copy = new char[size];
        if (index > 0) {
            System.arraycopy((Object)dest, (int)0, (Object)copy, (int)0, (int)index);
        }
        return copy;
    }
}

