/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.api.trace;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.common.AttributeKey;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.common.Attributes;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.internal.ApiUsageLogger;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.trace.PropagatedSpan;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.trace.SpanContext;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.trace.SpanContextKey;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.trace.StatusCode;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.context.Context;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.context.ImplicitContextKeyed;
import org.rascalmpl.org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.org.rascalmpl.java.lang.Double;
import org.rascalmpl.org.rascalmpl.java.lang.Long;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.time.Instant;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.org.rascalmpl.javax.annotation.Nullable;
import org.rascalmpl.org.rascalmpl.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface Span
extends ImplicitContextKeyed {
    public static Span current() {
        Span span = Context.current().get(SpanContextKey.KEY);
        return span == null ? Span.getInvalid() : span;
    }

    public static Span fromContext(Context context) {
        if (context == null) {
            ApiUsageLogger.log((String)"org.rascalmpl.org.rascalmpl.context is null");
            return Span.getInvalid();
        }
        Span span = context.get(SpanContextKey.KEY);
        return span == null ? Span.getInvalid() : span;
    }

    @Nullable
    public static Span fromContextOrNull(Context context) {
        if (context == null) {
            ApiUsageLogger.log((String)"org.rascalmpl.org.rascalmpl.context is null");
            return null;
        }
        return context.get(SpanContextKey.KEY);
    }

    public static Span getInvalid() {
        return PropagatedSpan.INVALID;
    }

    public static Span wrap(SpanContext spanContext) {
        if (spanContext == null) {
            ApiUsageLogger.log((String)"org.rascalmpl.org.rascalmpl.context is null");
            return Span.getInvalid();
        }
        return PropagatedSpan.create(spanContext);
    }

    default public Span setAttribute(String key, String value) {
        return this.setAttribute(AttributeKey.stringKey(key), value);
    }

    default public Span setAttribute(String key, long value) {
        return this.setAttribute(AttributeKey.longKey(key), Long.valueOf((long)value));
    }

    default public Span setAttribute(String key, double value) {
        return this.setAttribute(AttributeKey.doubleKey(key), Double.valueOf((double)value));
    }

    default public Span setAttribute(String key, boolean value) {
        return this.setAttribute(AttributeKey.booleanKey(key), Boolean.valueOf((boolean)value));
    }

    public <T extends Object> Span setAttribute(AttributeKey<T> var1, T var2);

    default public Span setAttribute(AttributeKey<Long> key, int value) {
        return this.setAttribute(key, Long.valueOf((long)value));
    }

    /*
     * Exception decompiling
     */
    default public Span setAllAttributes(Attributes attributes) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/org/rascalmpl/java/lang/Object;Lorg/rascalmpl/org/rascalmpl/java/lang/Object;)V
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    default public Span addEvent(String name) {
        return this.addEvent(name, Attributes.empty());
    }

    default public Span addEvent(String name, long timestamp, TimeUnit unit) {
        return this.addEvent(name, Attributes.empty(), timestamp, unit);
    }

    default public Span addEvent(String name, Instant timestamp) {
        if (timestamp == null) {
            return this.addEvent(name);
        }
        return this.addEvent(name, TimeUnit.SECONDS.toNanos(timestamp.getEpochSecond()) + (long)timestamp.getNano(), TimeUnit.NANOSECONDS);
    }

    public Span addEvent(String var1, Attributes var2);

    public Span addEvent(String var1, Attributes var2, long var3, TimeUnit var5);

    default public Span addEvent(String name, Attributes attributes, Instant timestamp) {
        if (timestamp == null) {
            return this.addEvent(name, attributes);
        }
        return this.addEvent(name, attributes, TimeUnit.SECONDS.toNanos(timestamp.getEpochSecond()) + (long)timestamp.getNano(), TimeUnit.NANOSECONDS);
    }

    default public Span setStatus(StatusCode statusCode) {
        return this.setStatus(statusCode, (String)"org.rascalmpl.org.rascalmpl.");
    }

    public Span setStatus(StatusCode var1, String var2);

    default public Span recordException(Throwable exception) {
        return this.recordException(exception, Attributes.empty());
    }

    public Span recordException(Throwable var1, Attributes var2);

    public Span updateName(String var1);

    default public Span addLink(SpanContext spanContext) {
        return this.addLink(spanContext, Attributes.empty());
    }

    default public Span addLink(SpanContext spanContext, Attributes attributes) {
        return this;
    }

    public void end();

    public void end(long var1, TimeUnit var3);

    default public void end(Instant timestamp) {
        if (timestamp == null) {
            this.end();
            return;
        }
        this.end(TimeUnit.SECONDS.toNanos(timestamp.getEpochSecond()) + (long)timestamp.getNano(), TimeUnit.NANOSECONDS);
    }

    public SpanContext getSpanContext();

    public boolean isRecording();

    @Override
    default public Context storeInContext(Context context) {
        return context.with(SpanContextKey.KEY, this);
    }

    private /* synthetic */ void lambda$setAllAttributes$0(AttributeKey attributeKey, Object value) {
        this.setAttribute(attributeKey, value);
    }
}

