/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.api.trace;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.internal.ApiUsageLogger;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.internal.OtelEncodingUtils;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.internal.TemporaryBuffers;
import org.rascalmpl.org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.javax.annotation.concurrent.Immutable;

@Immutable
public final class SpanId
extends Object {
    private static final int BYTES_LENGTH = 8;
    private static final int HEX_LENGTH = 16;
    private static final String INVALID = "org.rascalmpl.org.rascalmpl.0000000000000000";

    private SpanId() {
    }

    public static int getLength() {
        return 16;
    }

    public static String getInvalid() {
        return "org.rascalmpl.org.rascalmpl.0000000000000000";
    }

    public static boolean isValid(CharSequence spanId) {
        return spanId != null && spanId.length() == 16 && !"org.rascalmpl.org.rascalmpl.0000000000000000".contentEquals(spanId) && OtelEncodingUtils.isValidBase16String(spanId);
    }

    public static String fromBytes(byte[] spanIdBytes) {
        if (spanIdBytes == null || spanIdBytes.length < 8) {
            ApiUsageLogger.log((String)"org.rascalmpl.org.rascalmpl.spanIdBytes is null or too short");
            return "org.rascalmpl.org.rascalmpl.0000000000000000";
        }
        char[] result = TemporaryBuffers.chars(16);
        OtelEncodingUtils.bytesToBase16(spanIdBytes, result, 8);
        return new String(result, 0, 16);
    }

    public static String fromLong(long id) {
        if (id == 0L) {
            return SpanId.getInvalid();
        }
        char[] result = TemporaryBuffers.chars(16);
        OtelEncodingUtils.longToBase16String(id, result, 0);
        return new String(result, 0, 16);
    }
}

