/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.api.trace;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.internal.ApiUsageLogger;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.internal.OtelEncodingUtils;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.internal.TemporaryBuffers;
import org.rascalmpl.org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.javax.annotation.concurrent.Immutable;

@Immutable
public final class TraceId
extends Object {
    private static final int BYTES_LENGTH = 16;
    private static final int HEX_LENGTH = 32;
    private static final String INVALID = "org.rascalmpl.org.rascalmpl.00000000000000000000000000000000";

    private TraceId() {
    }

    public static int getLength() {
        return 32;
    }

    public static String getInvalid() {
        return "org.rascalmpl.org.rascalmpl.00000000000000000000000000000000";
    }

    public static boolean isValid(CharSequence traceId) {
        return traceId != null && traceId.length() == 32 && !"org.rascalmpl.org.rascalmpl.00000000000000000000000000000000".contentEquals(traceId) && OtelEncodingUtils.isValidBase16String(traceId);
    }

    public static String fromBytes(byte[] traceIdBytes) {
        if (traceIdBytes == null || traceIdBytes.length < 16) {
            ApiUsageLogger.log((String)"org.rascalmpl.org.rascalmpl.traceIdBytes is null or too short");
            return "org.rascalmpl.org.rascalmpl.00000000000000000000000000000000";
        }
        char[] result = TemporaryBuffers.chars(32);
        OtelEncodingUtils.bytesToBase16(traceIdBytes, result, 16);
        return new String(result, 0, 32);
    }

    public static String fromLongs(long traceIdLongHighPart, long traceIdLongLowPart) {
        if (traceIdLongHighPart == 0L && traceIdLongLowPart == 0L) {
            return TraceId.getInvalid();
        }
        char[] chars = TemporaryBuffers.chars(32);
        OtelEncodingUtils.longToBase16String(traceIdLongHighPart, chars, 0);
        OtelEncodingUtils.longToBase16String(traceIdLongLowPart, chars, 16);
        return new String(chars, 0, 32);
    }
}

