/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.api.trace.propagation;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.internal.OtelEncodingUtils;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.internal.TemporaryBuffers;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.trace.Span;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.trace.SpanContext;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.trace.SpanId;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.trace.TraceFlags;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.trace.TraceId;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.trace.TraceState;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.trace.propagation.internal.W3CTraceContextEncoding;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.context.Context;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.context.propagation.TextMapGetter;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.context.propagation.TextMapPropagator;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.context.propagation.TextMapSetter;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.org.rascalmpl.java.lang.Long;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.util.Arrays;
import org.rascalmpl.org.rascalmpl.java.util.Collection;
import org.rascalmpl.org.rascalmpl.java.util.Collections;
import org.rascalmpl.org.rascalmpl.java.util.HashSet;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.Set;
import org.rascalmpl.org.rascalmpl.java.util.logging.Logger;
import org.rascalmpl.org.rascalmpl.javax.annotation.Nullable;
import org.rascalmpl.org.rascalmpl.javax.annotation.concurrent.Immutable;

@Immutable
public final class W3CTraceContextPropagator
extends org.rascalmpl.org.rascalmpl.java.lang.Object
implements TextMapPropagator {
    private static final Logger logger = Logger.getLogger((String)W3CTraceContextPropagator.class.getName());
    static final String TRACE_PARENT = "org.rascalmpl.org.rascalmpl.traceparent";
    static final String TRACE_STATE = "org.rascalmpl.org.rascalmpl.tracestate";
    private static final List<String> FIELDS = Collections.unmodifiableList((List)Arrays.asList((org.rascalmpl.org.rascalmpl.java.lang.Object[])new String[]{"org.rascalmpl.org.rascalmpl.traceparent", "org.rascalmpl.org.rascalmpl.tracestate"}));
    private static final String VERSION = "org.rascalmpl.org.rascalmpl.00";
    private static final int VERSION_SIZE = 2;
    private static final char TRACEPARENT_DELIMITER = '-';
    private static final int TRACEPARENT_DELIMITER_SIZE = 1;
    private static final int TRACE_ID_HEX_SIZE = TraceId.getLength();
    private static final int SPAN_ID_HEX_SIZE = SpanId.getLength();
    private static final int TRACE_OPTION_HEX_SIZE = TraceFlags.getLength();
    private static final int TRACE_ID_OFFSET = 3;
    private static final int SPAN_ID_OFFSET = 3 + TRACE_ID_HEX_SIZE + 1;
    private static final int TRACE_OPTION_OFFSET = SPAN_ID_OFFSET + SPAN_ID_HEX_SIZE + 1;
    private static final int TRACEPARENT_HEADER_SIZE = TRACE_OPTION_OFFSET + TRACE_OPTION_HEX_SIZE;
    private static final Set<String> VALID_VERSIONS;
    private static final String VERSION_00 = "org.rascalmpl.org.rascalmpl.00";
    private static final W3CTraceContextPropagator INSTANCE;

    private W3CTraceContextPropagator() {
    }

    public static W3CTraceContextPropagator getInstance() {
        return INSTANCE;
    }

    @Override
    public Collection<String> fields() {
        return FIELDS;
    }

    @Override
    public <C extends org.rascalmpl.org.rascalmpl.java.lang.Object> void inject(Context context, @Nullable C carrier, TextMapSetter<C> setter) {
        if (context == null || setter == null) {
            return;
        }
        SpanContext spanContext = Span.fromContext(context).getSpanContext();
        if (!spanContext.isValid()) {
            return;
        }
        char[] chars = TemporaryBuffers.chars(TRACEPARENT_HEADER_SIZE);
        chars[0] = "org.rascalmpl.org.rascalmpl.00".charAt(0);
        chars[1] = "org.rascalmpl.org.rascalmpl.00".charAt(1);
        chars[2] = 45;
        String traceId = spanContext.getTraceId();
        traceId.getChars(0, traceId.length(), chars, 3);
        chars[W3CTraceContextPropagator.SPAN_ID_OFFSET - 1] = 45;
        String spanId = spanContext.getSpanId();
        spanId.getChars(0, spanId.length(), chars, SPAN_ID_OFFSET);
        chars[W3CTraceContextPropagator.TRACE_OPTION_OFFSET - 1] = 45;
        String traceFlagsHex = spanContext.getTraceFlags().asHex();
        chars[W3CTraceContextPropagator.TRACE_OPTION_OFFSET] = traceFlagsHex.charAt(0);
        chars[W3CTraceContextPropagator.TRACE_OPTION_OFFSET + 1] = traceFlagsHex.charAt(1);
        setter.set(carrier, (String)"org.rascalmpl.org.rascalmpl.traceparent", new String(chars, 0, TRACEPARENT_HEADER_SIZE));
        TraceState traceState = spanContext.getTraceState();
        if (traceState.isEmpty()) {
            return;
        }
        setter.set(carrier, (String)"org.rascalmpl.org.rascalmpl.tracestate", W3CTraceContextEncoding.encodeTraceState(traceState));
    }

    @Override
    public <C extends org.rascalmpl.org.rascalmpl.java.lang.Object> Context extract(Context context, @Nullable C carrier, TextMapGetter<C> getter) {
        if (context == null) {
            return Context.root();
        }
        if (getter == null) {
            return context;
        }
        SpanContext spanContext = W3CTraceContextPropagator.extractImpl(carrier, getter);
        if (!spanContext.isValid()) {
            return context;
        }
        return context.with(Span.wrap(spanContext));
    }

    private static <C extends org.rascalmpl.org.rascalmpl.java.lang.Object> SpanContext extractImpl(@Nullable C carrier, TextMapGetter<C> getter) {
        String traceParent = getter.get(carrier, (String)"org.rascalmpl.org.rascalmpl.traceparent");
        if (traceParent == null) {
            return SpanContext.getInvalid();
        }
        SpanContext contextFromParentHeader = W3CTraceContextPropagator.extractContextFromTraceParent(traceParent);
        if (!contextFromParentHeader.isValid()) {
            return contextFromParentHeader;
        }
        String traceStateHeader = getter.get(carrier, (String)"org.rascalmpl.org.rascalmpl.tracestate");
        if (traceStateHeader == null || traceStateHeader.isEmpty()) {
            return contextFromParentHeader;
        }
        try {
            TraceState traceState = W3CTraceContextEncoding.decodeTraceState(traceStateHeader);
            return SpanContext.createFromRemoteParent(contextFromParentHeader.getTraceId(), contextFromParentHeader.getSpanId(), contextFromParentHeader.getTraceFlags(), traceState);
        }
        catch (IllegalArgumentException e) {
            logger.fine((String)"org.rascalmpl.org.rascalmpl.Unparseable tracestate header. Returning span context without state.");
            return contextFromParentHeader;
        }
    }

    private static SpanContext extractContextFromTraceParent(String traceparent) {
        boolean isValid;
        boolean bl = isValid = (traceparent.length() == TRACEPARENT_HEADER_SIZE || traceparent.length() > TRACEPARENT_HEADER_SIZE && traceparent.charAt(TRACEPARENT_HEADER_SIZE) == '-') && traceparent.charAt(2) == '-' && traceparent.charAt(SPAN_ID_OFFSET - 1) == '-' && traceparent.charAt(TRACE_OPTION_OFFSET - 1) == '-';
        if (!isValid) {
            logger.fine((String)"org.rascalmpl.org.rascalmpl.Unparseable traceparent header. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        String version = traceparent.substring(0, 2);
        if (!VALID_VERSIONS.contains((org.rascalmpl.org.rascalmpl.java.lang.Object)version)) {
            return SpanContext.getInvalid();
        }
        if (version.equals((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.00") && traceparent.length() > TRACEPARENT_HEADER_SIZE) {
            return SpanContext.getInvalid();
        }
        String traceId = traceparent.substring(3, 3 + TraceId.getLength());
        String spanId = traceparent.substring(SPAN_ID_OFFSET, SPAN_ID_OFFSET + SpanId.getLength());
        char firstTraceFlagsChar = traceparent.charAt(TRACE_OPTION_OFFSET);
        char secondTraceFlagsChar = traceparent.charAt(TRACE_OPTION_OFFSET + 1);
        if (!OtelEncodingUtils.isValidBase16Character(firstTraceFlagsChar) || !OtelEncodingUtils.isValidBase16Character(secondTraceFlagsChar)) {
            return SpanContext.getInvalid();
        }
        TraceFlags traceFlags = TraceFlags.fromByte(OtelEncodingUtils.byteFromBase16(firstTraceFlagsChar, secondTraceFlagsChar));
        return SpanContext.createFromRemoteParent(traceId, spanId, traceFlags, TraceState.getDefault());
    }

    public String toString() {
        return "org.rascalmpl.org.rascalmpl.W3CTraceContextPropagator";
    }

    static {
        INSTANCE = new W3CTraceContextPropagator();
        VALID_VERSIONS = new HashSet();
        for (int i = 0; i < 255; ++i) {
            String version = Long.toHexString((long)i);
            if (version.length() < 2) {
                version = new StringBuilder().append('0').append(version).toString();
            }
            VALID_VERSIONS.add((org.rascalmpl.org.rascalmpl.java.lang.Object)version);
        }
    }
}

