/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.internal.shaded.jctools.queues;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.internal.shaded.jctools.queues.MessagePassingQueue;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.internal.shaded.jctools.util.PortableJvmInfo;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;

public final class MessagePassingQueueUtil
extends Object {
    public static <E extends Object> int drain(MessagePassingQueue<E> queue, MessagePassingQueue.Consumer<E> c, int limit) {
        E e;
        int i;
        if (null == c) {
            throw new IllegalArgumentException((String)"org.rascalmpl.org.rascalmpl.c is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.limit is negative: ").append(limit).toString());
        }
        if (limit == 0) {
            return 0;
        }
        for (i = 0; i < limit && (e = queue.relaxedPoll()) != null; ++i) {
            c.accept(e);
        }
        return i;
    }

    public static <E extends Object> int drain(MessagePassingQueue<E> queue, MessagePassingQueue.Consumer<E> c) {
        E e;
        if (null == c) {
            throw new IllegalArgumentException((String)"org.rascalmpl.org.rascalmpl.c is null");
        }
        int i = 0;
        while ((e = queue.relaxedPoll()) != null) {
            ++i;
            c.accept(e);
        }
        return i;
    }

    public static <E extends Object> void drain(MessagePassingQueue<E> queue, MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        if (null == c) {
            throw new IllegalArgumentException((String)"org.rascalmpl.org.rascalmpl.c is null");
        }
        if (null == wait) {
            throw new IllegalArgumentException((String)"org.rascalmpl.org.rascalmpl.wait is null");
        }
        if (null == exit) {
            throw new IllegalArgumentException((String)"org.rascalmpl.org.rascalmpl.exit condition is null");
        }
        int idleCounter = 0;
        while (exit.keepRunning()) {
            E e = queue.relaxedPoll();
            if (e == null) {
                idleCounter = wait.idle(idleCounter);
                continue;
            }
            idleCounter = 0;
            c.accept(e);
        }
    }

    public static <E extends Object> void fill(MessagePassingQueue<E> q, MessagePassingQueue.Supplier<E> s2, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        if (null == wait) {
            throw new IllegalArgumentException((String)"org.rascalmpl.org.rascalmpl.waiter is null");
        }
        if (null == exit) {
            throw new IllegalArgumentException((String)"org.rascalmpl.org.rascalmpl.exit condition is null");
        }
        int idleCounter = 0;
        while (exit.keepRunning()) {
            if (q.fill(s2, PortableJvmInfo.RECOMENDED_OFFER_BATCH) == 0) {
                idleCounter = wait.idle(idleCounter);
                continue;
            }
            idleCounter = 0;
        }
    }

    public static <E extends Object> int fillBounded(MessagePassingQueue<E> q, MessagePassingQueue.Supplier<E> s2) {
        return MessagePassingQueueUtil.fillInBatchesToLimit(q, s2, PortableJvmInfo.RECOMENDED_OFFER_BATCH, q.capacity());
    }

    public static <E extends Object> int fillInBatchesToLimit(MessagePassingQueue<E> q, MessagePassingQueue.Supplier<E> s2, int batch, int limit) {
        int filled;
        long result = 0L;
        do {
            if ((filled = q.fill(s2, batch)) != 0) continue;
            return (int)result;
        } while ((result += (long)filled) <= (long)limit);
        return (int)result;
    }

    public static <E extends Object> int fillUnbounded(MessagePassingQueue<E> q, MessagePassingQueue.Supplier<E> s2) {
        return MessagePassingQueueUtil.fillInBatchesToLimit(q, s2, PortableJvmInfo.RECOMENDED_OFFER_BATCH, 4096);
    }
}

