/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.internal;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.common.AttributeKey;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.common.Attributes;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.common.AttributesBuilder;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.internal.AttributeUtil;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.util.Collections;
import org.rascalmpl.org.rascalmpl.java.util.HashMap;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.java.util.function.BiConsumer;
import org.rascalmpl.org.rascalmpl.javax.annotation.Nullable;

public final class AttributesMap
extends HashMap<AttributeKey<?>, Object>
implements Attributes {
    private static final long serialVersionUID = -5072696312123632376L;
    private final long capacity;
    private final int lengthLimit;
    private int totalAddedValues = 0;

    private AttributesMap(long capacity, int lengthLimit) {
        this.capacity = capacity;
        this.lengthLimit = lengthLimit;
    }

    public static AttributesMap create(long capacity, int lengthLimit) {
        return new AttributesMap(capacity, lengthLimit);
    }

    public <T extends Object> void put(AttributeKey<T> key, T value) {
        ++this.totalAddedValues;
        if ((long)this.size() >= this.capacity && !this.containsKey(key)) {
            return;
        }
        super.put(key, AttributeUtil.applyAttributeLengthLimit(value, this.lengthLimit));
    }

    public int getTotalAddedValues() {
        return this.totalAddedValues;
    }

    @Override
    @Nullable
    public <T extends Object> T get(AttributeKey<T> key) {
        return (T)super.get(key);
    }

    @Override
    public Map<AttributeKey<?>, Object> asMap() {
        return Collections.unmodifiableMap((Map)this);
    }

    @Override
    public AttributesBuilder toBuilder() {
        return Attributes.builder().putAll(this);
    }

    @Override
    public void forEach(BiConsumer<? super AttributeKey<?>, ? super Object> action) {
        super.forEach(action);
    }

    public String toString() {
        return new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.AttributesMap{data=").append(super.toString()).append((String)"org.rascalmpl.org.rascalmpl., capacity=").append(this.capacity).append((String)"org.rascalmpl.org.rascalmpl., totalAddedValues=").append(this.totalAddedValues).append('}').toString();
    }

    public Attributes immutableCopy() {
        return Attributes.builder().putAll(this).build();
    }
}

