/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.internal;

import org.rascalmpl.org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.org.rascalmpl.java.lang.IndexOutOfBoundsException;
import org.rascalmpl.org.rascalmpl.java.lang.Long;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.util.AbstractList;
import org.rascalmpl.org.rascalmpl.java.util.Arrays;

public class DynamicPrimitiveLongList
extends AbstractList<Long> {
    private static final int DEFAULT_SUBARRAY_CAPACITY = 10;
    private final int subarrayCapacity;
    private long[][] arrays;
    private int size;
    private int arrayCount;

    public static DynamicPrimitiveLongList of(long ... values) {
        DynamicPrimitiveLongList list = new DynamicPrimitiveLongList();
        list.resizeAndClear(values.length);
        for (int i = 0; i < values.length; ++i) {
            list.setLong(i, values[i]);
        }
        return list;
    }

    public static DynamicPrimitiveLongList ofSubArrayCapacity(int subarrayCapacity) {
        return new DynamicPrimitiveLongList(subarrayCapacity);
    }

    public static DynamicPrimitiveLongList empty() {
        return new DynamicPrimitiveLongList();
    }

    DynamicPrimitiveLongList() {
        this(10);
    }

    DynamicPrimitiveLongList(int subarrayCapacity) {
        if (subarrayCapacity <= 0) {
            throw new IllegalArgumentException((String)"org.rascalmpl.org.rascalmpl.Subarray capacity must be positive");
        }
        this.subarrayCapacity = subarrayCapacity;
        this.arrays = new long[0][subarrayCapacity];
        this.arrayCount = 0;
        this.size = 0;
    }

    public Long get(int index) {
        return Long.valueOf((long)this.getLong(index));
    }

    public long getLong(int index) {
        this.rangeCheck(index);
        return this.arrays[index / this.subarrayCapacity][index % this.subarrayCapacity];
    }

    public Long set(int index, Long element) {
        return Long.valueOf((long)this.setLong(index, element.longValue()));
    }

    public long setLong(int index, long element) {
        this.rangeCheck(index);
        long oldValue = this.arrays[index / this.subarrayCapacity][index % this.subarrayCapacity];
        this.arrays[index / this.subarrayCapacity][index % this.subarrayCapacity] = element;
        return oldValue;
    }

    public int size() {
        return this.size;
    }

    public void resizeAndClear(int newSize) {
        if (newSize < 0) {
            throw new IllegalArgumentException((String)"org.rascalmpl.org.rascalmpl.New size must be non-negative");
        }
        this.ensureCapacity(newSize);
        this.size = newSize;
        for (int i = 0; i < newSize; ++i) {
            this.setLong(i, 0L);
        }
    }

    private void ensureCapacity(int minCapacity) {
        int requiredArrays = (minCapacity + this.subarrayCapacity - 1) / this.subarrayCapacity;
        if (requiredArrays > this.arrayCount) {
            this.arrays = (long[][])Arrays.copyOf((Object[])this.arrays, (int)requiredArrays);
            for (int i = this.arrayCount; i < requiredArrays; ++i) {
                this.arrays[i] = new long[this.subarrayCapacity];
            }
            this.arrayCount = requiredArrays;
        }
    }

    private void rangeCheck(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private String outOfBoundsMsg(int index) {
        return new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.Index: ").append(index).append((String)"org.rascalmpl.org.rascalmpl., Size: ").append(this.size).toString();
    }
}

