/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.logs;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.internal.Utils;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.logs.LogLimits;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;

public final class LogLimitsBuilder
extends Object {
    private static final int DEFAULT_LOG_MAX_NUM_ATTRIBUTES = 128;
    private static final int DEFAULT_LOG_MAX_ATTRIBUTE_LENGTH = Integer.MAX_VALUE;
    private int maxNumAttributes = 128;
    private int maxAttributeValueLength = Integer.MAX_VALUE;

    LogLimitsBuilder() {
    }

    public LogLimitsBuilder setMaxNumberOfAttributes(int maxNumberOfAttributes) {
        Utils.checkArgument(maxNumberOfAttributes > 0, (String)"org.rascalmpl.org.rascalmpl.maxNumberOfAttributes must be greater than 0");
        this.maxNumAttributes = maxNumberOfAttributes;
        return this;
    }

    public LogLimitsBuilder setMaxAttributeValueLength(int maxAttributeValueLength) {
        Utils.checkArgument(maxAttributeValueLength > -1, (String)"org.rascalmpl.org.rascalmpl.maxAttributeValueLength must be non-negative");
        this.maxAttributeValueLength = maxAttributeValueLength;
        return this;
    }

    public LogLimits build() {
        return LogLimits.create(this.maxNumAttributes, this.maxAttributeValueLength);
    }
}

