/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.logs;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.context.Context;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.common.CompletableResultCode;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.logs.MultiLogRecordProcessor;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.logs.NoopLogRecordProcessor;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.logs.ReadWriteLogRecord;
import org.rascalmpl.org.rascalmpl.java.io.Closeable;
import org.rascalmpl.org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.org.rascalmpl.java.util.Arrays;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.org.rascalmpl.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface LogRecordProcessor
extends Closeable {
    public static LogRecordProcessor composite(LogRecordProcessor ... processors) {
        return LogRecordProcessor.composite((Iterable<LogRecordProcessor>)Arrays.asList((Object[])processors));
    }

    public static LogRecordProcessor composite(Iterable<LogRecordProcessor> processors) {
        ArrayList processorList = new ArrayList();
        for (LogRecordProcessor processor : processors) {
            processorList.add((Object)processor);
        }
        if (processorList.isEmpty()) {
            return NoopLogRecordProcessor.getInstance();
        }
        if (processorList.size() == 1) {
            return (LogRecordProcessor)processorList.get(0);
        }
        return MultiLogRecordProcessor.create((List<LogRecordProcessor>)processorList);
    }

    public void onEmit(Context var1, ReadWriteLogRecord var2);

    default public CompletableResultCode shutdown() {
        return this.forceFlush();
    }

    default public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofSuccess();
    }

    default public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }
}

