/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.logs;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.common.Clock;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.common.CompletableResultCode;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.logs.LogLimits;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.logs.LogRecordProcessor;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.resources.Resource;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.util.function.Supplier;
import org.rascalmpl.org.rascalmpl.javax.annotation.Nullable;

final class LoggerSharedState
extends Object {
    private final Object lock = new Object();
    private final Resource resource;
    private final Supplier<LogLimits> logLimitsSupplier;
    private final LogRecordProcessor logRecordProcessor;
    private final Clock clock;
    @Nullable
    private volatile CompletableResultCode shutdownResult = null;

    LoggerSharedState(Resource resource, Supplier<LogLimits> logLimitsSupplier, LogRecordProcessor logRecordProcessor, Clock clock) {
        this.resource = resource;
        this.logLimitsSupplier = logLimitsSupplier;
        this.logRecordProcessor = logRecordProcessor;
        this.clock = clock;
    }

    Resource getResource() {
        return this.resource;
    }

    LogLimits getLogLimits() {
        return (LogLimits)this.logLimitsSupplier.get();
    }

    LogRecordProcessor getLogRecordProcessor() {
        return this.logRecordProcessor;
    }

    Clock getClock() {
        return this.clock;
    }

    boolean hasBeenShutdown() {
        return this.shutdownResult != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableResultCode shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdownResult != null) {
                return this.shutdownResult;
            }
            this.shutdownResult = this.logRecordProcessor.shutdown();
            return this.shutdownResult;
        }
    }
}

