/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.logs.export;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.common.AttributeKey;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.common.Attributes;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.metrics.LongCounter;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.metrics.MeterProvider;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.metrics.ObservableLongMeasurement;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.context.Context;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.common.CompletableResultCode;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.internal.DaemonThreadFactory;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.logs.LogRecordProcessor;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.logs.ReadWriteLogRecord;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.logs.data.LogRecordData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.logs.export.BatchLogRecordProcessorBuilder;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.logs.export.LogRecordExporter;
import org.rascalmpl.org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.org.rascalmpl.java.lang.InterruptedException;
import org.rascalmpl.org.rascalmpl.java.lang.Runnable;
import org.rascalmpl.org.rascalmpl.java.lang.RuntimeException;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.System;
import org.rascalmpl.org.rascalmpl.java.lang.Thread;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.org.rascalmpl.java.util.Collection;
import org.rascalmpl.org.rascalmpl.java.util.Collections;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.Queue;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.ArrayBlockingQueue;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.BlockingQueue;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.atomic.AtomicBoolean;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.atomic.AtomicInteger;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.atomic.AtomicReference;
import org.rascalmpl.org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.org.rascalmpl.java.util.logging.Logger;

public final class BatchLogRecordProcessor
extends org.rascalmpl.org.rascalmpl.java.lang.Object
implements LogRecordProcessor {
    private static final String WORKER_THREAD_NAME = new StringBuilder().append(BatchLogRecordProcessor.class.getSimpleName()).append((String)"org.rascalmpl.org.rascalmpl._WorkerThread").toString();
    private static final AttributeKey<String> LOG_RECORD_PROCESSOR_TYPE_LABEL = AttributeKey.stringKey((String)"org.rascalmpl.org.rascalmpl.processorType");
    private static final AttributeKey<Boolean> LOG_RECORD_PROCESSOR_DROPPED_LABEL = AttributeKey.booleanKey((String)"org.rascalmpl.org.rascalmpl.dropped");
    private static final String LOG_RECORD_PROCESSOR_TYPE_VALUE = BatchLogRecordProcessor.class.getSimpleName();
    private final Worker worker;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);

    public static BatchLogRecordProcessorBuilder builder(LogRecordExporter logRecordExporter) {
        return new BatchLogRecordProcessorBuilder(logRecordExporter);
    }

    BatchLogRecordProcessor(LogRecordExporter logRecordExporter, MeterProvider meterProvider, long scheduleDelayNanos, int maxQueueSize, int maxExportBatchSize, long exporterTimeoutNanos) {
        this.worker = new Worker(logRecordExporter, meterProvider, scheduleDelayNanos, maxExportBatchSize, exporterTimeoutNanos, (Queue)new ArrayBlockingQueue(maxQueueSize));
        Thread workerThread = new DaemonThreadFactory(WORKER_THREAD_NAME).newThread(this.worker);
        workerThread.start();
    }

    @Override
    public void onEmit(Context context, ReadWriteLogRecord logRecord) {
        if (logRecord == null) {
            return;
        }
        this.worker.addLog(logRecord);
    }

    @Override
    public CompletableResultCode shutdown() {
        if (this.isShutdown.getAndSet(true)) {
            return CompletableResultCode.ofSuccess();
        }
        return this.worker.shutdown();
    }

    @Override
    public CompletableResultCode forceFlush() {
        return this.worker.forceFlush();
    }

    public LogRecordExporter getLogRecordExporter() {
        return this.worker.logRecordExporter;
    }

    List<LogRecordData> getBatch() {
        return this.worker.batch;
    }

    public String toString() {
        return new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.BatchLogRecordProcessor{logRecordExporter=").append((org.rascalmpl.org.rascalmpl.java.lang.Object)this.worker.logRecordExporter).append((String)"org.rascalmpl.org.rascalmpl., scheduleDelayNanos=").append(this.worker.scheduleDelayNanos).append((String)"org.rascalmpl.org.rascalmpl., maxExportBatchSize=").append(this.worker.maxExportBatchSize).append((String)"org.rascalmpl.org.rascalmpl., exporterTimeoutNanos=").append(this.worker.exporterTimeoutNanos).append('}').toString();
    }

    static /* synthetic */ AttributeKey access$1100() {
        return LOG_RECORD_PROCESSOR_DROPPED_LABEL;
    }

    private static final class Worker
    extends org.rascalmpl.org.rascalmpl.java.lang.Object
    implements Runnable {
        private static final Logger logger = Logger.getLogger((String)Worker.class.getName());
        private final LongCounter processedLogsCounter;
        private final Attributes droppedAttrs;
        private final Attributes exportedAttrs;
        private final LogRecordExporter logRecordExporter;
        private final long scheduleDelayNanos;
        private final int maxExportBatchSize;
        private final long exporterTimeoutNanos;
        private long nextExportTime;
        private final Queue<ReadWriteLogRecord> queue;
        private final AtomicInteger logsNeeded;
        private final BlockingQueue<Boolean> signal;
        private final AtomicReference<CompletableResultCode> flushRequested;
        private volatile boolean continueWork;
        private final ArrayList<LogRecordData> batch;

        /*
         * Exception decompiling
         */
        private Worker(LogRecordExporter logRecordExporter, MeterProvider meterProvider, long scheduleDelayNanos, int maxExportBatchSize, long exporterTimeoutNanos, Queue<ReadWriteLogRecord> queue) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/org/rascalmpl/java/lang/Object;)V
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
             *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void addLog(ReadWriteLogRecord logData) {
            if (!this.queue.offer((org.rascalmpl.org.rascalmpl.java.lang.Object)logData)) {
                this.processedLogsCounter.add(1L, this.droppedAttrs);
            } else if (this.queue.size() >= this.logsNeeded.get()) {
                this.signal.offer((org.rascalmpl.org.rascalmpl.java.lang.Object)Boolean.valueOf((boolean)true));
            }
        }

        public void run() {
            this.updateNextExportTime();
            while (this.continueWork) {
                if (this.flushRequested.get() != null) {
                    this.flush();
                }
                while (!this.queue.isEmpty() && this.batch.size() < this.maxExportBatchSize) {
                    this.batch.add((org.rascalmpl.org.rascalmpl.java.lang.Object)((ReadWriteLogRecord)this.queue.poll()).toLogRecordData());
                }
                if (this.batch.size() >= this.maxExportBatchSize || System.nanoTime() >= this.nextExportTime) {
                    this.exportCurrentBatch();
                    this.updateNextExportTime();
                }
                if (!this.queue.isEmpty()) continue;
                try {
                    long pollWaitTime = this.nextExportTime - System.nanoTime();
                    if (pollWaitTime <= 0L) continue;
                    this.logsNeeded.set(this.maxExportBatchSize - this.batch.size());
                    this.signal.poll(pollWaitTime, TimeUnit.NANOSECONDS);
                    this.logsNeeded.set(Integer.MAX_VALUE);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }

        private void flush() {
            for (int logsToFlush = this.queue.size(); logsToFlush > 0; --logsToFlush) {
                ReadWriteLogRecord logRecord = (ReadWriteLogRecord)this.queue.poll();
                if (!$assertionsDisabled && logRecord == null) {
                    throw new AssertionError();
                }
                this.batch.add((org.rascalmpl.org.rascalmpl.java.lang.Object)logRecord.toLogRecordData());
                if (this.batch.size() < this.maxExportBatchSize) continue;
                this.exportCurrentBatch();
            }
            this.exportCurrentBatch();
            CompletableResultCode flushResult = (CompletableResultCode)this.flushRequested.get();
            if (flushResult != null) {
                flushResult.succeed();
                this.flushRequested.set(null);
            }
        }

        private void updateNextExportTime() {
            this.nextExportTime = System.nanoTime() + this.scheduleDelayNanos;
        }

        /*
         * Exception decompiling
         */
        private CompletableResultCode shutdown() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.org.rascalmpl.java.lang.invoke.MethodType, got ()V
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
             *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private CompletableResultCode forceFlush() {
            CompletableResultCode possibleResult;
            CompletableResultCode flushResult = new CompletableResultCode();
            if (this.flushRequested.compareAndSet(null, (org.rascalmpl.org.rascalmpl.java.lang.Object)flushResult)) {
                this.signal.offer((org.rascalmpl.org.rascalmpl.java.lang.Object)Boolean.valueOf((boolean)true));
            }
            return (possibleResult = (CompletableResultCode)this.flushRequested.get()) == null ? CompletableResultCode.ofSuccess() : possibleResult;
        }

        private void exportCurrentBatch() {
            if (this.batch.isEmpty()) {
                return;
            }
            try {
                CompletableResultCode result = this.logRecordExporter.export((Collection<LogRecordData>)Collections.unmodifiableList(this.batch));
                result.join(this.exporterTimeoutNanos, TimeUnit.NANOSECONDS);
                if (result.isSuccess()) {
                    this.processedLogsCounter.add(this.batch.size(), this.exportedAttrs);
                } else {
                    logger.log(Level.FINE, (String)"org.rascalmpl.org.rascalmpl.Exporter failed");
                }
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, (String)"org.rascalmpl.org.rascalmpl.Exporter threw an Exception", (Throwable)((Object)e));
            }
            finally {
                this.batch.clear();
            }
        }

        /*
         * Exception decompiling
         */
        private /* synthetic */ void lambda$shutdown$2(CompletableResultCode flushResult, CompletableResultCode result) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.org.rascalmpl.java.lang.invoke.MethodType, got ()V
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
             *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static /* synthetic */ void lambda$shutdown$1(CompletableResultCode flushResult, CompletableResultCode shutdownResult, CompletableResultCode result) {
            if (!flushResult.isSuccess() || !shutdownResult.isSuccess()) {
                result.fail();
            } else {
                result.succeed();
            }
        }

        private static /* synthetic */ void lambda$new$0(Queue queue, ObservableLongMeasurement result) {
            result.record(queue.size(), Attributes.of(LOG_RECORD_PROCESSOR_TYPE_LABEL, LOG_RECORD_PROCESSOR_TYPE_VALUE));
        }
    }
}

