/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.logs.export;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.common.CompletableResultCode;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.logs.data.LogRecordData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.logs.export.LogRecordExporter;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.RuntimeException;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.org.rascalmpl.java.util.Arrays;
import org.rascalmpl.org.rascalmpl.java.util.Collection;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.org.rascalmpl.java.util.logging.Logger;

final class MultiLogRecordExporter
extends Object
implements LogRecordExporter {
    private static final Logger logger = Logger.getLogger((String)MultiLogRecordExporter.class.getName());
    private final LogRecordExporter[] logRecordExporters;

    private MultiLogRecordExporter(LogRecordExporter[] logRecordExporters) {
        this.logRecordExporters = logRecordExporters;
    }

    static LogRecordExporter create(List<LogRecordExporter> logRecordExporters) {
        return new MultiLogRecordExporter((LogRecordExporter[])logRecordExporters.toArray((Object[])new LogRecordExporter[0]));
    }

    @Override
    public CompletableResultCode export(Collection<LogRecordData> logs) {
        ArrayList results = new ArrayList(this.logRecordExporters.length);
        for (LogRecordExporter logRecordExporter : this.logRecordExporters) {
            CompletableResultCode exportResult;
            try {
                exportResult = logRecordExporter.export(logs);
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, (String)"org.rascalmpl.org.rascalmpl.Exception thrown by the export.", (Throwable)((java.lang.Object)e));
                results.add((Object)CompletableResultCode.ofFailure());
                continue;
            }
            results.add((Object)exportResult);
        }
        return CompletableResultCode.ofAll((Collection<CompletableResultCode>)results);
    }

    @Override
    public CompletableResultCode flush() {
        ArrayList results = new ArrayList(this.logRecordExporters.length);
        for (LogRecordExporter logRecordExporter : this.logRecordExporters) {
            CompletableResultCode flushResult;
            try {
                flushResult = logRecordExporter.flush();
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, (String)"org.rascalmpl.org.rascalmpl.Exception thrown by the flush.", (Throwable)((java.lang.Object)e));
                results.add((Object)CompletableResultCode.ofFailure());
                continue;
            }
            results.add((Object)flushResult);
        }
        return CompletableResultCode.ofAll((Collection<CompletableResultCode>)results);
    }

    @Override
    public CompletableResultCode shutdown() {
        ArrayList results = new ArrayList(this.logRecordExporters.length);
        for (LogRecordExporter logRecordExporter : this.logRecordExporters) {
            CompletableResultCode shutdownResult;
            try {
                shutdownResult = logRecordExporter.shutdown();
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, (String)"org.rascalmpl.org.rascalmpl.Exception thrown by the shutdown.", (Throwable)((java.lang.Object)e));
                results.add((Object)CompletableResultCode.ofFailure());
                continue;
            }
            results.add((Object)shutdownResult);
        }
        return CompletableResultCode.ofAll((Collection<CompletableResultCode>)results);
    }

    public String toString() {
        return new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.MultiLogRecordExporter{logRecordExporters=").append(Arrays.toString((Object[])this.logRecordExporters)).append('}').toString();
    }
}

