/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.logs.internal;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.incubator.events.EventBuilder;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.incubator.events.EventLogger;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.incubator.events.EventLoggerBuilder;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.incubator.events.EventLoggerProvider;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.logs.Logger;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.logs.LoggerBuilder;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.logs.LoggerProvider;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.logs.Severity;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.context.Context;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.common.Clock;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.logs.internal.SdkEventBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;

public final class SdkEventLoggerProvider
extends Object
implements EventLoggerProvider {
    private static final Severity DEFAULT_SEVERITY = Severity.INFO;
    private final LoggerProvider delegateLoggerProvider;
    private final Clock clock;

    private SdkEventLoggerProvider(LoggerProvider delegateLoggerProvider, Clock clock) {
        this.delegateLoggerProvider = delegateLoggerProvider;
        this.clock = clock;
    }

    public static SdkEventLoggerProvider create(LoggerProvider delegateLoggerProvider) {
        return new SdkEventLoggerProvider(delegateLoggerProvider, Clock.getDefault());
    }

    public static SdkEventLoggerProvider create(LoggerProvider delegateLoggerProvider, Clock clock) {
        return new SdkEventLoggerProvider(delegateLoggerProvider, clock);
    }

    @Override
    public EventLogger get(String instrumentationScopeName) {
        return this.eventLoggerBuilder(instrumentationScopeName).build();
    }

    @Override
    public EventLoggerBuilder eventLoggerBuilder(String instrumentationScopeName) {
        return new SdkEventLoggerBuilder(this.clock, this.delegateLoggerProvider.loggerBuilder(instrumentationScopeName));
    }

    private static class SdkEventLoggerBuilder
    extends Object
    implements EventLoggerBuilder {
        private final Clock clock;
        private final LoggerBuilder delegateLoggerBuilder;

        private SdkEventLoggerBuilder(Clock clock, LoggerBuilder delegateLoggerBuilder) {
            this.clock = clock;
            this.delegateLoggerBuilder = delegateLoggerBuilder;
        }

        @Override
        public EventLoggerBuilder setSchemaUrl(String schemaUrl) {
            this.delegateLoggerBuilder.setSchemaUrl(schemaUrl);
            return this;
        }

        @Override
        public EventLoggerBuilder setInstrumentationVersion(String instrumentationScopeVersion) {
            this.delegateLoggerBuilder.setInstrumentationVersion(instrumentationScopeVersion);
            return this;
        }

        @Override
        public EventLogger build() {
            return new SdkEventLogger(this.clock, this.delegateLoggerBuilder.build());
        }
    }

    private static class SdkEventLogger
    extends Object
    implements EventLogger {
        private final Clock clock;
        private final Logger delegateLogger;

        private SdkEventLogger(Clock clock, Logger delegateLogger) {
            this.clock = clock;
            this.delegateLogger = delegateLogger;
        }

        @Override
        public EventBuilder builder(String eventName) {
            return new SdkEventBuilder(this.clock, this.delegateLogger.logRecordBuilder().setSeverity(DEFAULT_SEVERITY).setContext(Context.current()), eventName);
        }
    }
}

