/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.metrics.BatchCallback;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.metrics.DoubleGaugeBuilder;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.metrics.LongCounterBuilder;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.metrics.LongUpDownCounterBuilder;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.metrics.Meter;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.metrics.MeterProvider;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.metrics.ObservableMeasurement;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.SdkDoubleGauge;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.SdkDoubleHistogram;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.SdkLongCounter;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.SdkLongUpDownCounter;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.SdkObservableInstrument;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.data.MetricData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.MeterConfig;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.export.RegisteredReader;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.state.CallbackRegistration;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.state.SdkObservableMeasurement;
import org.rascalmpl.org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.org.rascalmpl.java.lang.Runnable;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.org.rascalmpl.java.util.Collection;
import org.rascalmpl.org.rascalmpl.java.util.Collections;
import org.rascalmpl.org.rascalmpl.java.util.HashSet;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.org.rascalmpl.java.util.logging.Logger;
import org.rascalmpl.org.rascalmpl.java.util.regex.Pattern;

final class SdkMeter
extends org.rascalmpl.org.rascalmpl.java.lang.Object
implements Meter {
    private static final Logger logger = Logger.getLogger((String)SdkMeter.class.getName());
    private static final Pattern VALID_INSTRUMENT_NAME_PATTERN = Pattern.compile((String)"org/rascalmpl/org/rascalmpl/([A-Za-z]){1}([A-Za-z0-9\\_\\-\\./]){0,254}");
    private static final Meter NOOP_METER = MeterProvider.noop().get((String)"org.rascalmpl.org.rascalmpl.noop");
    private static final String NOOP_INSTRUMENT_NAME = "org.rascalmpl.org.rascalmpl.noop";
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final MeterProviderSharedState meterProviderSharedState;
    private final MeterSharedState meterSharedState;
    private final MeterConfig meterConfig;

    SdkMeter(MeterProviderSharedState meterProviderSharedState, InstrumentationScopeInfo instrumentationScopeInfo, List<RegisteredReader> registeredReaders, MeterConfig meterConfig) {
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.meterProviderSharedState = meterProviderSharedState;
        this.meterSharedState = MeterSharedState.create(instrumentationScopeInfo, registeredReaders);
        this.meterConfig = meterConfig;
    }

    InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    Collection<MetricData> collectAll(RegisteredReader registeredReader, long epochNanos) {
        return this.meterSharedState.collectAll(registeredReader, this.meterProviderSharedState, epochNanos);
    }

    void resetForTest() {
        this.meterSharedState.resetForTest();
    }

    @Override
    public LongCounterBuilder counterBuilder(String name) {
        return this.meterConfig.isEnabled() && SdkMeter.checkValidInstrumentName(name) ? new SdkLongCounter.SdkLongCounterBuilder(this.meterProviderSharedState, this.meterSharedState, name) : NOOP_METER.counterBuilder((String)"org.rascalmpl.org.rascalmpl.noop");
    }

    @Override
    public LongUpDownCounterBuilder upDownCounterBuilder(String name) {
        return this.meterConfig.isEnabled() && SdkMeter.checkValidInstrumentName(name) ? new SdkLongUpDownCounter.SdkLongUpDownCounterBuilder(this.meterProviderSharedState, this.meterSharedState, name) : NOOP_METER.upDownCounterBuilder((String)"org.rascalmpl.org.rascalmpl.noop");
    }

    @Override
    public DoubleHistogramBuilder histogramBuilder(String name) {
        return this.meterConfig.isEnabled() && SdkMeter.checkValidInstrumentName(name) ? new SdkDoubleHistogram.SdkDoubleHistogramBuilder(this.meterProviderSharedState, this.meterSharedState, name) : NOOP_METER.histogramBuilder((String)"org.rascalmpl.org.rascalmpl.noop");
    }

    @Override
    public DoubleGaugeBuilder gaugeBuilder(String name) {
        return this.meterConfig.isEnabled() && SdkMeter.checkValidInstrumentName(name) ? new SdkDoubleGauge.SdkDoubleGaugeBuilder(this.meterProviderSharedState, this.meterSharedState, name) : NOOP_METER.gaugeBuilder((String)"org.rascalmpl.org.rascalmpl.noop");
    }

    @Override
    public BatchCallback batchCallback(Runnable callback, ObservableMeasurement observableMeasurement, ObservableMeasurement ... additionalMeasurements) {
        if (!this.meterConfig.isEnabled()) {
            return NOOP_METER.batchCallback(callback, observableMeasurement, additionalMeasurements);
        }
        HashSet measurements = new HashSet();
        measurements.add((org.rascalmpl.org.rascalmpl.java.lang.Object)observableMeasurement);
        Collections.addAll((Collection)measurements, (org.rascalmpl.org.rascalmpl.java.lang.Object[])additionalMeasurements);
        ArrayList sdkMeasurements = new ArrayList();
        for (ObservableMeasurement measurement : measurements) {
            if (!(measurement instanceof SdkObservableMeasurement)) {
                logger.log(Level.WARNING, (String)"org.rascalmpl.org.rascalmpl.batchCallback called with instruments that were not created by the SDK.");
                continue;
            }
            SdkObservableMeasurement sdkMeasurement = (SdkObservableMeasurement)measurement;
            if (!this.meterSharedState.getInstrumentationScopeInfo().equals(sdkMeasurement.getInstrumentationScopeInfo())) {
                logger.log(Level.WARNING, (String)"org.rascalmpl.org.rascalmpl.batchCallback called with instruments that belong to a different Meter.");
                continue;
            }
            sdkMeasurements.add((org.rascalmpl.org.rascalmpl.java.lang.Object)sdkMeasurement);
        }
        CallbackRegistration callbackRegistration = CallbackRegistration.create((List<SdkObservableMeasurement>)sdkMeasurements, callback);
        this.meterSharedState.registerCallback(callbackRegistration);
        return new SdkObservableInstrument(this.meterSharedState, callbackRegistration);
    }

    public String toString() {
        return new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.SdkMeter{instrumentationScopeInfo=").append((org.rascalmpl.org.rascalmpl.java.lang.Object)this.instrumentationScopeInfo).append((String)"org.rascalmpl.org.rascalmpl.}").toString();
    }

    static boolean checkValidInstrumentName(String name) {
        if (name != null && VALID_INSTRUMENT_NAME_PATTERN.matcher((CharSequence)name).matches()) {
            return true;
        }
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.Instrument name \"").append(name).append((String)"org/rascalmpl/org/rascalmpl/\" is invalid, returning noop instrument. Instrument names must consist of 255 or fewer characters including alphanumeric, _, ., -, /, and start with a letter.").toString(), (Throwable)new AssertionError());
        }
        return false;
    }
}

